/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.ExecutionEnvironmentExtension;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.apache.sling.feature.maven.mojos.apis.ApisJarContext;
import org.apache.sling.feature.maven.mojos.apis.ApisUtil;
import org.apache.sling.feature.maven.mojos.apis.JavadocExecutor;
import org.apache.sling.feature.maven.mojos.apis.JavadocLinks;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

@Mojo(name="apis-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ApisJarMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig selection;
    @Parameter
    private String[] includeResources;
    @Parameter(defaultValue="*")
    private Set<String> includeRegions;
    @Parameter
    private Set<String> excludeRegions;
    @Parameter
    private String[] javadocLinks;
    @Parameter(defaultValue="false")
    private boolean ignoreJavadocErrors;
    @Parameter(defaultValue="true")
    private boolean incrementalApis;
    @Parameter
    private List<File> apiResources;
    @Parameter
    private List<File> apiSourceResources;
    @Parameter
    private List<File> apiJavadocResources;
    @Parameter(defaultValue="true")
    private boolean attachApiJars;
    @Parameter
    private Map<String, String> apiRegionNameMappings;
    @Parameter
    private Map<String, String> apiClassifierMappings;
    @Parameter(defaultValue="true")
    private boolean generateApiJar;
    @Parameter(defaultValue="true")
    private boolean generateSourceJar;
    @Parameter(defaultValue="true")
    private boolean generateJavadocJar;
    @Parameter(defaultValue="8")
    private String javadocSourceLevel;
    @Parameter
    private String apiVersion;
    @Parameter(defaultValue="META-INF,SLING-INF")
    private String resourceFolders;
    @Parameter
    private String licenseReport;
    @Parameter
    private List<String> licenseDefaults;
    @Parameter(defaultValue="This archive contains files from the following artifacts:")
    private String licenseReportHeader;
    @Parameter
    private String licenseReportFooter;
    @Parameter(defaultValue="false")
    private boolean useApiDependencies;
    @Parameter
    private String apiRepositoryUrls;
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter
    private final Properties manifestProperties = new Properties();
    @Parameter(defaultValue="false")
    private boolean failOnMissingSourcesForJavadoc;
    @Parameter(defaultValue="true")
    private boolean javadocIndex;
    @Parameter(defaultValue="true")
    private boolean javadocTree;
    @Parameter
    private List<String> javadocClasspathRemovals;
    @Parameter
    private List<String> javadocClasspathHighestVersions;
    @Parameter
    private List<String> javadocClasspathTops;
    @Parameter(defaultValue="${project.build.directory}/apis-jars", readonly=true)
    private File mainOutputDir;
    @Component(hint="default")
    private ModelBuilder modelBuilder;
    @Component
    private ScmManager scmManager;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private RepositorySystem repositorySystem;
    private final Pattern pomPropertiesPattern = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");
    private final ArtifactProvider artifactProvider = new AbstractFeatureMojo.BaseArtifactProvider();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        this.getLog().debug((CharSequence)"Retrieving Feature files...");
        Collection<Feature> features = this.getSelectedFeatures(this.selection).values();
        if (features.isEmpty()) {
            this.getLog().info((CharSequence)"There are no assciated Feature files in the current project, plugin execution will be skipped");
        } else {
            this.getLog().debug((CharSequence)"Starting APIs JARs creation...");
            for (Feature feature : features) {
                this.onFeature(feature);
            }
        }
    }

    private boolean isRegionIncluded(String name) {
        boolean included = false;
        for (String i : this.includeRegions) {
            if (!"*".equals(i) && !i.equals(name)) continue;
            included = true;
            break;
        }
        if (included && this.excludeRegions != null) {
            for (String e : this.excludeRegions) {
                if (!name.equals(e)) continue;
                included = false;
                break;
            }
        }
        return included;
    }

    private ApiRegions getApiRegions(Feature feature) throws MojoExecutionException {
        ApiRegions regions = new ApiRegions();
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName("api-regions");
        if (apiRegionsExtension != null) {
            if (apiRegionsExtension.getJSONStructure() == null) {
                this.getLog().info((CharSequence)("Feature file " + feature.getId().toMvnId() + " declares an empty '" + "api-regions" + "' extension, no API JAR will be created"));
                regions = null;
            } else {
                ApiRegions sourceRegions;
                try {
                    sourceRegions = ApiRegions.parse((JsonArray)((JsonArray)apiRegionsExtension.getJSONStructure()));
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
                }
                for (ApiRegion r : sourceRegions.listRegions()) {
                    if (r.getParent() != null && !this.incrementalApis) {
                        for (ApiExport exp : r.getParent().listExports()) {
                            r.add(exp);
                        }
                    }
                    if (!this.isRegionIncluded(r.getName())) continue;
                    this.getLog().debug((CharSequence)("API Region " + r.getName() + " will not processed due to the configured include/exclude list"));
                    regions.add(r);
                }
                if (regions.isEmpty()) {
                    this.getLog().info((CharSequence)("Feature file " + feature.getId().toMvnId() + " has no included api regions, no API JAR will be created"));
                    regions = null;
                }
            }
        } else {
            regions.add(new ApiRegion("global"){

                public ApiExport getExportByName(String name) {
                    ApiExport exp = super.getExportByName(name);
                    if (exp == null) {
                        exp = new ApiExport(name);
                        this.add(exp);
                    }
                    return exp;
                }
            });
        }
        return regions;
    }

    private void onFeature(Feature feature) throws MojoExecutionException {
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"Creating API JARs for Feature ").strong((Object)feature.getId().toMvnId()).a((CharSequence)" ...").toString());
        ApiRegions regions = this.getApiRegions(feature);
        if (regions == null) {
            return;
        }
        File featureDir = new File(this.mainOutputDir, feature.getId().getArtifactId());
        ApisJarContext ctx = new ApisJarContext(this.mainOutputDir, feature, regions);
        ctx.getConfig().setLicenseDefaults(this.licenseDefaults);
        ctx.getConfig().setLicenseReport(this.licenseReport);
        ctx.getConfig().setLicenseReportHeader(this.licenseReportHeader);
        ctx.getConfig().setLicenseReportFooter(this.licenseReportFooter);
        ctx.getConfig().setJavadocLinks(this.javadocLinks);
        ctx.getConfig().setJavadocClasspathRemovals(this.javadocClasspathRemovals);
        ctx.getConfig().setJavadocClasspathHighestVersions(this.javadocClasspathHighestVersions);
        ctx.getConfig().setJavadocClasspathTops(this.javadocClasspathTops);
        ctx.getConfig().setApiVersion(this.apiVersion);
        ctx.getConfig().setJavadocSourceLevel(this.javadocSourceLevel);
        ctx.getConfig().setBundleResourceFolders(this.resourceFolders);
        ctx.getConfig().setBundleResources(this.includeResources);
        ctx.getConfig().setClassifierMappings(this.apiClassifierMappings);
        ctx.getConfig().setRegionMappings(this.apiRegionNameMappings);
        ctx.getConfig().setManifestEntries(this.manifestProperties);
        ctx.getConfig().logConfiguration(this.getLog());
        ctx.setDependencyRepositories(this.apiRepositoryUrls);
        for (Artifact artifact : feature.getBundles()) {
            this.onArtifact(ctx, artifact);
        }
        if (this.generateSourceJar || this.generateJavadocJar) {
            this.getLog().info((CharSequence)"--------------------------------------------------------");
            this.getLog().info((CharSequence)"Used sources:");
            for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos()) {
                if (info.getSources().isEmpty()) {
                    this.getLog().info((CharSequence)"- ".concat(info.getId().toMvnId()).concat(" : NO SOURCES FOUND"));
                    continue;
                }
                this.getLog().info((CharSequence)"- ".concat(info.getId().toMvnId()).concat(" : ").concat(info.getSources().toString()));
            }
            this.getLog().info((CharSequence)"--------------------------------------------------------");
        }
        boolean hasErrors = false;
        for (ApiRegion apiRegion : regions.listRegions()) {
            ArrayList<String> report = new ArrayList<String>();
            File regionDir = new File(featureDir, apiRegion.getName());
            if (this.generateApiJar) {
                File apiJar = this.createArchive(ctx, apiRegion, ArtifactType.APIS, this.apiResources, ctx.getArtifactInfos(apiRegion, this.useApiDependencies), report);
                this.report(ctx, apiJar, ArtifactType.APIS, apiRegion, this.useApiDependencies, report, null);
            }
            if (this.generateSourceJar) {
                File sourceJar = this.createArchive(ctx, apiRegion, ArtifactType.SOURCES, this.apiSourceResources, ctx.getArtifactInfos(apiRegion, this.useApiDependencies), report);
                this.report(ctx, sourceJar, ArtifactType.SOURCES, apiRegion, this.useApiDependencies, report, null);
            }
            if (this.useApiDependencies && (this.generateApiJar || this.generateSourceJar)) {
                this.createDependenciesFile(ctx, apiRegion);
            }
            if (this.generateJavadocJar) {
                File javadocsDir = new File(regionDir, ArtifactType.JAVADOC.getId());
                ExecutionEnvironmentExtension ext = ExecutionEnvironmentExtension.getExecutionEnvironmentExtension((Feature)feature);
                JavadocLinks links = new JavadocLinks();
                links.calculateLinks(ctx.getConfig().getJavadocLinks(), ctx.getArtifactInfos(apiRegion, false), ext != null ? ext.getFramework() : null);
                Collection<ApisJarContext.ArtifactInfo> infos = this.generateJavadoc(ctx, apiRegion, links, javadocsDir);
                if (infos != null) {
                    ctx.setJavadocDir(javadocsDir);
                    File javadocJar = this.createArchive(ctx, apiRegion, ArtifactType.JAVADOC, this.apiJavadocResources, infos, report);
                    this.report(ctx, javadocJar, ArtifactType.JAVADOC, apiRegion, false, report, links);
                } else {
                    this.getLog().warn((CharSequence)("Javadoc JAR will NOT be generated - sources directory " + ctx.getDeflatedSourcesDir() + " was empty or contained no Java files!"));
                }
            }
            ArtifactId reportId = this.buildArtifactId(ctx, apiRegion, ArtifactType.REPORT);
            File reportFile = new File(this.mainOutputDir, reportId.toMvnName());
            if (!report.isEmpty()) {
                report.stream().forEach(v -> this.getLog().info((CharSequence)v));
                try {
                    Files.write(reportFile.toPath(), report, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write " + reportFile, (Exception)e);
                }
                hasErrors = true;
                continue;
            }
            if (!reportFile.exists()) continue;
            reportFile.delete();
        }
        if (hasErrors && this.failOnError) {
            throw new MojoExecutionException("API generation has errors, please see report files for more information");
        }
        this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"APIs JARs for Feature ").debug((Object)feature.getId().toMvnId()).a((CharSequence)" succesfully created").toString());
    }

    private void report(ApisJarContext ctx, File jarFile, ArtifactType artifactType, ApiRegion apiRegion, boolean omitDependencyArtifacts, List<String> report, JavadocLinks links) throws MojoExecutionException {
        Map.Entry<Set<String>, Set<String>> packageResult = this.getPackages(ctx, jarFile, artifactType.getContentExtension());
        Set<String> apiPackages = packageResult.getKey();
        Set<String> otherPackages = packageResult.getValue();
        if (omitDependencyArtifacts) {
            for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos(apiRegion, false)) {
                if (!info.isUseAsDependencyPerRegion(apiRegion)) continue;
                for (Clause c : info.getUsedExportedPackages(apiRegion)) {
                    apiPackages.add(c.getName());
                }
            }
        }
        otherPackages.addAll(ctx.getPackagesWithoutJavaClasses());
        if (artifactType == ArtifactType.JAVADOC && !this.failOnMissingSourcesForJavadoc) {
            otherPackages.addAll(ctx.getPackagesWithoutSources());
        }
        if (links != null) {
            apiPackages.addAll(links.getLinkedPackages());
        }
        ArrayList<ApiExport> missing = new ArrayList<ApiExport>();
        for (ApiExport exp : apiRegion.listExports()) {
            String packageName = exp.getName();
            if (apiPackages.remove(packageName) || otherPackages.remove(packageName)) continue;
            missing.add(exp);
        }
        if (links != null) {
            apiPackages.removeAll(links.getLinkedPackages());
        }
        if (artifactType == ArtifactType.JAVADOC) {
            otherPackages.removeAll(ctx.getPackagesWithoutSources());
        }
        otherPackages.removeAll(ctx.getPackagesWithoutJavaClasses());
        apiPackages.addAll(otherPackages);
        if (missing.isEmpty() && apiPackages.isEmpty()) {
            this.getLog().info((CharSequence)("Verified " + artifactType.getId() + " jar for region " + apiRegion.getName()));
        } else {
            Collections.sort(missing);
            report.add(artifactType.getId().concat(" jar for region ").concat(apiRegion.getName()).concat(" has ").concat(String.valueOf(missing.size() + apiPackages.size())).concat(" errors:"));
            for (ApiExport exp : missing) {
                ArrayList<String> candidates = new ArrayList<String>();
                block4: for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos()) {
                    for (Clause clause : info.getUsedExportedPackages(apiRegion)) {
                        if (!exp.getName().equals(clause.getName())) continue;
                        candidates.add(info.getId().toMvnName());
                        continue block4;
                    }
                }
                report.add("- Missing package ".concat(exp.getName()).concat(" from bundle(s) ").concat(String.join((CharSequence)",", candidates)));
            }
            for (String m : apiPackages) {
                report.add("- Wrong package ".concat(m));
            }
        }
    }

    private File getArtifactFile(ArtifactProvider artifactProvider, ArtifactId artifactId) throws MojoExecutionException {
        URL artifactURL = this.retrieve(artifactProvider, artifactId);
        if (artifactURL == null) {
            throw new MojoExecutionException("Unable to find artifact " + artifactId.toMvnId());
        }
        File bundleFile = null;
        try {
            bundleFile = IOUtils.getFileFromURL((URL)artifactURL, (boolean)true, (File)this.getTmpDir());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        return bundleFile;
    }

    private Manifest getManifest(ArtifactId artifactId, File bundleFile) throws MojoExecutionException {
        Manifest manifest;
        JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));
        try {
            this.getLog().debug((CharSequence)("Reading Manifest headers from bundle " + bundleFile));
            Manifest manifest2 = jis.getManifest();
            if (manifest2 == null) {
                throw new MojoExecutionException("Artifact + " + artifactId.toMvnId() + " does not  have a manifest.");
            }
            manifest = manifest2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while reading manifest from file " + bundleFile + " for artifact " + artifactId.toMvnId(), (Exception)e);
            }
        }
        jis.close();
        return manifest;
    }

    private boolean calculateOmitDependenciesFlag(Clause[] exportedPackageClauses, Set<Clause> usedExportedPackagesPerRegion) {
        boolean fullUsage = true;
        for (Clause c : exportedPackageClauses) {
            boolean found = false;
            for (Clause current : usedExportedPackagesPerRegion) {
                if (!current.getName().equals(c.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            fullUsage = false;
            break;
        }
        return fullUsage;
    }

    private void onArtifact(ApisJarContext ctx, Artifact artifact) throws MojoExecutionException {
        Set<String> usedExportedPackages;
        File bundleFile = this.getArtifactFile(this.artifactProvider, artifact.getId());
        Manifest manifest = this.getManifest(artifact.getId(), bundleFile);
        Clause[] exportedPackageClauses = this.getExportedPackages(manifest);
        if (exportedPackageClauses.length > 0 && !(usedExportedPackages = this.computeUsedExportPackages(ctx.getApiRegions(), exportedPackageClauses, artifact)).isEmpty()) {
            String bundleClassPath;
            boolean skipSourceDeflate;
            ApisJarContext.ArtifactInfo info = ctx.addArtifactInfo(artifact);
            info.setUsedExportedPackages(usedExportedPackages);
            for (ApiRegion region : ctx.getApiRegions().listRegions()) {
                boolean useAsDependency;
                Set<Clause> usedExportedPackagesPerRegion = this.computeUsedExportPackages(region, exportedPackageClauses, artifact);
                boolean bl = useAsDependency = this.useApiDependencies ? this.calculateOmitDependenciesFlag(exportedPackageClauses, usedExportedPackagesPerRegion) : false;
                if (useAsDependency && (useAsDependency = ctx.findDependencyArtifact(this.getLog(), info)) && artifact.getMetadata().get("scm-location") != null) {
                    throw new MojoExecutionException("Dependency artifact must not specify scm-location : " + artifact.getId().toMvnId());
                }
                info.setUsedExportedPackages(region, usedExportedPackagesPerRegion, useAsDependency);
            }
            info.setBinDirectory(new File(ctx.getDeflatedBinDir(), info.getId().toMvnName()));
            info.setSourceDirectory(new File(ctx.getDeflatedSourcesDir(), info.getId().toMvnName()));
            boolean skipBinDeflate = info.getBinDirectory().exists();
            if (skipBinDeflate) {
                this.getLog().debug((CharSequence)("Artifact " + info.getId().toMvnName() + " already deflated"));
            }
            if (skipSourceDeflate = info.getSourceDirectory().exists()) {
                this.getLog().debug((CharSequence)("Source for artifact " + info.getId().toMvnName() + " already deflated"));
            }
            String[] embeddedBundles = (bundleClassPath = manifest.getMainAttributes().getValue("Bundle-ClassPath")) != null && !bundleClassPath.isEmpty() ? bundleClassPath.split(",") : null;
            this.processBinary(ctx, info, bundleFile, artifact, embeddedBundles, skipBinDeflate, skipSourceDeflate);
            if (embeddedBundles != null) {
                this.computeWrappedBundles(ctx, info, embeddedBundles, skipBinDeflate, skipSourceDeflate);
            }
            this.postProcessArtifact(ctx, info, artifact);
            if (!info.getSourceDirectory().exists()) {
                info.setSourceDirectory(null);
            }
            if (this.generateJavadocJar) {
                ApisUtil.buildJavadocClasspath(this.getLog(), this.repositorySystem, this.mavenSession, artifact.getId()).forEach(ctx::addJavadocClasspath);
            }
        }
    }

    private void postProcessArtifact(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Artifact artifact) throws MojoExecutionException {
        this.postProcessBinDirectory(ctx, info, info.getBinDirectory(), "");
        if (this.generateSourceJar || this.generateJavadocJar) {
            HashSet<String> foundPackages = new HashSet<String>();
            if (info.getSourceDirectory() != null && info.getSourceDirectory().exists()) {
                String encoding = artifact.getMetadata().getOrDefault("scm-encoding", "UTF-8");
                this.postProcessSourcesDirectory(ctx, info, foundPackages, info.getSourceDirectory(), "UTF-8".equals(encoding) ? null : encoding, "");
            }
            for (String pck : info.getUsedExportedPackages()) {
                if (foundPackages.contains(pck)) continue;
                this.getLog().debug((CharSequence)("No sources found in " + pck));
                ctx.getPackagesWithoutSources().add(pck);
            }
        }
    }

    private void postProcessBinDirectory(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, File dir, String pck) {
        boolean hasJavaFile = false;
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.postProcessBinDirectory(ctx, info, child, pck.isEmpty() ? child.getName() : pck.concat(".").concat(child.getName()));
                continue;
            }
            if (!child.getName().endsWith(ArtifactType.APIS.getContentExtension())) continue;
            hasJavaFile = true;
        }
        if (dir.listFiles().length == 0 && !pck.isEmpty()) {
            dir.delete();
        } else if (!hasJavaFile && info.getUsedExportedPackages().contains(pck)) {
            this.getLog().debug((CharSequence)("No classes found in " + pck));
            ctx.getPackagesWithoutJavaClasses().add(pck);
        }
    }

    private void processBinary(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, File binFile, Artifact binArtifact, String[] embeddedBundles, boolean skipBinDeflate, boolean skipSourceDeflate) throws MojoExecutionException {
        if (!skipBinDeflate) {
            ArrayList<String> deflateIncludes = new ArrayList<String>();
            deflateIncludes.addAll(Arrays.asList(info.getUsedExportedPackageIncludes()));
            if (embeddedBundles != null) {
                for (String jarName : embeddedBundles) {
                    if (".".equals(jarName)) continue;
                    deflateIncludes.add(jarName);
                }
            }
            deflateIncludes.addAll(this.getIncludeResourcePatterns(ctx, info.getId()));
            this.deflate(info.getBinDirectory(), binFile, deflateIncludes.toArray(new String[deflateIncludes.size()]));
        }
        this.renameResources(ctx, info, binArtifact.getId());
        if (this.generateSourceJar || this.generateJavadocJar) {
            if (!skipSourceDeflate) {
                this.downloadSources(ctx, info, binArtifact);
            } else {
                info.addSourceInfo("USE CACHE FROM PREVIOUS BUILD");
            }
        }
    }

    private List<String> getIncludeResourcePatterns(ApisJarContext ctx, ArtifactId id) {
        String licenseDefault;
        ArrayList<String> pattern = new ArrayList<String>();
        for (String folder : ctx.getConfig().getBundleResourceFolders()) {
            for (String inc : ctx.getConfig().getBundleResources()) {
                pattern.add(folder.concat("/").concat(inc));
            }
        }
        if (!(ctx.getConfig().getLicenseReport() == null || (licenseDefault = ctx.getConfig().getLicenseDefault(id)) != null && licenseDefault.isEmpty())) {
            pattern.add("META-INF/NOTICE");
            pattern.add("META-INF/LICENSE");
        }
        return pattern;
    }

    private void postProcessSourcesDirectory(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Set<String> foundPackages, File dir, String readEncoding, String pck) throws MojoExecutionException {
        boolean hasSourceFile = false;
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.postProcessSourcesDirectory(ctx, info, foundPackages, child, readEncoding, pck.isEmpty() ? child.getName() : pck.concat(".").concat(child.getName()));
                continue;
            }
            if (!child.getName().endsWith(ArtifactType.SOURCES.getContentExtension())) continue;
            hasSourceFile = true;
            if (readEncoding == null) continue;
            try {
                String javaSource = FileUtils.fileRead((File)child, (String)readEncoding);
                FileUtils.fileWrite((File)child, (String)StandardCharsets.UTF_8.name(), (String)javaSource);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to clean up java source " + child, (Exception)ioe);
            }
        }
        if (dir.listFiles().length == 0 && !pck.isEmpty()) {
            dir.delete();
        } else if (hasSourceFile) {
            foundPackages.add(pck);
        }
    }

    private void computeWrappedBundles(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, String[] embeddedBundles, boolean skipBinDeflate, boolean skipSourceDeflate) throws MojoExecutionException {
        for (String jarName : embeddedBundles) {
            if (".".equals(jarName)) continue;
            File wrappedJar = new File(info.getBinDirectory(), jarName);
            this.getLog().debug((CharSequence)("Processing wrapped bundle " + wrappedJar));
            Properties properties = new Properties();
            try (JarInputStream jis = new JarInputStream(new FileInputStream(wrappedJar));){
                JarEntry jarEntry = null;
                while ((jarEntry = jis.getNextJarEntry()) != null) {
                    if (!jarEntry.isDirectory() && this.pomPropertiesPattern.matcher(jarEntry.getName()).matches()) {
                        this.getLog().debug((CharSequence)("Loading Maven GAV from " + wrappedJar + '!' + jarEntry.getName()));
                        properties.load(jis);
                        break;
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while processing wrapped bundle " + wrappedJar, (Exception)e);
            }
            if (properties.isEmpty()) {
                this.getLog().warn((CharSequence)("No Maven GAV info attached to wrapped bundle " + wrappedJar + ", it will be ignored"));
                continue;
            }
            this.getLog().debug((CharSequence)("Handling synthetic artifacts from Maven GAV: " + properties));
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            String classifier = properties.getProperty("classifier");
            if (classifier == null) {
                classifier = this.inferClassifier(jarName, artifactId, version);
            }
            Artifact syntheticArtifact = new Artifact(new ArtifactId(groupId, artifactId, version, classifier, null));
            File bundleFile = this.getArtifactFile(this.artifactProvider, syntheticArtifact.getId());
            this.processBinary(ctx, info, bundleFile, syntheticArtifact, null, skipBinDeflate, skipSourceDeflate);
        }
    }

    String inferClassifier(String bundleName, String artifactId, String version) {
        String suffix;
        String synthesized;
        int edx;
        if (bundleName == null || artifactId == null || version == null) {
            return null;
        }
        int idx = bundleName.lastIndexOf(47);
        if (idx >= 0) {
            bundleName = bundleName.substring(idx + 1);
        }
        if ((edx = bundleName.lastIndexOf(46)) > 0) {
            bundleName = bundleName.substring(0, edx);
        }
        if ((synthesized = artifactId + "-" + version).length() < bundleName.length() && bundleName.startsWith(synthesized) && (suffix = bundleName.substring(synthesized.length())).length() > 1 && suffix.startsWith("-")) {
            String classifier = suffix.substring(1);
            this.getLog().debug((CharSequence)("Inferred classifier of '" + artifactId + ":" + version + "' to be '" + classifier + "'"));
            return classifier;
        }
        return null;
    }

    private URL retrieve(ArtifactProvider artifactProvider, ArtifactId artifactId) {
        this.getLog().debug((CharSequence)("Retrieving artifact " + artifactId + "..."));
        URL sourceFile = artifactProvider.provide(artifactId);
        if (sourceFile != null) {
            this.getLog().debug((CharSequence)("Artifact " + artifactId + " successfully retrieved : " + sourceFile));
        }
        return sourceFile;
    }

    private void deflate(File destDirectory, File artifact, String ... includes) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Deflating artifact " + artifact.getName() + "..."));
        destDirectory.mkdirs();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact);
            unArchiver.setSourceFile(artifact);
            unArchiver.setDestDirectory(destDirectory);
            IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
            selector.setIncludes(includes);
            unArchiver.setFileSelectors(new FileSelector[]{selector});
            unArchiver.setOverwrite(false);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("An error occurred while deflating file " + artifact + " to directory " + destDirectory, (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("Artifact " + artifact + " successfully deflated"));
    }

    private void renameResources(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, ArtifactId artifactId) throws MojoExecutionException {
        List<String> patterns = this.getIncludeResourcePatterns(ctx, info.getId());
        if (patterns.isEmpty()) {
            this.getLog().debug((CharSequence)("No configured resources to rename in " + info.getBinDirectory()));
        }
        this.getLog().debug((CharSequence)("Renaming " + patterns + " files in " + info.getBinDirectory() + "..."));
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(info.getBinDirectory());
        directoryScanner.setIncludes(patterns.toArray(new String[patterns.size()]));
        directoryScanner.scan();
        if (directoryScanner.getIncludedFiles().length == 0) {
            this.getLog().debug((CharSequence)("No " + patterns + " resources in " + info.getBinDirectory() + " to be renamed found."));
            return;
        }
        for (String resourceName : directoryScanner.getIncludedFiles()) {
            File resource = new File(info.getBinDirectory(), resourceName);
            String includedName = resourceName.replace(File.separatorChar, '/');
            if (!info.getIncludedResources().contains(resource)) {
                String prefix = artifactId.toMvnName().concat("-");
                if (resource.getName().startsWith(prefix)) {
                    this.getLog().debug((CharSequence)("No need to rename " + resource));
                    info.getIncludedResources().add(resource);
                } else {
                    File renamed = new File(resource.getParentFile(), prefix.concat(resource.getName()));
                    this.getLog().debug((CharSequence)("Renaming resource " + resource + " to " + renamed + "..."));
                    if (!resource.renameTo(renamed)) {
                        throw new MojoExecutionException("Impossible to rename resource " + resource + " to " + renamed + ", please check the current user has enough rights on the File System");
                    }
                    this.getLog().debug((CharSequence)("Resource renamed to " + renamed));
                    info.getIncludedResources().add(renamed);
                    int lastSlash = includedName.lastIndexOf(47);
                    includedName = lastSlash == -1 ? renamed.getName() : includedName.substring(0, lastSlash + 1).concat(renamed.getName());
                }
            }
            if (!includedName.endsWith(ArtifactType.CND.getContentExtension())) continue;
            info.getNodeTypes().add(includedName);
        }
        this.getLog().debug((CharSequence)(patterns + " resources in " + info.getBinDirectory() + " successfully renamed"));
    }

    private boolean downloadSourceAndDeflate(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, ArtifactId sourcesArtifactId, boolean allowFallback) throws MojoExecutionException {
        boolean failed = false;
        try {
            URL url = this.retrieve(this.artifactProvider, sourcesArtifactId);
            if (url != null) {
                File sourcesBundle = IOUtils.getFileFromURL((URL)url, (boolean)true, null);
                this.deflate(info.getSourceDirectory(), sourcesBundle, info.getUsedExportedPackageIncludes());
            } else {
                if (!allowFallback) {
                    throw new MojoExecutionException("Unable to download sources for " + info.getId().toMvnId() + " due to missing artifact " + sourcesArtifactId.toMvnId());
                }
                this.getLog().warn((CharSequence)("Unable to download sources for " + info.getId().toMvnId() + " due to missing artifact " + sourcesArtifactId.toMvnId() + ", trying source checkout next..."));
                failed = true;
            }
        }
        catch (MojoExecutionException mee) {
            throw mee;
        }
        catch (Throwable t) {
            if (!allowFallback) {
                throw new MojoExecutionException("Unable to download sources for " + info.getId().toMvnId() + " due to missing artifact " + sourcesArtifactId.toMvnId());
            }
            this.getLog().warn((CharSequence)("Unable to download sources for " + info.getId().toMvnId() + " from " + sourcesArtifactId.toMvnId() + " due to " + t.getMessage() + ", trying source checkout next..."));
            failed = true;
        }
        return failed;
    }

    private void downloadSources(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Artifact artifact) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Downloading sources for " + artifact.getId().toMvnId() + "..."));
        ApisUtil.validateSourceInfo(artifact);
        List<ArtifactId> scmIds = ApisUtil.getSourceIds(artifact);
        String scmLocation = (String)artifact.getMetadata().get("scm-location");
        if (scmIds != null) {
            for (ArtifactId sourcesArtifactId : scmIds) {
                this.downloadSourceAndDeflate(ctx, info, sourcesArtifactId, false);
                info.addSourceInfo(sourcesArtifactId);
            }
        } else if (scmLocation != null) {
            String connection = this.checkoutSourcesFromSCM(ctx, info, artifact);
            info.addSourceInfo(connection);
        } else {
            ArtifactId sourcesArtifactId;
            String sourceClassifier = (String)artifact.getMetadata().get("source-classifier");
            if (sourceClassifier == null) {
                sourceClassifier = "sources";
            }
            if (this.downloadSourceAndDeflate(ctx, info, sourcesArtifactId = artifact.getId().changeClassifier(sourceClassifier).changeType("jar"), artifact.getMetadata().get("source-classifier") == null)) {
                String connection = this.checkoutSourcesFromSCM(ctx, info, artifact);
                info.addSourceInfo(connection);
            } else {
                info.addSourceInfo(sourcesArtifactId);
            }
        }
    }

    private Model getArtifactPom(ApisJarContext ctx, ArtifactId artifactId) throws MojoExecutionException {
        ArtifactId pomArtifactId = artifactId.changeClassifier(null).changeType("pom");
        Model model = ctx.getModelCache().get(pomArtifactId);
        if (model == null) {
            this.getLog().debug((CharSequence)("Retrieving POM " + pomArtifactId.toMvnId() + "..."));
            URL pomURL = this.retrieve(this.artifactProvider, pomArtifactId);
            if (pomURL == null) {
                throw new MojoExecutionException("Unable to find artifact " + pomArtifactId.toMvnId());
            }
            File pomFile = null;
            try {
                pomFile = IOUtils.getFileFromURL((URL)pomURL, (boolean)true, null);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            this.getLog().debug((CharSequence)("POM " + pomArtifactId.toMvnId() + " successfully retrieved, reading the model..."));
            model = (Model)this.modelBuilder.buildRawModel(pomFile, 0, false).get();
            this.getLog().debug((CharSequence)("POM model " + pomArtifactId.toMvnId() + " successfully read"));
            ctx.getModelCache().put(pomArtifactId, model);
        }
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private String checkoutSourcesFromSCM(ApisJarContext ctx, ApisJarContext.ArtifactInfo info, Artifact sourceArtifact) throws MojoExecutionException {
        String connection = (String)sourceArtifact.getMetadata().get("scm-location");
        String tag = (String)sourceArtifact.getMetadata().get("scm-tag");
        this.getLog().debug((CharSequence)"Falling back to SCM checkout...");
        Model pomModel = this.getArtifactPom(ctx, sourceArtifact.getId());
        this.getLog().debug((CharSequence)"Processing SCM info from pom...");
        Scm scm = pomModel.getScm();
        if (scm != null) {
            if (connection == null) {
                connection = scm.getConnection();
            }
            if (tag == null) {
                tag = scm.getTag();
            }
        }
        if (connection == null) {
            this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : SCM not defined in " + sourceArtifact.getId().toMvnId() + " bundle neither in " + pomModel.getId() + " POM file."));
            return null;
        }
        try {
            void var12_21;
            File file;
            File file2;
            File basedir;
            ScmRepository repository = this.scmManager.makeScmRepository(connection);
            ScmTag scmVersion = null;
            if (tag != null) {
                scmVersion = new ScmTag(tag);
            }
            if ((basedir = new File(ctx.getCheckedOutSourcesDir(), sourceArtifact.getId().toMvnName())).exists()) {
                this.getLog().debug((CharSequence)("Source checkout directory " + basedir + " already exists"));
            } else {
                void var12_17;
                this.getLog().debug((CharSequence)("Checking out source to directory " + basedir));
                basedir.mkdirs();
                ScmFileSet fileSet = new ScmFileSet(basedir);
                Object var12_14 = null;
                try {
                    if (scmVersion != null) {
                        CheckOutScmResult checkOutScmResult = this.scmManager.checkOut(repository, fileSet, true);
                    } else {
                        CheckOutScmResult checkOutScmResult = this.scmManager.checkOut(repository, fileSet, (ScmVersion)scmVersion, true);
                    }
                }
                catch (ScmException se) {
                    throw new MojoExecutionException("An error occurred while checking sources from " + repository + " for artifact " + sourceArtifact.getId().toMvnId() + " model", (Exception)((Object)se));
                }
                if (!var12_17.isSuccess()) {
                    this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : An error occurred while checking out sources from " + connection + ": " + var12_17.getProviderMessage()));
                    return null;
                }
            }
            DirectoryScanner pomScanner = new DirectoryScanner();
            pomScanner.setBasedir(basedir);
            pomScanner.setIncludes(new String[]{"**/pom.xml"});
            pomScanner.scan();
            for (String pomFileLocation : pomScanner.getIncludedFiles()) {
                File pomFile = new File(basedir, pomFileLocation);
                Model model = (Model)this.modelBuilder.buildRawModel(pomFile, 0, false).get();
                if (!sourceArtifact.getId().getArtifactId().equals(model.getArtifactId())) continue;
                basedir = pomFile.getParentFile();
                break;
            }
            if (!(file2 = new File(basedir, "src/main/java")).exists() && !(file = new File(basedir, "src/java")).exists()) {
                this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : SCM checkout for " + sourceArtifact.getId().toMvnId() + " does not contain any source."));
                return null;
            }
            File sourceDirectory = new File(ctx.getDeflatedSourcesDir(), info.getId().toMvnName());
            info.setSourceDirectory(sourceDirectory);
            sourceDirectory.mkdir();
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir((File)var12_21);
            directoryScanner.setIncludes(info.getUsedExportedPackageIncludes());
            directoryScanner.scan();
            for (String file3 : directoryScanner.getIncludedFiles()) {
                File source = new File((File)var12_21, file3);
                File destination = new File(sourceDirectory, file3);
                destination.getParentFile().mkdirs();
                try {
                    FileUtils.copyFile((File)source, (File)destination);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("An error occurred while copying sources from " + source + " to " + destination, (Exception)e);
                }
            }
            return tag == null ? connection : connection.concat("@").concat(tag);
        }
        catch (ScmRepositoryException se) {
            throw new MojoExecutionException("An error occurred while reading SCM from " + connection + " connection for bundle " + sourceArtifact.getId(), (Exception)((Object)se));
        }
        catch (NoSuchScmProviderException nsspe) {
            this.getLog().warn((CharSequence)("Ignoring sources for artifact " + sourceArtifact.getId().toMvnId() + " : bundle points to an SCM connection " + connection + " which does not specify a valid or supported SCM provider"), (Throwable)nsspe);
            return null;
        }
    }

    private Clause[] getExportedPackages(Manifest manifest) {
        String exportPackageHeader = manifest.getMainAttributes().getValue("Export-Package");
        Clause[] exportPackages = Parser.parseHeader((String)exportPackageHeader);
        return exportPackages;
    }

    private Set<Clause> computeUsedExportPackages(ApiRegion apiRegion, Clause[] exportedPackages, Artifact bundle) throws MojoExecutionException {
        HashSet<Clause> result = new HashSet<Clause>();
        Set<String> ignoredPackages = ApisUtil.getIgnoredPackages(bundle);
        for (Clause exportedPackage : exportedPackages) {
            ApiExport exp;
            String packageName = exportedPackage.getName();
            if (ignoredPackages.contains(packageName) || (exp = apiRegion.getExportByName(packageName)) == null) continue;
            result.add(exportedPackage);
        }
        return result;
    }

    private Set<String> computeUsedExportPackages(ApiRegions apiRegions, Clause[] exportedPackages, Artifact bundle) throws MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        for (Clause exportedPackage : exportedPackages) {
            String packageName = exportedPackage.getName();
            for (ApiRegion apiRegion : apiRegions.listRegions()) {
                ApiExport exp = apiRegion.getExportByName(packageName);
                if (exp == null) continue;
                result.add(exportedPackage.getName());
            }
        }
        result.removeAll(ApisUtil.getIgnoredPackages(bundle));
        return result;
    }

    private String getApiExportClause(ApiRegion region, Collection<ApisJarContext.ArtifactInfo> infos) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ApisJarContext.ArtifactInfo info : infos) {
            for (Clause clause : info.getUsedExportedPackages(region)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(clause.toString());
            }
        }
        return sb.toString();
    }

    private File createArchive(ApisJarContext ctx, ApiRegion apiRegion, ArtifactType archiveType, List<File> resources, Collection<ApisJarContext.ArtifactInfo> infos, List<String> report) throws MojoExecutionException {
        JarArchiver jarArchiver = new JarArchiver();
        if (archiveType == ArtifactType.APIS || archiveType == ArtifactType.SOURCES) {
            for (ApisJarContext.ArtifactInfo info : infos) {
                File dir = archiveType == ArtifactType.APIS ? info.getBinDirectory() : info.getSourceDirectory();
                if (dir == null) continue;
                String[] usedExportedPackageIncludes = info.getUsedExportedPackageIncludes(apiRegion);
                this.getLog().debug((CharSequence)("Adding directory " + dir.getName() + " with " + Arrays.toString(usedExportedPackageIncludes)));
                DefaultFileSet fileSet = new DefaultFileSet(dir);
                fileSet.setIncludingEmptyDirectories(false);
                fileSet.setIncludes(usedExportedPackageIncludes);
                jarArchiver.addFileSet((FileSet)fileSet);
            }
        } else {
            DefaultFileSet fileSet = new DefaultFileSet(ctx.getJavadocDir());
            jarArchiver.addFileSet((FileSet)fileSet);
        }
        for (ApisJarContext.ArtifactInfo info : infos) {
            int prefixLength = info.getBinDirectory().getAbsolutePath().length() + 1;
            for (File resource : info.getIncludedResources()) {
                String name = resource.getAbsolutePath().substring(prefixLength);
                jarArchiver.addFile(resource, name);
                this.getLog().debug((CharSequence)("Adding resource " + name));
            }
        }
        if (resources != null) {
            for (File rsrc : resources) {
                this.getLog().debug((CharSequence)("Adding resource " + rsrc));
                if (rsrc.isDirectory()) {
                    DirectoryScanner ds = new DirectoryScanner();
                    ds.setBasedir(rsrc);
                    ds.setIncludes(new String[]{"**/*.*"});
                    ds.scan();
                    for (String includedFile : ds.getIncludedFiles()) {
                        jarArchiver.addFile(new File(rsrc, includedFile), includedFile);
                    }
                    continue;
                }
                jarArchiver.addFile(rsrc, rsrc.getName());
            }
        }
        if (ctx.getConfig().getLicenseReport() != null) {
            File out = this.createLicenseReport(ctx, apiRegion, infos, report);
            jarArchiver.addFile(out, ctx.getConfig().getLicenseReport());
        }
        ArtifactId targetId = this.buildArtifactId(ctx, apiRegion, archiveType);
        String artifactName = String.format("%s-%s", targetId.getArtifactId(), targetId.getClassifier());
        MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();
        archiveConfiguration.setAddMavenDescriptor(false);
        if (archiveType == ArtifactType.APIS) {
            String symbolicName = artifactName.replace('-', '.');
            archiveConfiguration.addManifestEntry("Export-Package", this.getApiExportClause(apiRegion, infos));
            archiveConfiguration.addManifestEntry("Bundle-Description", this.project.getDescription());
            archiveConfiguration.addManifestEntry("Bundle-Version", targetId.getOSGiVersion().toString());
            archiveConfiguration.addManifestEntry("Bundle-ManifestVersion", "2");
            archiveConfiguration.addManifestEntry("Bundle-SymbolicName", symbolicName);
            archiveConfiguration.addManifestEntry("Bundle-Name", artifactName);
            HashSet<String> nodeTypes = new HashSet<String>();
            for (ApisJarContext.ArtifactInfo info : infos) {
                nodeTypes.addAll(info.getNodeTypes());
            }
            if (!nodeTypes.isEmpty()) {
                archiveConfiguration.addManifestEntry("Sling-Nodetypes", String.join((CharSequence)",", nodeTypes));
            }
            if (this.project.getOrganization() != null) {
                archiveConfiguration.addManifestEntry("Bundle-Vendor", this.project.getOrganization().getName());
            }
            archiveConfiguration.addManifestEntry("Provide-Capability", "osgi.unresolvable");
            archiveConfiguration.addManifestEntry("Require-Capability", "osgi.unresolvable;filter:=\"(&(must.not.resolve=*)(!(must.not.resolve=*)))\",osgi.ee;filter:=\"(&(osgi.ee=JavaSE/compact2)(version=1.8))\"");
        }
        archiveConfiguration.addManifestEntry("Implementation-Version", targetId.getVersion());
        archiveConfiguration.addManifestEntry("Specification-Version", targetId.getVersion());
        archiveConfiguration.addManifestEntry("Implementation-Title", artifactName);
        archiveConfiguration.addManifestEntry("Specification-Title", artifactName);
        if (this.project.getOrganization() != null) {
            archiveConfiguration.addManifestEntry("Implementation-Vendor", this.project.getOrganization().getName());
            archiveConfiguration.addManifestEntry("Specification-Vendor", this.project.getOrganization().getName());
        }
        archiveConfiguration.addManifestEntries(ctx.getConfig().getManifestEntries());
        File target = new File(this.mainOutputDir, targetId.toMvnName());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(jarArchiver);
        archiver.setOutputFile(target);
        try {
            archiver.createArchive(this.mavenSession, this.project, archiveConfiguration);
            if (this.attachApiJars) {
                this.projectHelper.attachArtifact(this.project, targetId.getType(), targetId.getClassifier(), target);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error occurred while creating APIs " + target + " archive", e);
        }
        return target;
    }

    private ArtifactId buildArtifactId(ApisJarContext ctx, ApiRegion apiRegion, ArtifactType artifactType) {
        StringBuilder classifierBuilder = new StringBuilder();
        if (ctx.getFeatureId().getClassifier() != null) {
            classifierBuilder.append(ctx.getConfig().mapApiClassifier(ctx.getFeatureId().getClassifier())).append('-');
        }
        String finalClassifier = classifierBuilder.append(ctx.getConfig().mapApiRegionName(apiRegion.getName())).append('-').append(artifactType.getId()).toString();
        return new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), ctx.getConfig().getApiVersion() != null ? ctx.getConfig().getApiVersion() : this.project.getVersion(), finalClassifier, artifactType.getExtension());
    }

    private void createDependenciesFile(ApisJarContext ctx, ApiRegion apiRegion) throws MojoExecutionException {
        Collection<ApisJarContext.ArtifactInfo> infos = ctx.getArtifactInfos(apiRegion, false);
        ArrayList<ArtifactId> dependencies = new ArrayList<ArtifactId>();
        for (ApisJarContext.ArtifactInfo info : infos) {
            if (!info.isUseAsDependencyPerRegion(apiRegion)) continue;
            dependencies.addAll(info.getDependencyArtifacts());
        }
        Collections.sort(dependencies);
        ArtifactId targetId = this.buildArtifactId(ctx, apiRegion, ArtifactType.DEPENDENCIES);
        File target = new File(this.mainOutputDir, targetId.toMvnName());
        if (!dependencies.isEmpty()) {
            this.getLog().info((CharSequence)"Writing dependencies file ".concat(target.getAbsolutePath()));
            try (FileWriter w = new FileWriter(target);){
                for (ArtifactId id : dependencies) {
                    w.write(id.toMvnId());
                    w.write(System.lineSeparator());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write dependencies file", (Exception)e);
            }
            if (this.attachApiJars) {
                this.projectHelper.attachArtifact(this.project, targetId.getType(), targetId.getClassifier(), target);
            }
        } else {
            this.getLog().info((CharSequence)"No dependencies found");
            if (target.exists()) {
                target.delete();
            }
        }
    }

    private Collection<ApisJarContext.ArtifactInfo> generateJavadoc(ApisJarContext ctx, ApiRegion region, JavadocLinks links, File javadocDir) throws MojoExecutionException {
        Collection<String> classpath;
        String versionSuffix;
        ArrayList<ApisJarContext.ArtifactInfo> usedInfos = new ArrayList<ApisJarContext.ArtifactInfo>();
        ArrayList<String> sourceDirectories = new ArrayList<String>();
        HashSet<String> javadocPackages = new HashSet<String>();
        for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos(region, false)) {
            boolean addDirectory = false;
            for (Clause clause : info.getUsedExportedPackages(region)) {
                if (ctx.getPackagesWithoutSources().contains(clause.getName()) || links.getLinkedPackages().contains(clause.getName())) continue;
                addDirectory = true;
                javadocPackages.add(clause.getName());
            }
            if (!addDirectory || info.getSourceDirectory() == null) continue;
            usedInfos.add(info);
            sourceDirectories.add(info.getSourceDirectory().getAbsolutePath());
        }
        if (javadocPackages.isEmpty()) {
            return null;
        }
        javadocDir.mkdirs();
        JavadocExecutor javadocExecutor = new JavadocExecutor(javadocDir.getParentFile()).addArgument("-public").addArgument("-encoding", false).addArgument("UTF-8").addArgument("-charset", false).addArgument("UTF-8").addArgument("-docencoding", false).addArgument("UTF-8").addArgument("-d", false).addArgument(javadocDir.getAbsolutePath()).addArgument("-sourcepath", false).addArgument(String.join((CharSequence)File.pathSeparator, sourceDirectories));
        javadocExecutor.addArgument("-source", false).addArgument(ctx.getConfig().getJavadocSourceLevel());
        String string = versionSuffix = ctx.getConfig().getApiVersion() != null ? ctx.getConfig().getApiVersion() : ctx.getFeatureId().getVersion();
        if (!StringUtils.isBlank((CharSequence)this.project.getName())) {
            javadocExecutor.addArgument("-doctitle", false).addQuotedArgument(this.project.getName().trim().concat(" ").concat(versionSuffix));
        }
        if (!StringUtils.isBlank((CharSequence)this.project.getDescription())) {
            javadocExecutor.addArgument("-windowtitle", false).addQuotedArgument(this.project.getDescription().trim().concat(" ").concat(versionSuffix));
        }
        if (!StringUtils.isBlank((CharSequence)this.project.getInceptionYear()) && this.project.getOrganization() != null && !StringUtils.isBlank((CharSequence)this.project.getOrganization().getName())) {
            javadocExecutor.addArgument("-bottom", false).addQuotedArgument(String.format("Copyright &copy; %s - %s %s. All Rights Reserved", this.project.getInceptionYear().trim(), Calendar.getInstance().get(1), this.project.getOrganization().getName().trim()));
        }
        if (!links.getJavadocLinks().isEmpty()) {
            javadocExecutor.addArguments("-link", links.getJavadocLinks());
        }
        if (!(classpath = ApisUtil.getJavadocClassPath(this.getLog(), this.repositorySystem, this.mavenSession, ctx, region)).isEmpty()) {
            javadocExecutor.addArgument("-classpath", false).addArgument(classpath, File.pathSeparator);
        }
        javadocExecutor.addArgument("-Xdoclint:none");
        javadocExecutor.addArgument("--allow-script-in-comments");
        if (!this.javadocIndex) {
            javadocExecutor.addArgument("-noindex");
        }
        if (!this.javadocTree) {
            javadocExecutor.addArgument("-notree");
        }
        javadocExecutor.addArguments(javadocPackages);
        javadocExecutor.execute(javadocDir, this.getLog(), this.ignoreJavadocErrors);
        return usedInfos;
    }

    private Map.Entry<Set<String>, Set<String>> getPackages(ApisJarContext ctx, File file, String extension) throws MojoExecutionException {
        TreeSet<String> packages = new TreeSet<String>();
        TreeSet<String> otherPackages = new TreeSet<String>();
        HashSet<String> excludes = new HashSet<String>();
        for (String v : ctx.getConfig().getBundleResourceFolders()) {
            excludes.add(v.concat("/"));
        }
        try (JarInputStream jis = new JarInputStream(new FileInputStream(file));){
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (!entry.isDirectory()) {
                    int lastPos;
                    boolean exclude = false;
                    for (String v : excludes) {
                        if (!entry.getName().startsWith(v)) continue;
                        exclude = true;
                        break;
                    }
                    if (!exclude && (lastPos = entry.getName().lastIndexOf(47)) != -1) {
                        String packageName = entry.getName().substring(0, lastPos).replace('/', '.');
                        if (entry.getName().endsWith(extension)) {
                            packages.add(packageName);
                        } else {
                            otherPackages.add(packageName);
                        }
                    }
                }
                jis.closeEntry();
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to scan file " + file + " : " + ioe.getMessage());
        }
        otherPackages.removeAll(packages);
        return Collections.singletonMap(packages, otherPackages).entrySet().iterator().next();
    }

    private File createLicenseReport(ApisJarContext ctx, ApiRegion region, Collection<ApisJarContext.ArtifactInfo> infos, List<String> report) throws MojoExecutionException {
        File out = new File(this.getTmpDir(), region.getName() + "-license-report.txt");
        if (!out.exists()) {
            ArrayList<String> output = new ArrayList<String>();
            output.add(ctx.getConfig().getLicenseReportHeader());
            output.add("");
            for (ApisJarContext.ArtifactInfo info : infos) {
                String licenseDefault = ctx.getConfig().getLicenseDefault(info.getId());
                StringBuilder sb = new StringBuilder(info.getId().toMvnId());
                boolean exclude = false;
                if (licenseDefault != null) {
                    if (licenseDefault.isEmpty()) {
                        exclude = true;
                        this.getLog().debug((CharSequence)("Excluding from license report " + info.getId().toMvnId()));
                    } else {
                        sb.append(" - License(s) : ");
                        sb.append(licenseDefault);
                    }
                } else {
                    List<License> licenses = this.getLicenses(ctx, info);
                    if (!licenses.isEmpty()) {
                        sb.append(" - License(s) : ");
                        sb.append(String.join((CharSequence)", ", licenses.stream().map(l -> l.getName().concat(" (").concat(l.getUrl()).concat(")")).collect(Collectors.toList())));
                    } else {
                        report.add("No license info found for ".concat(info.getId().toMvnId()));
                    }
                }
                if (exclude) continue;
                output.add(sb.toString());
            }
            if (ctx.getConfig().getLicenseReportFooter() != null) {
                output.add("");
                output.add(ctx.getConfig().getLicenseReportFooter());
            }
            try {
                Files.write(out.toPath(), output, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write license report: " + e.getMessage(), (Exception)e);
            }
        }
        return out;
    }

    private List<License> getLicenses(ApisJarContext ctx, ApisJarContext.ArtifactInfo info) {
        this.getLog().debug((CharSequence)("Getting license for " + info.getId().toMvnId()));
        List result = info.getLicenses();
        if (result == null) {
            try {
                ArtifactId id = info.getId();
                do {
                    ArtifactId newId;
                    Model model;
                    List ll;
                    if ((ll = (model = this.getArtifactPom(ctx, id)).getLicenses()) != null && !ll.isEmpty()) {
                        this.getLog().debug((CharSequence)("Found license for " + id.toMvnId()));
                        result = ll;
                        continue;
                    }
                    if (model.getParent() == null || (newId = new ArtifactId(model.getParent().getGroupId(), model.getParent().getArtifactId(), model.getParent().getVersion(), null, "pom")).equals((Object)id)) break;
                    id = newId;
                } while (result == null);
            }
            catch (MojoExecutionException mojoExecutionException) {
                // empty catch block
            }
            if (result == null) {
                result = Collections.emptyList();
            }
            info.setLicenses(result);
        }
        this.getLog().debug((CharSequence)("License for " + info.getId().toMvnId() + " = " + result));
        return result;
    }

    public static enum ArtifactType {
        APIS("apis", "class", "jar"),
        SOURCES("sources", "java", "jar"),
        JAVADOC("javadoc", "html", "jar"),
        DEPENDENCIES("apideps", "txt", "ref"),
        CND("cnd", "cnd", "jar"),
        REPORT("report", "txt", "txt");

        private final String id;
        private final String type;
        private final String extension;

        private ArtifactType(String id, String type, String extension) {
            this.id = id;
            this.type = type;
            this.extension = extension;
        }

        public String getId() {
            return this.id;
        }

        public String getContentType() {
            return this.type;
        }

        public String getContentExtension() {
            return ".".concat(this.type);
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

