/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.Aggregate;

@Mojo(name="aggregate-features", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AggregateFeaturesMojo
extends AbstractIncludingFeatureMojo {
    private static final String FILE_STORAGE_CONFIG_KEY = "fileStorage";
    private static final String HANDLER_CONFIG_WILDCARD = "all";
    @Parameter(required=true)
    List<Aggregate> aggregates;
    @Parameter
    Map<String, Properties> handlerConfiguration = new HashMap<String, Properties>();

    public void execute() throws MojoExecutionException {
        this.checkPreconditions();
        for (Aggregate aggregate : this.aggregates) {
            String key;
            ProjectHelper.validateFeatureClassifiers(this.project, aggregate.classifier, aggregate.attach);
            final Map<String, Feature> selection = this.getSelectedFeatures(aggregate);
            if (selection.isEmpty()) {
                throw new MojoExecutionException("No features found for aggregate with classifier " + aggregate.classifier);
            }
            HashMap<String, String> variablesOverwrites = new HashMap<String, String>();
            if (aggregate.variablesOverrides != null) {
                variablesOverwrites.putAll(aggregate.variablesOverrides);
            }
            HashMap<String, String> frameworkPropertiesOverwrites = new HashMap<String, String>();
            if (aggregate.frameworkPropertiesOverrides != null) {
                frameworkPropertiesOverwrites.putAll(aggregate.frameworkPropertiesOverrides);
            }
            BuilderContext builderContext = new BuilderContext((FeatureProvider)new AbstractFeatureMojo.BaseFeatureProvider(){

                @Override
                public Feature provide(ArtifactId id) {
                    for (Feature feat : selection.values()) {
                        if (!feat.getId().equals((Object)id)) continue;
                        return feat;
                    }
                    return super.provide(id);
                }
            }).setArtifactProvider((ArtifactProvider)new AbstractFeatureMojo.BaseArtifactProvider()).addVariablesOverrides(variablesOverwrites).addFrameworkPropertiesOverrides(frameworkPropertiesOverwrites).addMergeExtensions((MergeHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(MergeHandler.class).iterator(), 16), false).toArray(MergeHandler[]::new)).addPostProcessExtensions((PostProcessHandler[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(PostProcessHandler.class).iterator(), 16), false).toArray(PostProcessHandler[]::new));
            for (ArtifactId artifactId : aggregate.getArtifactOverrideRules()) {
                builderContext.addArtifactsOverride(artifactId);
            }
            builderContext.addConfigsOverrides(aggregate.getConfigurationOverrideRules());
            boolean wildcardSet = false;
            for (Map.Entry<String, Properties> entry : this.handlerConfiguration.entrySet()) {
                key = entry.getKey();
                Properties props = entry.getValue();
                if (HANDLER_CONFIG_WILDCARD.equals(key)) {
                    if (!props.containsKey(FILE_STORAGE_CONFIG_KEY)) {
                        props.put(FILE_STORAGE_CONFIG_KEY, this.getFeatureModelStorage());
                    }
                    wildcardSet = true;
                }
                builderContext.setHandlerConfiguration(key, ProjectHelper.propertiesToMap(props));
            }
            if (!wildcardSet) {
                builderContext.setHandlerConfiguration(HANDLER_CONFIG_WILDCARD, Collections.singletonMap(FILE_STORAGE_CONFIG_KEY, this.getFeatureModelStorage()));
            }
            ArtifactId artifactId = new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), aggregate.classifier, "slingosgifeature");
            Feature result = this.assembleFeature(artifactId, builderContext, selection);
            if (aggregate.markAsFinal) {
                result.setFinal(true);
            }
            if (aggregate.markAsComplete) {
                result.setComplete(true);
            }
            if (aggregate.title != null) {
                result.setTitle(aggregate.title);
            }
            if (aggregate.description != null) {
                result.setDescription(aggregate.description);
            }
            if (aggregate.vendor != null) {
                result.setVendor(aggregate.vendor);
            }
            ProjectHelper.createTmpFeatureFile(this.project, result);
            ProjectHelper.setFeatureInfo(this.project, result);
            key = ProjectHelper.generateAggregateFeatureKey(aggregate.classifier, aggregate.attach);
            ProjectHelper.getAssembledFeatures(this.project).put(key, result);
            ProjectHelper.getFeatures(this.project).put(key, result);
        }
    }

    Feature assembleFeature(ArtifactId newFeatureID, BuilderContext builderContext, Map<String, Feature> selection) {
        return FeatureBuilder.assemble((ArtifactId)newFeatureID, (BuilderContext)builderContext, (Feature[])selection.values().toArray(new Feature[selection.size()]));
    }

    private String getFeatureModelStorage() {
        String featureModelFileStorage = this.project.getBuild().getDirectory() + "/sling-slingfeature-maven-plugin-fmtmp";
        new File(featureModelFileStorage).mkdirs();
        return featureModelFileStorage;
    }
}

