/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.RepositorySystem;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.maven.mojos.apis.ApisJarContext;
import org.apache.sling.feature.maven.mojos.selection.IncludeExcludeMatcher;

public class ApisUtil {
    public static final String SCM_TAG = "scm-tag";
    public static final String SCM_LOCATION = "scm-location";
    public static final String SCM_ENCODING = "scm-encoding";
    public static final String API_IDS = "api-ids";
    public static final String SCM_IDS = "source-ids";
    public static final String SCM_CLASSIFIER = "source-classifier";
    public static final String JAVADOC_LINKS = "javadoc-links";
    public static final String JAVADOC_CLASSPATH = "javadoc-classpath";
    public static final String IGNORE_PACKAGES = "apis-ignore";

    public static List<ArtifactId> getSourceIds(Artifact artifact) throws MojoExecutionException {
        String val = (String)artifact.getMetadata().get(SCM_IDS);
        if (val != null) {
            ArrayList<ArtifactId> result = new ArrayList<ArtifactId>();
            for (String v : val.split(",")) {
                try {
                    ArtifactId sourceId = ArtifactId.parse((String)v.trim());
                    if (sourceId.getClassifier() == null) {
                        throw new MojoExecutionException("Metadata source-ids must specify classifier for source artifacts : " + sourceId.toMvnId());
                    }
                    result.add(sourceId);
                }
                catch (IllegalArgumentException iae) {
                    throw new MojoExecutionException("Wrong format for artifact id : " + v);
                }
            }
            return result;
        }
        return null;
    }

    public static List<ArtifactId> getApiIds(Artifact artifact) throws MojoExecutionException {
        String val = (String)artifact.getMetadata().get(API_IDS);
        if (val != null) {
            ArrayList<ArtifactId> result = new ArrayList<ArtifactId>();
            for (String v : val.split(",")) {
                try {
                    ArtifactId id = ArtifactId.parse((String)v.trim());
                    result.add(id);
                }
                catch (IllegalArgumentException iae) {
                    throw new MojoExecutionException("Wrong format for artifact id : " + v);
                }
            }
            return result;
        }
        return null;
    }

    public static List<String> getJavadocLinks(Artifact artifact) {
        String val = (String)artifact.getMetadata().get(JAVADOC_LINKS);
        if (val != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String v : val.split(",")) {
                if ((v = v.trim()).endsWith("/")) {
                    v = v.substring(0, v.length() - 1);
                }
                result.add(v);
            }
            return result;
        }
        return null;
    }

    public static void getPackageList(String javadocUrl, Set<String> linkedPackages, Map<String, Set<String>> linkedPackagesMap) throws MojoExecutionException {
        Set<String> result = linkedPackagesMap.get(javadocUrl);
        if (result == null) {
            result = new HashSet<String>();
            linkedPackagesMap.put(javadocUrl, result);
            try {
                URL url = new URL(javadocUrl.concat("/package-list"));
                try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        result.add(line.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to find/read package-list at ".concat(javadocUrl), (Exception)e);
            }
        }
        result.stream().forEach(v -> linkedPackages.add((String)v));
    }

    public static Set<String> getIgnoredPackages(Artifact bundle) {
        HashSet<String> result = new HashSet<String>();
        String ignore = (String)bundle.getMetadata().get(IGNORE_PACKAGES);
        if (ignore != null) {
            for (String p : ignore.split(",")) {
                result.add(p.trim());
            }
        }
        return result;
    }

    public static void validateSourceInfo(Artifact artifact) throws MojoExecutionException {
        int count = 0;
        if (artifact.getMetadata().get(SCM_LOCATION) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_CLASSIFIER) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_IDS) != null) {
            ++count;
        }
        if (count > 1) {
            throw new MojoExecutionException("Only one source configuration out of source-classifier, source-ids or scm-location is allowed for " + artifact.getId().toMvnId());
        }
    }

    public static Collection<String> getJavadocClassPath(Log log, RepositorySystem repositorySystem, MavenSession mavenSession, ApisJarContext ctx, ApiRegion region) throws MojoExecutionException {
        ArrayList<String> classpath;
        IncludeExcludeMatcher matcher;
        TreeMap classpathMapping = new TreeMap(Comparator.reverseOrder());
        classpathMapping.putAll(ctx.getJavadocClasspath());
        for (ApisJarContext.ArtifactInfo info : ctx.getArtifactInfos(region, false)) {
            String ids = (String)info.getArtifact().getMetadata().get(JAVADOC_CLASSPATH);
            if (ids == null) continue;
            for (String s : ids.split(",")) {
                try {
                    ArtifactId cpId = ArtifactId.parse((String)s.trim());
                    classpathMapping.putAll(ApisUtil.buildJavadocClasspath(log, repositorySystem, mavenSession, cpId));
                }
                catch (IllegalArgumentException iae) {
                    throw new MojoExecutionException("Invalid javadoc classpath artifact id " + s);
                }
            }
        }
        if (!ctx.getConfig().getJavadocClasspathRemovals().isEmpty()) {
            log.debug((CharSequence)"Using javadoc classpath removal: ".concat(ctx.getConfig().getJavadocClasspathRemovals().toString()));
            matcher = new IncludeExcludeMatcher(ctx.getConfig().getJavadocClasspathRemovals(), null, null, false);
            Iterator iter = classpathMapping.keySet().iterator();
            while (iter.hasNext()) {
                ArtifactId id = (ArtifactId)iter.next();
                if (matcher.matches(id) == null) continue;
                log.debug((CharSequence)("Removing from javadoc classpath: " + id.toMvnId()));
                iter.remove();
            }
        }
        if (!ctx.getConfig().getJavadocClasspathHighestVersions().isEmpty()) {
            log.debug((CharSequence)"Using javadoc classpath highest versions: ".concat(ctx.getConfig().getJavadocClasspathHighestVersions().toString()));
            matcher = new IncludeExcludeMatcher(ctx.getConfig().getJavadocClasspathHighestVersions(), null, null, false);
            HashMap<ArtifactId, List> highest = new HashMap<ArtifactId, List>();
            for (Map.Entry entry : classpathMapping.entrySet()) {
                if (matcher.matches((ArtifactId)entry.getKey()) == null) continue;
                ArtifactId key = ((ArtifactId)entry.getKey()).changeVersion("0");
                highest.computeIfAbsent(key, k -> new ArrayList()).add(entry.getKey());
            }
            for (List list : highest.values()) {
                Collections.sort(list, Comparator.reverseOrder());
                for (int i = 1; i < list.size(); ++i) {
                    ArtifactId id = (ArtifactId)list.get(i);
                    classpathMapping.remove(id);
                    log.debug((CharSequence)("Removing from javadoc classpath: " + id.toMvnId()));
                }
            }
        }
        if (!ctx.getConfig().getJavadocClasspathTops().isEmpty()) {
            log.debug((CharSequence)"Using javadoc classpath tops: ".concat(ctx.getConfig().getJavadocClasspathTops().toString()));
            IncludeExcludeMatcher matcher2 = new IncludeExcludeMatcher(ctx.getConfig().getJavadocClasspathTops(), null, null, false);
            ArrayList tops = new ArrayList();
            Iterator iterator = classpathMapping.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (matcher2.matches((ArtifactId)entry.getKey()) == null) continue;
                tops.add(0, entry.getValue());
                iterator.remove();
            }
            classpath = new ArrayList(classpathMapping.values());
            for (String path : tops) {
                classpath.add(0, path);
            }
        } else {
            classpath = new ArrayList<String>(classpathMapping.values());
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"------------------------------------------------------------------");
            log.debug((CharSequence)"Javadoc classpath: ");
            for (String cp : classpath) {
                log.debug((CharSequence)("- " + cp));
            }
            log.debug((CharSequence)"------------------------------------------------------------------");
        }
        return classpath;
    }

    public static Map<ArtifactId, String> buildJavadocClasspath(Log log, RepositorySystem repositorySystem, MavenSession mavenSession, ArtifactId artifactId) throws MojoExecutionException {
        HashMap<ArtifactId, String> javadocClasspath = new HashMap<ArtifactId, String>();
        log.debug((CharSequence)("Retrieving " + artifactId + " and related dependencies..."));
        org.apache.maven.artifact.Artifact toBeResolvedArtifact = repositorySystem.createArtifactWithClassifier(artifactId.getGroupId(), artifactId.getArtifactId(), artifactId.getVersion(), artifactId.getType(), artifactId.getClassifier());
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(toBeResolvedArtifact).setServers(mavenSession.getRequest().getServers()).setMirrors(mavenSession.getRequest().getMirrors()).setProxies(mavenSession.getRequest().getProxies()).setLocalRepository(mavenSession.getLocalRepository()).setRemoteRepositories(mavenSession.getRequest().getRemoteRepositories()).setForceUpdate(false).setResolveRoot(true).setResolveTransitively(true).setCollectionFilter(new ArtifactFilter(){

            public boolean include(org.apache.maven.artifact.Artifact artifact) {
                return !"test".equals(artifact.getScope());
            }
        });
        ArtifactResolutionResult result = repositorySystem.resolve(request);
        if (!result.isSuccess() && log.isDebugEnabled()) {
            if (result.hasCircularDependencyExceptions()) {
                log.warn((CharSequence)"Cyclic dependency errors detected:");
                ApisUtil.reportWarningMessages(log, result.getCircularDependencyExceptions());
            }
            if (result.hasErrorArtifactExceptions()) {
                log.warn((CharSequence)"Resolution errors detected:");
                ApisUtil.reportWarningMessages(log, result.getErrorArtifactExceptions());
            }
            if (result.hasMetadataResolutionExceptions()) {
                log.warn((CharSequence)"Metadata resolution errors detected:");
                ApisUtil.reportWarningMessages(log, result.getMetadataResolutionExceptions());
            }
            if (result.hasMissingArtifacts()) {
                log.warn((CharSequence)"Missing artifacts detected:");
                for (org.apache.maven.artifact.Artifact missingArtifact : result.getMissingArtifacts()) {
                    log.warn((CharSequence)(" - " + missingArtifact.getId()));
                }
            }
            if (result.hasExceptions()) {
                log.warn((CharSequence)"Generic errors detected:");
                for (Exception exception : result.getExceptions()) {
                    log.warn((CharSequence)(" - " + exception.getMessage()));
                }
            }
        }
        for (org.apache.maven.artifact.Artifact resolvedArtifact : result.getArtifacts()) {
            if (resolvedArtifact.getFile() != null) {
                log.debug((CharSequence)("Adding to javadoc classpath " + resolvedArtifact));
                javadocClasspath.put(new ArtifactId(resolvedArtifact.getGroupId(), resolvedArtifact.getArtifactId(), resolvedArtifact.getVersion(), resolvedArtifact.getClassifier(), resolvedArtifact.getType()), resolvedArtifact.getFile().getAbsolutePath());
                continue;
            }
            log.debug((CharSequence)("Ignoring for javadoc classpath " + resolvedArtifact));
        }
        return javadocClasspath;
    }

    private static <E extends ArtifactResolutionException> void reportWarningMessages(Log log, Collection<E> exceptions) {
        for (ArtifactResolutionException exception : exceptions) {
            log.warn((CharSequence)(" - " + exception.getMessage() + " (" + exception.getArtifact().getId() + ")"));
        }
    }
}

