/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

@Mojo(name="launch-features", requiresProject=true, threadSafe=true)
public class FeatureLauncherMojo
extends AbstractIncludingFeatureMojo {
    public static final String CFG_FEATURE_ARCHIVE_FILES = "featureArchiveFiles";
    public static final String CFG_FEATURE_ARCHIVE_IDS = "featureArchiveIds";
    public static final String CFG_FEATURE_ARCHIVE_CLASSIFIERS = "featureArchiveClassifiers";
    public static final String CFG_ARTIFACT_CLASH_OVERRIDES = "artifactClashOverrides";
    public static final String CFG_REPOSITORY_URL = "frameworkRepositoryUrl";
    public static final String CFG_FRAMEWORK_PROPERTIES = "frameworkProperties";
    public static final String CFG_VARIABLE_VALUES = "variableValues";
    public static final String CFG_VERBOSE = "verbose";
    public static final String CFG_CACHE_DIRECTORY = "cacheDirectory";
    public static final String CFG_HOME_DIRECTORY = "homeDirectory";
    public static final String CFG_EXTENSION_CONFIGURATIONS = "extensionConfigurations";
    public static final String CFG_FRAMEWORK_VERSION = "frameworkVersion";
    public static final String CFG_FRAMEWORK_ARTIFACTS = "frameworkArtifacts";
    @Parameter
    private FeatureSelectionConfig selection;
    @Parameter(property="featureArchiveFiles", required=false)
    private Set<File> featureArchiveFiles;
    @Parameter(property="featureArchiveIds", required=false)
    private Set<String> featureArchiveIds;
    @Parameter(property="featureArchiveClassifiers", required=false)
    private Set<String> featureArchiveClassifiers;
    @Parameter(property="artifactClashOverrides", required=false)
    private String[] artifactClashOverrides;
    @Parameter(property="frameworkRepositoryUrl", required=false)
    private String repositoryUrl;
    @Parameter(property="frameworkProperties", required=false)
    private String[] frameworkProperties;
    @Parameter(property="variableValues", required=false)
    private String[] variableValues;
    @Parameter(property="verbose", required=false, defaultValue="false")
    private boolean verbose;
    @Parameter(property="cacheDirectory", required=false)
    private File cacheDirectory;
    @Parameter(property="homeDirectory", required=false)
    private File homeDirectory;
    @Parameter(property="extensionConfigurations", required=false)
    private String[] extensionConfigurations;
    @Parameter(property="frameworkVersion", required=false)
    private String frameworkVersion;
    @Parameter(property="frameworkArtifacts", required=false)
    private String[] frameworkArtifacts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File file;
        String artifactPath;
        ArtifactId id;
        this.checkPreconditions();
        ArrayList<String> arguments = new ArrayList<String>();
        this.getLog().info((CharSequence)("Feature Selection: " + this.selection));
        if (this.featureArchiveFiles != null && !this.featureArchiveFiles.isEmpty()) {
            for (File file2 : this.featureArchiveFiles) {
                this.handleFile(arguments, file2, "-f");
            }
        }
        ArtifactRepository artifactRepository = this.mavenSession.getProjectBuildingRequest().getLocalRepository();
        String localPath = artifactRepository.getBasedir();
        if (this.featureArchiveClassifiers != null && !this.featureArchiveClassifiers.isEmpty()) {
            for (String featureArchiveClassifier : this.featureArchiveClassifiers) {
                id = new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), featureArchiveClassifier, "far");
                artifactPath = id.toMvnPath();
                this.getLog().info((CharSequence)("Artifact Maven Path: " + artifactPath));
                file = new File(localPath, artifactPath);
                this.handleFile(arguments, file, "-f");
            }
        }
        if (this.featureArchiveIds != null && !this.featureArchiveIds.isEmpty()) {
            for (String featureArchive : this.featureArchiveIds) {
                id = ArtifactId.parse((String)featureArchive);
                if (id == null) continue;
                artifactPath = id.toMvnPath();
                this.getLog().info((CharSequence)("Artifact Maven Path: " + artifactPath));
                file = new File(localPath, artifactPath);
                this.handleFile(arguments, file, "-f");
            }
        }
        if (this.selection != null && !this.selection.getSelections().isEmpty()) {
            Collection<Feature> features = this.getSelectedFeatures(this.selection).values();
            this.getLog().info((CharSequence)("Features from Selection: " + features));
            for (Feature feature : features) {
                File folder = Files.createTempDir();
                ArtifactId id2 = feature.getId();
                File featureFile = new File(folder, id2.toMvnId().replaceAll(":", "-") + ".json");
                try (FileWriter writer = new FileWriter(featureFile);){
                    FeatureJSONWriter.write((Writer)writer, (Feature)feature);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write feature file  :" + id2.toMvnId(), (Exception)e);
                }
                this.getLog().info((CharSequence)("Feature File Location: " + featureFile));
                this.handleFile(arguments, featureFile, "-f");
            }
        }
        this.handleStringList(arguments, this.artifactClashOverrides, "-C");
        this.handleString(arguments, this.repositoryUrl, "-u");
        this.handleStringList(arguments, this.frameworkProperties, "-D");
        this.handleStringList(arguments, this.variableValues, "-V");
        if (this.verbose) {
            arguments.add("-v");
        }
        this.handleFile(arguments, this.cacheDirectory, "-c");
        this.handleFile(arguments, this.homeDirectory, "-p");
        this.handleStringList(arguments, this.extensionConfigurations, "-ec");
        this.handleString(arguments, this.frameworkVersion, "-fw");
        this.handleStringList(arguments, this.frameworkArtifacts, "-fa");
        String[] args = arguments.toArray(new String[0]);
        this.getLog().info((CharSequence)("Launcher Arguments: '" + arguments + "'"));
        this.launch(args);
    }

    void launch(String[] arguments) throws MojoExecutionException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.sling.feature.launcher.impl.Main");
            Method main = clazz.getMethod("main", String[].class);
            main.invoke(null, new Object[]{arguments});
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new MojoExecutionException("Failed to load Feature Launcher or Method not available, make sure the Launcher Dependency is added to the Plugin", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Invocation of Launcher's Main.main() failed", e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MojoExecutionException("Access denied or wrong Arguments", e);
        }
    }

    private void handleStringList(List<String> arguments, String[] list, String parameter) {
        if (list != null) {
            for (String item : list) {
                arguments.add(parameter);
                arguments.add(item);
            }
        }
    }

    private void handleString(List<String> arguments, String item, String parameter) {
        if (item != null && !item.isEmpty()) {
            arguments.add(parameter);
            arguments.add(item);
        }
    }

    private void handleFile(List<String> arguments, File file, String parameter) {
        if (file != null) {
            arguments.add(parameter);
            arguments.add(file.getAbsolutePath());
        }
    }
}

