/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;

public class ApisUtil {
    public static final String SCM_TAG = "scm-tag";
    public static final String SCM_LOCATION = "scm-location";
    public static final String SCM_ENCODING = "scm-encoding";
    public static final String API_IDS = "api-ids";
    public static final String SCM_IDS = "source-ids";
    public static final String SCM_CLASSIFIER = "source-classifier";
    public static final String JAVADOC_LINKS = "javadoc-links";
    public static final String IGNORE_PACKAGES = "apis-ignore";

    public static List<ArtifactId> getSourceIds(Artifact artifact) throws MojoExecutionException {
        String val = (String)artifact.getMetadata().get(SCM_IDS);
        if (val != null) {
            ArrayList<ArtifactId> result = new ArrayList<ArtifactId>();
            for (String v : val.split(",")) {
                try {
                    ArtifactId sourceId = ArtifactId.parse((String)v.trim());
                    if (sourceId.getClassifier() == null) {
                        throw new MojoExecutionException("Metadata source-ids must specify classifier for source artifacts : " + sourceId.toMvnId());
                    }
                    result.add(sourceId);
                }
                catch (IllegalArgumentException iae) {
                    throw new MojoExecutionException("Wrong format for artifact id : " + v);
                }
            }
            return result;
        }
        return null;
    }

    public static List<ArtifactId> getApiIds(Artifact artifact) throws MojoExecutionException {
        String val = (String)artifact.getMetadata().get(API_IDS);
        if (val != null) {
            ArrayList<ArtifactId> result = new ArrayList<ArtifactId>();
            for (String v : val.split(",")) {
                try {
                    ArtifactId id = ArtifactId.parse((String)v.trim());
                    result.add(id);
                }
                catch (IllegalArgumentException iae) {
                    throw new MojoExecutionException("Wrong format for artifact id : " + v);
                }
            }
            return result;
        }
        return null;
    }

    public static List<String> getJavadocLinks(Artifact artifact) {
        String val = (String)artifact.getMetadata().get(JAVADOC_LINKS);
        if (val != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String v : val.split(",")) {
                if ((v = v.trim()).endsWith("/")) {
                    v = v.substring(0, v.length() - 1);
                }
                result.add(v);
            }
            return result;
        }
        return null;
    }

    public static void getPackageList(String javadocUrl, Set<String> linkedPackages, Map<String, Set<String>> linkedPackagesMap) throws MojoExecutionException {
        Set<String> result = linkedPackagesMap.get(javadocUrl);
        if (result == null) {
            result = new HashSet<String>();
            linkedPackagesMap.put(javadocUrl, result);
            try {
                URL url = new URL(javadocUrl.concat("/package-list"));
                try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        result.add(line.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to find/read package-list at ".concat(javadocUrl), (Exception)e);
            }
        }
        result.stream().forEach(v -> linkedPackages.add((String)v));
    }

    public static Set<String> getIgnoredPackages(Artifact bundle) {
        HashSet<String> result = new HashSet<String>();
        String ignore = (String)bundle.getMetadata().get(IGNORE_PACKAGES);
        if (ignore != null) {
            for (String p : ignore.split(",")) {
                result.add(p.trim());
            }
        }
        return result;
    }

    public static void validateSourceInfo(Artifact artifact) throws MojoExecutionException {
        int count = 0;
        if (artifact.getMetadata().get(SCM_LOCATION) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_CLASSIFIER) != null) {
            ++count;
        }
        if (artifact.getMetadata().get(SCM_IDS) != null) {
            ++count;
        }
        if (count > 1) {
            throw new MojoExecutionException("Only one source configuration out of source-classifier, source-ids or scm-location is allowed for " + artifact.getId().toMvnId());
        }
    }
}

