/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.utils.manifest.Clause;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.maven.mojos.apis.ApisUtil;
import org.apache.sling.feature.maven.mojos.selection.IncludeExcludeMatcher;

public class ApisJarContext {
    private final Set<String> javadocClasspath = new HashSet<String>();
    private final Map<String, ArtifactId> packagesWithoutJavaClassesMap = new HashMap<String, ArtifactId>();
    private final Map<String, ArtifactId> packagesWithoutSourcesMap = new HashMap<String, ArtifactId>();
    private final File deflatedBinDir;
    private final File deflatedSourcesDir;
    private final File checkedOutSourcesDir;
    private File javadocDir;
    private final List<ArtifactInfo> infos = new ArrayList<ArtifactInfo>();
    private final ArtifactId featureId;
    private final ApiRegions apiRegions;
    private final Map<ArtifactId, Model> modelCache = new HashMap<ArtifactId, Model>();
    private IncludeExcludeMatcher licenseDefaultMatcher;
    private Set<String> dependencyRepositories = new HashSet<String>();

    public ApisJarContext(File mainDir, ArtifactId featureId, ApiRegions regions) {
        this.featureId = featureId;
        this.deflatedBinDir = new File(mainDir, "deflated-bin");
        this.deflatedSourcesDir = new File(mainDir, "deflated-sources");
        this.checkedOutSourcesDir = new File(mainDir, "checkouts");
        this.apiRegions = regions;
    }

    public ArtifactId getFeatureId() {
        return this.featureId;
    }

    public ApiRegions getApiRegions() {
        return this.apiRegions;
    }

    public File getDeflatedBinDir() {
        return this.deflatedBinDir;
    }

    public File getDeflatedSourcesDir() {
        return this.deflatedSourcesDir;
    }

    public File getCheckedOutSourcesDir() {
        return this.checkedOutSourcesDir;
    }

    public boolean addJavadocClasspath(String classpathItem) {
        return this.javadocClasspath.add(classpathItem);
    }

    public Set<String> getJavadocClasspath() {
        return this.javadocClasspath;
    }

    public File getJavadocDir() {
        return this.javadocDir;
    }

    public void setJavadocDir(File javadocDir) {
        this.javadocDir = javadocDir;
    }

    public Map<String, ArtifactId> getPackagesWithoutJavaClassesMap() {
        return this.packagesWithoutJavaClassesMap;
    }

    public Map<String, ArtifactId> getPackagesWithoutSourcesMap() {
        return this.packagesWithoutSourcesMap;
    }

    public Set<String> getPackagesWithoutJavaClasses() {
        return this.packagesWithoutJavaClassesMap.keySet();
    }

    public Set<String> getPackagesWithoutSources() {
        return this.packagesWithoutSourcesMap.keySet();
    }

    public ArtifactInfo addArtifactInfo(Artifact artifact) {
        ArtifactInfo info = new ArtifactInfo(artifact);
        this.infos.add(info);
        return info;
    }

    public List<ArtifactInfo> getArtifactInfos() {
        return this.infos;
    }

    public Map<ArtifactId, Model> getModelCache() {
        return this.modelCache;
    }

    public Collection<ArtifactInfo> getArtifactInfos(ApiRegion region, boolean omitDependencyArtifacts) {
        TreeMap<ArtifactId, ArtifactInfo> result = new TreeMap<ArtifactId, ArtifactInfo>();
        for (ArtifactInfo info : this.infos) {
            if (info.getUsedExportedPackages(region).isEmpty() || omitDependencyArtifacts && info.isUseAsDependencyPerRegion(region)) continue;
            result.put(info.getId(), info);
        }
        return result.values();
    }

    public void setLicenseDefaults(List<String> licenseDefaults) throws MojoExecutionException {
        this.licenseDefaultMatcher = new IncludeExcludeMatcher(licenseDefaults, null, "=", true);
    }

    public String getLicenseDefault(ArtifactId id) {
        return this.licenseDefaultMatcher.matches(id);
    }

    public void setDependencyRepositories(String list) {
        this.dependencyRepositories.clear();
        if (list != null) {
            for (String val : list.split(",")) {
                if (!(val = val.trim()).endsWith("/")) {
                    val = val.concat("/");
                }
                this.dependencyRepositories.add(val);
            }
        }
    }

    private boolean findDependencyArtifact(Log log, ArtifactId id) throws MojoExecutionException {
        boolean result = true;
        if (!this.dependencyRepositories.isEmpty()) {
            result = false;
            log.debug((CharSequence)"Trying to resolve ".concat(id.toMvnId()).concat(" from ").concat(this.dependencyRepositories.toString()));
            for (String server : this.dependencyRepositories) {
                try {
                    URL url = new URL(server.concat(id.toMvnPath()));
                    try {
                        url.openConnection().getInputStream().close();
                        log.debug((CharSequence)"Found ".concat(id.toMvnId()).concat(" at ").concat(url.toString()));
                        result = true;
                        break;
                    }
                    catch (IOException e) {
                        log.debug((CharSequence)"Missed ".concat(id.toMvnId()).concat(" at ").concat(url.toString()).concat(" : ").concat(e.toString()));
                    }
                }
                catch (MalformedURLException mue) {
                    throw new MojoExecutionException("Unable to find dependency on ".concat(server), (Exception)mue);
                }
            }
        }
        return result;
    }

    public boolean findDependencyArtifact(Log log, ArtifactInfo info) throws MojoExecutionException {
        boolean result = true;
        for (ArtifactId id : info.getDependencyArtifacts()) {
            if (this.findDependencyArtifact(log, id)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static final class ArtifactInfo {
        private Artifact artifact;
        private File binDirectory;
        private File sourceDirectory;
        private Set<String> usedExportedPackages;
        private final Map<String, Set<Clause>> usedExportedPackagesRegion = new HashMap<String, Set<Clause>>();
        private final Map<String, Boolean> useAsDependencyPerRegion = new HashMap<String, Boolean>();
        private final Set<File> includedResources = new HashSet<File>();
        private final Set<String> nodeTypes = new HashSet<String>();
        private List<License> licenses;

        public ArtifactInfo(Artifact artifact) {
            this.artifact = artifact;
        }

        public ArtifactId getId() {
            return this.artifact.getId();
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public File getBinDirectory() {
            return this.binDirectory;
        }

        public void setBinDirectory(File binDirectory) {
            this.binDirectory = binDirectory;
        }

        public File getSourceDirectory() {
            return this.sourceDirectory;
        }

        public void setSourceDirectory(File sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
        }

        public Set<String> getUsedExportedPackages() {
            return this.usedExportedPackages;
        }

        public void setUsedExportedPackages(Set<String> usedExportedPackages) {
            this.usedExportedPackages = usedExportedPackages;
        }

        public String[] getUsedExportedPackageIncludes() {
            HashSet<String> includes = new HashSet<String>();
            for (String pck : this.usedExportedPackages) {
                includes.add(pck.replace('.', '/').concat("/*"));
            }
            return includes.toArray(new String[includes.size()]);
        }

        public Set<Clause> getUsedExportedPackages(ApiRegion region) {
            return this.usedExportedPackagesRegion.get(region.getName());
        }

        public void setUsedExportedPackages(ApiRegion region, Set<Clause> usedExportedPackages, boolean useAsDependency) {
            this.usedExportedPackagesRegion.put(region.getName(), usedExportedPackages);
            this.useAsDependencyPerRegion.put(region.getName(), useAsDependency);
        }

        public String[] getUsedExportedPackageIncludes(ApiRegion region) {
            Set<Clause> clauses = this.getUsedExportedPackages(region);
            HashSet<String> includes = new HashSet<String>();
            for (Clause clause : clauses) {
                includes.add(clause.getName().replace('.', '/').concat("/*"));
            }
            return includes.toArray(new String[includes.size()]);
        }

        public boolean isUseAsDependencyPerRegion(ApiRegion region) {
            return this.useAsDependencyPerRegion.get(region.getName());
        }

        public Set<File> getIncludedResources() {
            return this.includedResources;
        }

        public Set<String> getNodeTypes() {
            return this.nodeTypes;
        }

        public List<License> getLicenses() {
            return this.licenses;
        }

        public void setLicenses(List<License> licenses) {
            this.licenses = licenses;
        }

        public List<ArtifactId> getDependencyArtifacts() throws MojoExecutionException {
            ArrayList<ArtifactId> dependencies = new ArrayList<ArtifactId>();
            List<ArtifactId> apiIds = ApisUtil.getApiIds(this.artifact);
            if (apiIds != null) {
                for (ArtifactId id : apiIds) {
                    dependencies.add(id);
                }
            } else {
                List<ArtifactId> sourceIds = ApisUtil.getSourceIds(this.artifact);
                if (sourceIds != null) {
                    for (ArtifactId id : sourceIds) {
                        dependencies.add(id.changeClassifier(null));
                    }
                } else {
                    dependencies.add(this.getId());
                }
            }
            return dependencies;
        }
    }
}

