/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.archive.ArchiveWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.Archive;

@Mojo(name="attach-featurearchives", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachFeatureArchivesMojo
extends AbstractIncludingFeatureMojo {
    private static final String EXTENSION = "zip";
    private static final String CLASSIFIER = "far";
    @Parameter
    private List<Archive> archives;
    public static final String ATTR_BUILT_BY = "Built-By";
    public static final String ATTR_CREATED_BY = "Created-By";
    public static final String ATTR_IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String ATTR_IMPLEMENTATION_VENDOR = "Implementation-Vendor";
    public static final String ATTR_IMPLEMENTATION_BUILD = "Implementation-Build";
    public static final String ATTR_IMPLEMENTATION_VENDOR_ID = "Implementation-Vendor-Id";
    public static final String ATTR_IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String ATTR_SPECIFICATION_TITLE = "Specification-Title";
    public static final String ATTR_SPECIFICATION_VENDOR = "Specification-Vendor";
    public static final String ATTR_SPECIFICATION_VERSION = "Specification-Version";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        if (this.archives == null || this.archives.size() == 0) {
            this.attachArchives(ProjectHelper.getFeatures(this.project));
        } else {
            for (Archive archive : this.archives) {
                if (archive.getClassifier() == null) {
                    throw new MojoExecutionException("Classifier is missing for archive.");
                }
                ArrayList<Feature> features = new ArrayList<Feature>();
                features.addAll(this.getSelectedFeatures(archive).values());
                this.attachArchives(features, archive.getClassifier(), archive.attach);
            }
        }
    }

    void attachArchives(Map<String, Feature> features) throws MojoExecutionException {
        for (Map.Entry<String, Feature> entry : features.entrySet()) {
            boolean add = ProjectHelper.isAggregate(entry.getKey()) ? ProjectHelper.isAttachAggregate(entry.getKey()) : true;
            if (!add) continue;
            String classifier = entry.getValue().getId().getClassifier() == null ? CLASSIFIER : entry.getValue().getId().getClassifier().concat(CLASSIFIER);
            this.attachArchives(Collections.singletonList(entry.getValue()), classifier, true);
        }
    }

    private Manifest createBaseManifest(Feature feature) {
        Manifest mf = new Manifest();
        mf.getMainAttributes().putValue(ATTR_IMPLEMENTATION_BUILD, this.project.getVersion());
        mf.getMainAttributes().putValue(ATTR_IMPLEMENTATION_VERSION, this.project.getVersion());
        mf.getMainAttributes().putValue(ATTR_SPECIFICATION_VERSION, this.project.getVersion());
        if (feature.getVendor() != null) {
            mf.getMainAttributes().putValue(ATTR_IMPLEMENTATION_VENDOR, feature.getVendor());
            mf.getMainAttributes().putValue(ATTR_CREATED_BY, feature.getVendor());
            mf.getMainAttributes().putValue(ATTR_BUILT_BY, feature.getVendor());
            mf.getMainAttributes().putValue(ATTR_SPECIFICATION_VENDOR, feature.getVendor());
        }
        mf.getMainAttributes().putValue(ATTR_IMPLEMENTATION_VENDOR_ID, this.project.getGroupId());
        if (feature != null && feature.getTitle() != null) {
            mf.getMainAttributes().putValue(ATTR_IMPLEMENTATION_TITLE, feature.getTitle());
            mf.getMainAttributes().putValue(ATTR_SPECIFICATION_TITLE, feature.getTitle());
        } else if (this.project.getName() != null) {
            mf.getMainAttributes().putValue(ATTR_IMPLEMENTATION_TITLE, this.project.getName());
            mf.getMainAttributes().putValue(ATTR_SPECIFICATION_TITLE, this.project.getName());
        }
        return mf;
    }

    private void attachArchives(List<Feature> features, String classifier, boolean attach) throws MojoExecutionException {
        ArtifactId archiveId = features.get(0).getId().changeClassifier(classifier).changeType(EXTENSION);
        File outputFile = new File(this.project.getBuild().getDirectory().concat(File.separator).concat(archiveId.toMvnName()));
        outputFile.getParentFile().mkdirs();
        this.getLog().info((CharSequence)("Creating feature archive " + outputFile.getName()));
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             JarOutputStream jos = ArchiveWriter.write((OutputStream)fos, (Manifest)this.createBaseManifest(features.size() == 1 ? features.get(0) : null), id -> {
            try {
                return ProjectHelper.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, id).getFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                return null;
            }
        }, (Feature[])features.toArray(new Feature[features.size()]));){
            jos.setLevel(9);
            File classesDir = new File(this.project.getBuild().getOutputDirectory());
            if (classesDir.exists()) {
                File metaInfDir = new File(classesDir, "META-INF");
                for (String name : new String[]{"LICENSE", "NOTICE", "DEPENDENCIES"}) {
                    File f = new File(metaInfDir, name);
                    if (!f.exists()) continue;
                    JarEntry artifactEntry = new JarEntry("META-INF/" + name);
                    jos.putNextEntry(artifactEntry);
                    byte[] buffer = new byte[8192];
                    try (FileInputStream is = new FileInputStream(f);){
                        int l = 0;
                        while ((l = ((InputStream)is).read(buffer)) > 0) {
                            jos.write(buffer, 0, l);
                        }
                    }
                    jos.closeEntry();
                }
            }
            jos.finish();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write feature model archive to " + outputFile + " : " + e.getMessage(), (Exception)e);
        }
        if (attach) {
            this.projectHelper.attachArtifact(this.project, archiveId.getType(), archiveId.getClassifier(), outputFile);
        }
    }
}

