/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.utils.manifest.Clause;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.maven.mojos.selection.IncludeExcludeMatcher;

class ApisJarContext {
    private final Set<String> javadocClasspath = new HashSet<String>();
    private final Set<String> packagesWithoutJavaClasses = new HashSet<String>();
    private final Set<String> packagesWithoutSources = new HashSet<String>();
    private final File deflatedBinDir;
    private final File deflatedSourcesDir;
    private final File checkedOutSourcesDir;
    private File javadocDir;
    private final List<ArtifactInfo> infos = new ArrayList<ArtifactInfo>();
    private final ArtifactId featureId;
    private final ApiRegions apiRegions;
    private final Map<ArtifactId, Model> modelCache = new HashMap<ArtifactId, Model>();
    private IncludeExcludeMatcher licenseDefaultMatcher;

    public ApisJarContext(File mainDir, ArtifactId featureId, ApiRegions regions) {
        this.featureId = featureId;
        this.deflatedBinDir = new File(mainDir, "deflated-bin");
        this.deflatedSourcesDir = new File(mainDir, "deflated-sources");
        this.checkedOutSourcesDir = new File(mainDir, "checkouts");
        this.apiRegions = regions;
    }

    public ArtifactId getFeatureId() {
        return this.featureId;
    }

    public ApiRegions getApiRegions() {
        return this.apiRegions;
    }

    public File getDeflatedBinDir() {
        return this.deflatedBinDir;
    }

    public File getDeflatedSourcesDir() {
        return this.deflatedSourcesDir;
    }

    public File getCheckedOutSourcesDir() {
        return this.checkedOutSourcesDir;
    }

    public boolean addJavadocClasspath(String classpathItem) {
        return this.javadocClasspath.add(classpathItem);
    }

    public Set<String> getJavadocClasspath() {
        return this.javadocClasspath;
    }

    public File getJavadocDir() {
        return this.javadocDir;
    }

    public void setJavadocDir(File javadocDir) {
        this.javadocDir = javadocDir;
    }

    public Set<String> getPackagesWithoutJavaClasses() {
        return this.packagesWithoutJavaClasses;
    }

    public Set<String> getPackagesWithoutSources() {
        return this.packagesWithoutSources;
    }

    public ArtifactInfo addArtifactInfo(ArtifactId id) {
        ArtifactInfo info = new ArtifactInfo(id);
        this.infos.add(info);
        return info;
    }

    public List<ArtifactInfo> getArtifactInfos() {
        return this.infos;
    }

    public Map<ArtifactId, Model> getModelCache() {
        return this.modelCache;
    }

    public Collection<ArtifactInfo> getArtifactInfos(ApiRegion region) {
        TreeMap<ArtifactId, ArtifactInfo> result = new TreeMap<ArtifactId, ArtifactInfo>();
        for (ArtifactInfo info : this.infos) {
            if (info.getUsedExportedPackages(region).isEmpty()) continue;
            result.put(info.getId(), info);
        }
        return result.values();
    }

    public void setLicenseDefaults(List<String> licenseDefaults) throws MojoExecutionException {
        this.licenseDefaultMatcher = new IncludeExcludeMatcher(licenseDefaults, null, "=", true);
    }

    public String getLicenseDefault(ArtifactId id) {
        return this.licenseDefaultMatcher.matches(id);
    }

    public static final class ArtifactInfo {
        private ArtifactId id;
        private File binDirectory;
        private File sourceDirectory;
        private Set<String> usedExportedPackages;
        private final Map<String, Set<Clause>> usedExportedPackagesRegion = new HashMap<String, Set<Clause>>();
        private final Set<File> includedResources = new HashSet<File>();
        private final Set<String> nodeTypes = new HashSet<String>();
        private List<License> licenses;

        public ArtifactInfo(ArtifactId id) {
            this.id = id;
        }

        public ArtifactId getId() {
            return this.id;
        }

        public File getBinDirectory() {
            return this.binDirectory;
        }

        public void setBinDirectory(File binDirectory) {
            this.binDirectory = binDirectory;
        }

        public File getSourceDirectory() {
            return this.sourceDirectory;
        }

        public void setSourceDirectory(File sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
        }

        public Set<String> getUsedExportedPackages() {
            return this.usedExportedPackages;
        }

        public void setUsedExportedPackages(Set<String> usedExportedPackages) {
            this.usedExportedPackages = usedExportedPackages;
        }

        public String[] getUsedExportedPackageIncludes() {
            HashSet<String> includes = new HashSet<String>();
            for (String pck : this.usedExportedPackages) {
                includes.add(pck.replace('.', '/').concat("/*"));
            }
            return includes.toArray(new String[includes.size()]);
        }

        public Set<Clause> getUsedExportedPackages(ApiRegion region) {
            return this.usedExportedPackagesRegion.get(region.getName());
        }

        public void setUsedExportedPackages(ApiRegion region, Set<Clause> usedExportedPackages) {
            this.usedExportedPackagesRegion.put(region.getName(), usedExportedPackages);
        }

        public String[] getUsedExportedPackageIncludes(ApiRegion region) {
            Set<Clause> clauses = this.getUsedExportedPackages(region);
            HashSet<String> includes = new HashSet<String>();
            for (Clause clause : clauses) {
                includes.add(clause.getName().replace('.', '/').concat("/*"));
            }
            return includes.toArray(new String[includes.size()]);
        }

        public Set<File> getIncludedResources() {
            return this.includedResources;
        }

        public Set<String> getNodeTypes() {
            return this.nodeTypes;
        }

        public List<License> getLicenses() {
            return this.licenses;
        }

        public void setLicenses(List<License> licenses) {
            this.licenses = licenses;
        }
    }
}

