/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;

@Mojo(name="include-artifact", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class IncludeArtifact
extends AbstractFeatureMojo {
    @Parameter
    private String includeArtifactClassifier;
    @Parameter
    private String includeArtifactExtension;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.includeArtifactClassifier == null) {
            throw new MojoExecutionException("includeArtifactClassifier is not specified. Check your configuration");
        }
        this.checkPreconditions();
        Map<String, Feature> featuresMap = ProjectHelper.getFeatures(this.project);
        Feature found = null;
        String key = null;
        for (Map.Entry<String, Feature> entry : featuresMap.entrySet()) {
            if (!this.includeArtifactClassifier.equals(entry.getValue().getId().getClassifier())) continue;
            key = entry.getKey();
            found = entry.getValue();
            break;
        }
        Artifact art = new Artifact(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, this.project.getArtifact().getType()));
        File file = null;
        if (found == null) {
            found = new Feature(new ArtifactId(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.includeArtifactClassifier, "slingosgifeature"));
            file = new File(this.getTmpDir(), "feature-" + this.includeArtifactClassifier + ".json");
            key = file.getAbsolutePath();
            ProjectHelper.getFeatures(this.project).put(key, found);
            ProjectHelper.getAssembledFeatures(this.project).put(key, found);
        }
        this.includeArtifact(found, this.includeArtifactExtension, art);
        this.includeArtifact(ProjectHelper.getAssembledFeatures(this.project).get(key), this.includeArtifactExtension, art.copy(art.getId()));
        if (file != null) {
            try (FileWriter writer = new FileWriter(file);){
                FeatureJSONWriter.write((Writer)writer, (Feature)found);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to write feature", (Exception)ioe);
            }
        }
    }

    private void includeArtifact(Feature f, String extensionName, Artifact art) throws MojoExecutionException {
        Bundles container = f.getBundles();
        if (extensionName != null) {
            Extension ext = f.getExtensions().getByName(extensionName);
            if (ext == null) {
                ext = new Extension(ExtensionType.ARTIFACTS, extensionName, ExtensionState.REQUIRED);
                f.getExtensions().add((Object)ext);
            }
            if (ext.getType() != ExtensionType.ARTIFACTS) {
                throw new MojoExecutionException("Wrong extension type for extension " + extensionName + " : " + ext.getType());
            }
            container = ext.getArtifacts();
        }
        container.add(art);
    }
}

