/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.AbstractRepositoryMojo;
import org.apache.sling.feature.maven.mojos.Repository;

@Mojo(name="repository", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class RepositoryMojo
extends AbstractRepositoryMojo {
    @Parameter
    List<Repository> repositories;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        if (this.repositories == null || this.repositories.isEmpty()) {
            File artifactDir = new File(this.project.getBuild().getDirectory(), this.repositoryDir);
            this.doExecute(artifactDir, this.selectAllFeatureFilesAndAggregates(), null);
        } else {
            for (Repository rep : this.repositories) {
                Map<String, Feature> selection = this.getSelectedFeatures(rep);
                File artifactDir = new File(this.project.getBuild().getDirectory(), rep.repositoryDir);
                this.doExecute(artifactDir, selection, rep.getEmbedArtifacts());
            }
        }
    }
}

