/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParsingException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="update-feature-versions", threadSafe=true)
public class UpdateVersionsMojo
extends AbstractIncludingFeatureMojo {
    private static final int INFO_PAD_SIZE = 95;
    @Parameter(property="includes")
    private String updatesIncludesList;
    @Parameter(property="excludes")
    private String updatesExcludesList;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List remoteArtifactRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;

    private VersionsHelper getHelper() throws MojoExecutionException {
        return new DefaultVersionsHelper(this.artifactFactory, this.artifactResolver, this.artifactMetadataSource, this.remoteArtifactRepositories, null, this.localRepository, null, null, null, null, this.getLog(), this.mavenSession, null);
    }

    private List<String[]> parseMatches(String value, String matchType) throws MojoExecutionException {
        ArrayList<String[]> matches = null;
        if (value != null) {
            matches = new ArrayList<String[]>();
            for (String t : value.split(",")) {
                String[] val = t.split(":");
                if (val.length > 5) {
                    throw new MojoExecutionException("Illegal " + matchType + " " + val);
                }
                matches.add(val);
            }
        }
        return matches;
    }

    private Map<String, Feature> getFeatures() throws MojoExecutionException {
        return this.selectAllFeatureFiles();
    }

    private void addDependencies(Set<Dependency> dependencies, List<Artifact> artifacts) {
        for (Artifact a : artifacts) {
            dependencies.add(ProjectHelper.toDependency(a.getId(), "provided"));
        }
    }

    private Set<Dependency> getDependencies(Map<String, Feature> features) {
        TreeSet<Dependency> dependencies = new TreeSet<Dependency>((Comparator<Dependency>)new DependencyComparator());
        for (Map.Entry<String, Feature> entry : features.entrySet()) {
            this.addDependencies(dependencies, (List<Artifact>)entry.getValue().getBundles());
            for (Extension ext : entry.getValue().getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS) continue;
                this.addDependencies(dependencies, (List<Artifact>)ext.getArtifacts());
            }
        }
        return dependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Feature readRawFeature(String fileName) throws MojoExecutionException {
        File out = new File(fileName);
        try (FileReader r = new FileReader(out);){
            Feature feature = SimpleFeatureJSONReader.read(r, fileName);
            return feature;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read feature file " + fileName, (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        Map<String, Feature> assembledFeatures = this.getFeatures();
        if (assembledFeatures.isEmpty()) {
            throw new MojoExecutionException("No features found in project!");
        }
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> entry : assembledFeatures.entrySet()) {
            features.put(entry.getKey(), ProjectHelper.getFeatures(this.project).get(entry.getKey()));
        }
        UpdateConfig cfg = new UpdateConfig();
        Set<Dependency> dependencies = this.getDependencies(features);
        try {
            cfg.updateInfos = this.calculateUpdateInfos(this.getHelper().lookupDependenciesUpdates(dependencies, false));
        }
        catch (ArtifactMetadataRetrievalException | InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Unable to calculate updates", (Exception)e);
        }
        cfg.includes = this.parseMatches(this.updatesIncludesList, "include");
        cfg.excludes = this.parseMatches(this.updatesExcludesList, "exclude");
        LinkedHashMap results = new LinkedHashMap();
        HashMap<String, Set<String>> globalPropertyUpdates = new HashMap<String, Set<String>>();
        for (Map.Entry entry : features.entrySet()) {
            this.getLog().debug((CharSequence)("Checking feature file " + (String)entry.getKey()));
            UpdateResult result = new UpdateResult();
            results.put(entry.getKey(), result);
            result.updates = this.getUpdates((Feature)entry.getValue(), cfg);
            if (result.updates.isEmpty()) continue;
            Feature rawFeature = this.readRawFeature((String)entry.getKey());
            if (!this.updateVersions((String)entry.getKey(), rawFeature, result, globalPropertyUpdates) || this.dryRun) continue;
            try {
                FileWriter fileWriter = new FileWriter(new File((String)entry.getKey()));
                Throwable throwable = null;
                try {
                    SimpleFeatureJSONWriter.write(fileWriter, rawFeature);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileWriter == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)fileWriter).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)fileWriter).close();
                }
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Unable to write feature file " + entry.getValue(), (Exception)iOException);
            }
        }
        boolean printedHeader = false;
        for (Map.Entry entry : results.entrySet()) {
            if (!((UpdateResult)entry.getValue()).updates.isEmpty()) continue;
            if (!printedHeader) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"The following features have no updates:");
                printedHeader = true;
            }
            this.getLog().info((CharSequence)("- " + (String)entry.getKey()));
        }
        printedHeader = false;
        for (Map.Entry entry : results.entrySet()) {
            String right;
            String left;
            if (((UpdateResult)entry.getValue()).updates.isEmpty()) continue;
            if (!printedHeader) {
                this.getLog().info((CharSequence)"");
                if (this.dryRun) {
                    this.getLog().info((CharSequence)"The following features could be updated:");
                } else {
                    this.getLog().info((CharSequence)"The following features are updated:");
                }
                printedHeader = true;
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Feature " + (String)entry.getKey()));
            for (ArtifactUpdate artifactUpdate : ((UpdateResult)entry.getValue()).updates) {
                left = "  " + artifactUpdate.artifact.getId().toMvnId() + "...";
                right = " -> " + artifactUpdate.newVersion;
                if (right.length() + left.length() > 95) {
                    this.getLog().info((CharSequence)left);
                    this.getLog().info((CharSequence)StringUtils.leftPad((String)right, (int)95));
                    continue;
                }
                this.getLog().info((CharSequence)(StringUtils.rightPad((String)left, (int)(95 - right.length()), (String)".") + right));
            }
            if (((UpdateResult)entry.getValue()).propertyUpdates.isEmpty()) continue;
            this.getLog().info((CharSequence)"  The following properties in the pom should be updated:");
            for (Map.Entry entry2 : ((UpdateResult)entry.getValue()).propertyUpdates.entrySet()) {
                left = "    Property '" + (String)entry2.getKey() + "' to ...";
                right = (String)entry2.getValue();
                if (right.length() + left.length() > 95) {
                    this.getLog().info((CharSequence)left);
                    this.getLog().info((CharSequence)StringUtils.leftPad((String)right, (int)95));
                    continue;
                }
                this.getLog().info((CharSequence)(StringUtils.rightPad((String)left, (int)(95 - right.length()), (String)".") + right));
            }
        }
        if (!globalPropertyUpdates.isEmpty()) {
            this.getLog().info((CharSequence)"Update summary for properties in the pom:");
            for (Map.Entry entry : globalPropertyUpdates.entrySet()) {
                if (((Set)entry.getValue()).size() > 1) {
                    throw new MojoExecutionException("Inconsistent use of version property " + (String)entry.getKey() + ". Different version updates available: " + entry.getValue());
                }
                String value = (String)((Set)entry.getValue()).iterator().next();
                Object object = this.project.getProperties().get(entry.getKey());
                if (object == null) {
                    throw new MojoExecutionException("Property '" + (String)entry.getKey() + "' is not defined in POM");
                }
                this.getLog().info((CharSequence)("  Please update property '" + (String)entry.getKey() + "' from " + object + " to " + value));
            }
        }
    }

    private boolean shouldHandle(ArtifactId id, UpdateConfig cfg) {
        boolean include = true;
        if (cfg.includes != null) {
            include = this.match(id, cfg.includes);
        }
        if (include && cfg.excludes != null) {
            include = !this.match(id, cfg.excludes);
        }
        return include;
    }

    private boolean match(ArtifactId id, List<String[]> matches) {
        boolean match = false;
        for (String[] m : matches) {
            match = id.getGroupId().equals(m[0]);
            if (match && m.length > 1) {
                match = id.getArtifactId().equals(m[1]);
            }
            if (match && m.length == 3) {
                match = id.getVersion().equals(m[2]);
            } else if (match && m.length == 4) {
                match = id.getVersion().equals(m[3]);
                if (match) {
                    match = id.getType().equals(m[2]);
                }
            } else if (match && m.length == 5 && (match = id.getVersion().equals(m[4])) && (match = id.getType().equals(m[2]))) {
                match = m[3].equals(id.getClassifier());
            }
            if (!match) continue;
            break;
        }
        return match;
    }

    private String update(Artifact artifact, List<Map.Entry<Dependency, String>> updates) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Searching for updates of " + artifact.getId().toMvnId()));
        String updated = null;
        String found = null;
        for (Map.Entry<Dependency, String> entry : updates) {
            if (!artifact.getId().getGroupId().equals(entry.getKey().getGroupId()) || !artifact.getId().getArtifactId().equals(entry.getKey().getArtifactId()) || !artifact.getId().getType().equals(entry.getKey().getType()) || artifact.getId().getVersion().equals(entry.getValue()) || (artifact.getId().getClassifier() != null || entry.getKey().getClassifier() != null) && (artifact.getId().getClassifier() == null || !artifact.getId().getClassifier().equals(entry.getKey().getClassifier()))) continue;
            found = entry.getValue();
            break;
        }
        if (found != null) {
            this.getLog().debug((CharSequence)("Updating " + artifact.getId().toMvnId() + " to " + found));
            updated = found;
        } else {
            this.getLog().debug((CharSequence)("No newer version found for " + artifact.getId().toMvnId()));
        }
        return updated;
    }

    private List<Map.Entry<Dependency, String>> calculateUpdateInfos(Map<Dependency, ArtifactVersions> updateInfos) {
        ArrayList<Map.Entry<Dependency, String>> updates = new ArrayList<Map.Entry<Dependency, String>>();
        for (final Map.Entry<Dependency, ArtifactVersions> entry : updateInfos.entrySet()) {
            ArtifactVersion latest;
            if (entry.getValue().isCurrentVersionDefined()) {
                latest = entry.getValue().getNewestUpdate(UpdateScope.ANY, false);
            } else {
                ArtifactVersion newestVersion = entry.getValue().getNewestVersion(entry.getValue().getArtifact().getVersionRange(), false);
                ArtifactVersion artifactVersion = latest = newestVersion == null ? null : entry.getValue().getNewestUpdate(newestVersion, UpdateScope.ANY, false);
                if (latest != null && ArtifactVersions.isVersionInRange((ArtifactVersion)latest, (VersionRange)entry.getValue().getArtifact().getVersionRange())) {
                    latest = null;
                }
            }
            if (latest == null) continue;
            final String newVersion = latest.toString();
            updates.add(new Map.Entry<Dependency, String>(){

                @Override
                public String setValue(String value) {
                    throw new IllegalStateException();
                }

                @Override
                public String getValue() {
                    return newVersion;
                }

                @Override
                public Dependency getKey() {
                    return (Dependency)entry.getKey();
                }
            });
        }
        return updates;
    }

    private boolean updateVersions(String fileName, Feature rawFeature, UpdateResult result, Map<String, Set<String>> globalPropertyUpdates) throws MojoExecutionException {
        Iterator<ArtifactUpdate> iter = result.updates.iterator();
        while (iter.hasNext()) {
            ArtifactUpdate update = iter.next();
            Object container = update.extension == null ? rawFeature.getBundles() : rawFeature.getExtensions().getByName(update.extension.getName()).getArtifacts();
            int pos = container.indexOf((Object)update.artifact);
            if (!container.removeExact(update.artifact.getId())) {
                boolean found;
                Artifact same = container.getSame(update.artifact.getId());
                boolean bl = found = same != null;
                if (same != null) {
                    if (!same.getId().getVersion().startsWith("${") || !same.getId().getVersion().endsWith("}")) {
                        found = false;
                    } else {
                        String propName = same.getId().getVersion().substring(2, same.getId().getVersion().length() - 1);
                        if (!update.artifact.getId().getVersion().equals(this.project.getProperties().get(propName))) {
                            found = false;
                        } else {
                            Set<String> versions = globalPropertyUpdates.get(propName);
                            if (versions == null) {
                                versions = new HashSet<String>();
                                globalPropertyUpdates.put(propName, versions);
                            }
                            versions.add(update.newVersion);
                            result.propertyUpdates.put(propName, update.newVersion);
                        }
                    }
                }
                if (!found) {
                    throw new MojoExecutionException("Unable to update artifact as it's not found in feature: " + update.artifact.getId().toMvnId());
                }
                iter.remove();
                continue;
            }
            if (pos == -1) {
                throw new MojoExecutionException("MIST " + update.artifact.getId().toMvnId());
            }
            Artifact newArtifact = new Artifact(new ArtifactId(update.artifact.getId().getGroupId(), update.artifact.getId().getArtifactId(), update.newVersion, update.artifact.getId().getClassifier(), update.artifact.getId().getType()));
            newArtifact.getMetadata().putAll(update.artifact.getMetadata());
            container.add(pos, (Object)newArtifact);
        }
        return !result.updates.isEmpty();
    }

    private void addUpdates(List<ArtifactUpdate> updates, Extension ext, Artifacts artifacts, UpdateConfig cfg) throws MojoExecutionException {
        for (Artifact a : artifacts) {
            String newVersion;
            if (!this.shouldHandle(a.getId(), cfg) || (newVersion = this.update(a, cfg.updateInfos)) == null) continue;
            ArtifactUpdate update = new ArtifactUpdate();
            update.artifact = a;
            update.newVersion = newVersion;
            update.extension = ext;
            updates.add(update);
        }
    }

    private List<ArtifactUpdate> getUpdates(Feature feature, UpdateConfig cfg) throws MojoExecutionException {
        ArrayList<ArtifactUpdate> updates = new ArrayList<ArtifactUpdate>();
        this.addUpdates(updates, null, (Artifacts)feature.getBundles(), cfg);
        for (Extension ext : feature.getExtensions()) {
            if (ext.getType() != ExtensionType.ARTIFACTS) continue;
            this.addUpdates(updates, ext, ext.getArtifacts(), cfg);
        }
        return updates;
    }

    public static class SimpleFeatureJSONWriter
    extends FeatureJSONWriter {
        private SimpleFeatureJSONWriter() {
        }

        public static void write(Writer writer, Feature feature) throws IOException {
            SimpleFeatureJSONWriter w = new SimpleFeatureJSONWriter();
            w.writeFeature(writer, feature);
        }

        protected void writeFeatureId(JsonGenerator generator, Feature feature) {
            if (!feature.getId().equals((Object)SimpleFeatureJSONReader.PLACEHOLDER_ID)) {
                super.writeFeatureId(generator, feature);
            }
        }
    }

    public static class SimpleFeatureJSONReader
    extends FeatureJSONReader {
        static final ArtifactId PLACEHOLDER_ID = new ArtifactId("_", "_", "1.0", null, null);

        protected SimpleFeatureJSONReader(String location) {
            super(location);
        }

        protected ArtifactId getFeatureId(Map<String, Object> map) throws IOException {
            ArtifactId id = !map.containsKey("id") ? PLACEHOLDER_ID : super.getFeatureId(map);
            return id;
        }

        public static Feature read(Reader reader, String location) throws IOException {
            try {
                SimpleFeatureJSONReader mr = new SimpleFeatureJSONReader(location);
                return mr.readFeature(reader);
            }
            catch (IllegalArgumentException | IllegalStateException | JsonParsingException e) {
                throw new IOException(e);
            }
        }
    }

    public static final class UpdateResult {
        public List<ArtifactUpdate> updates;
        public Map<String, String> propertyUpdates = new HashMap<String, String>();
    }

    public static final class ArtifactUpdate {
        public Extension extension;
        public Artifact artifact;
        public String newVersion;
    }

    public static final class UpdateConfig {
        public List<String[]> includes;
        public List<String[]> excludes;
        List<Map.Entry<Dependency, String>> updateInfos;
    }
}

