/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.sling.feature.maven.ProjectHelper;

public class FeatureSelectionConfig {
    private final List<Selection> selections = new ArrayList<Selection>();
    private final List<String> filesExcludes = new ArrayList<String>();

    public void setFilesInclude(String val) {
        this.selections.add(new Selection(SelectionType.FILE_INCLUDE, val));
    }

    public void setFilesExclude(String val) {
        this.filesExcludes.add(val);
    }

    public void setIncludeArtifact(Dependency a) {
        this.selections.add(new Selection(SelectionType.ARTIFACT, ProjectHelper.toArtifactId(a).toMvnId()));
    }

    public void setIncludeClassifier(String classifier) {
        this.selections.add(new Selection(SelectionType.AGGREGATE_CLASSIFIER, classifier));
    }

    public List<String> getFilesExcludes() {
        return this.filesExcludes;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public String toString() {
        return "FeatureSelectionConfig [selections=" + this.selections + ", filesExcludes=" + this.filesExcludes + "]";
    }

    static class Selection {
        public final SelectionType type;
        public final String instruction;

        public Selection(SelectionType type, String instruction) {
            this.type = type;
            this.instruction = instruction;
        }

        public String toString() {
            return "Selection [type=" + (Object)((Object)this.type) + ", instruction=" + this.instruction + "]";
        }
    }

    static enum SelectionType {
        FILE_INCLUDE,
        AGGREGATE_CLASSIFIER,
        ARTIFACT;

    }
}

