/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;

@Mojo(name="attach-features", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachFeaturesMojo
extends AbstractFeatureMojo {
    @Parameter(name="attachTestFeatures", defaultValue="false")
    private boolean attachTestFeatures;
    @Parameter(name="createReferenceFile", defaultValue="false")
    private boolean createReferenceFile;
    @Parameter(name="referenceFileClassifier")
    private String referenceFileClassifier;

    private void attach(Feature feature, String classifier) throws MojoExecutionException {
        File outputFile = new File(this.getTmpDir(), classifier == null ? "feature.json" : "feature-" + classifier + ".json");
        outputFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(outputFile);){
            FeatureJSONWriter.write((Writer)writer, (Feature)feature);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write feature " + feature.getId().toMvnId() + " to " + outputFile, (Exception)e);
        }
        if (this.project.getPackaging().equals("slingosgifeature") && classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, "slingosgifeature", classifier, outputFile);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectHelper.checkPreprocessorRun(this.project);
        ArrayList<String> featureUrls = new ArrayList<String>();
        this.attachClassifierFeatures(ProjectHelper.getFeatures(this.project).values(), featureUrls);
        if (this.attachTestFeatures) {
            this.attachClassifierFeatures(ProjectHelper.getTestFeatures(this.project).values(), featureUrls);
        }
        if (this.createReferenceFile) {
            this.createReferenceFile(featureUrls);
        }
    }

    private void createReferenceFile(List<String> featureUrls) throws MojoExecutionException {
        if (featureUrls.isEmpty()) {
            this.getLog().warn((CharSequence)"Create reference file is enabled but no features are attached. Skipping reference file generation.");
        } else {
            String fileName = "references";
            if (this.referenceFileClassifier != null) {
                fileName = fileName.concat("-").concat(this.referenceFileClassifier);
            }
            fileName = fileName.concat(".ref");
            File outputFile = new File(this.getTmpDir(), fileName);
            outputFile.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(outputFile);){
                for (String url : featureUrls) {
                    w.write(url);
                    ((Writer)w).write(10);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write feature reference file to " + outputFile, (Exception)e);
            }
            this.projectHelper.attachArtifact(this.project, "ref", this.referenceFileClassifier, outputFile);
        }
    }

    void attachClassifierFeatures(Collection<Feature> features, List<String> featureUrls) throws MojoExecutionException {
        for (Feature f : features) {
            this.attach(f, f.getId().getClassifier());
            featureUrls.add(f.getId().toMvnUrl());
        }
    }
}

