/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.felix.configurator.impl.json.JSMin;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.maven.Environment;
import org.apache.sling.feature.maven.FeatureProjectConfig;
import org.apache.sling.feature.maven.FeatureProjectInfo;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.Substitution;
import org.codehaus.plexus.logging.Logger;

public class Preprocessor {
    private final JsonSchema schema;
    private final ObjectMapper objectMapper;

    public Preprocessor() {
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.byDefault();
        String jsonSchemaUri = this.getClass().getClassLoader().getResource("META-INF/feature/Feature-1.0.0.schema.json").toExternalForm();
        try {
            this.schema = schemaFactory.getJsonSchema(jsonSchemaUri);
        }
        catch (ProcessingException e) {
            throw new RuntimeException("An error occured when retrieving the JSON Schema from " + jsonSchemaUri, e);
        }
        this.objectMapper = new ObjectMapper();
    }

    private void checkFeatureFileValidation(File featureFile, String json) {
        try {
            JsonNode instance = this.objectMapper.readTree(json);
            ProcessingReport report = this.schema.validate(instance, true);
            if (!report.isSuccess()) {
                Formatter formatter = new Formatter();
                formatter.format("Feature file %s validation detected one or more errors:%n", featureFile);
                for (ProcessingMessage message : report) {
                    if (LogLevel.FATAL != message.getLogLevel() && LogLevel.ERROR != message.getLogLevel()) continue;
                    formatter.format(" * %s: %s%n", message.asJson().get("schema").get("pointer").asText(), message.getMessage());
                }
                String errorMessage = formatter.toString();
                formatter.close();
                throw new RuntimeException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while reading " + featureFile + " Feature file:", e);
        }
        catch (ProcessingException e) {
            throw new RuntimeException("An error occurred while validating Feature " + featureFile + ", read the log for details:", e);
        }
    }

    public void process(Environment env) {
        for (FeatureProjectInfo finfo : env.modelProjects.values()) {
            this.process(env, finfo, FeatureProjectConfig.getMainConfig(finfo));
            this.process(env, finfo, FeatureProjectConfig.getTestConfig(finfo));
            if ("slingosgifeature".equals(finfo.project.getPackaging()) && finfo.features.isEmpty()) {
                throw new RuntimeException("Feature project has no feature defined: " + finfo.project.getId());
            }
            ProjectHelper.storeProjectInfo(finfo);
            ProjectHelper.validateFeatureClassifiers(finfo.project);
        }
    }

    private void process(Environment env, FeatureProjectInfo info, FeatureProjectConfig config) {
        Map<String, Feature> aggregatedFeatures;
        if (config.isTestConfig() && info.testFeatureDone || !config.isTestConfig() && info.featureDone) {
            env.logger.debug("Return assembled " + config.getName() + " for " + info.project.getId());
            return;
        }
        if (config.isTestConfig()) {
            info.testFeatureDone = true;
        } else {
            info.featureDone = true;
        }
        env.logger.debug("Processing " + config.getName() + " in project " + info.project.getId());
        this.readProjectFeatures(env.logger, info, config);
        if ((config.isTestConfig() ? info.testFeatures : info.features).isEmpty()) {
            env.logger.debug("No " + config.getName() + " found in project " + info.project.getId());
            return;
        }
        if ("jar".equals(info.project.getPackaging()) || "bundle".equals(info.project.getPackaging())) {
            if (config.isSkipAddJarToFeature()) {
                env.logger.debug("Skip adding jar to " + config.getName());
            } else {
                if (info.features.size() > 1) {
                    throw new RuntimeException("Jar can only be added if just one feature is defined in the project");
                }
                Artifact jar = new Artifact(new ArtifactId(info.project.getGroupId(), info.project.getArtifactId(), info.project.getVersion(), null, "jar"));
                if (config.getJarStartOrder() != null) {
                    jar.setStartOrder(Integer.valueOf(config.getJarStartOrder()).intValue());
                }
                (config.isTestConfig() ? info.testFeatures : info.features).values().iterator().next().getBundles().add(jar);
            }
        }
        Map<String, Feature> features = config.isTestConfig() ? info.testFeatures : info.features;
        HashMap<String, Feature> processFeatures = new HashMap<String, Feature>(features);
        Map<String, Feature> map = aggregatedFeatures = config.isTestConfig() ? info.assembledTestFeatures : info.assembledFeatures;
        while (aggregatedFeatures.size() < features.size()) {
            int start = aggregatedFeatures.size();
            Iterator iter = processFeatures.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                boolean process = false;
                if (((Feature)entry.getValue()).getPrototype() == null) {
                    process = true;
                } else {
                    ArtifactId prototype = ((Feature)entry.getValue()).getPrototype().getId();
                    if (!(prototype.getGroupId().equals(info.project.getGroupId()) && prototype.getArtifactId().equals(info.project.getArtifactId()) && prototype.getVersion().equals(info.project.getVersion()))) {
                        process = true;
                    } else {
                        for (Feature f : aggregatedFeatures.values()) {
                            if (!f.getId().equals((Object)prototype)) continue;
                            process = true;
                            break;
                        }
                    }
                }
                if (!process) continue;
                iter.remove();
                Feature assembledFeature = FeatureBuilder.assemble((Feature)((Feature)entry.getValue()), (BuilderContext)new BuilderContext(this.createFeatureProvider(env, info, config.isTestConfig(), config.isSkipAddDependencies(), config.getScope(), null)).setArtifactProvider(aid -> {
                    try {
                        return ProjectHelper.getOrResolveArtifact(info.project, env.session, env.artifactHandlerManager, env.resolver, aid).getFile().toURI().toURL();
                    }
                    catch (Exception e) {
                        env.logger.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }));
                aggregatedFeatures.put((String)entry.getKey(), assembledFeature);
                break;
            }
            if (aggregatedFeatures.size() != start) continue;
            throw new RuntimeException("Circular dependency in features in project " + info.project.getId());
        }
        if (config.isSkipAddDependencies()) {
            env.logger.debug("Not adding artifacts from features as dependencies");
        } else {
            for (Feature f : (config.isTestConfig() ? info.assembledTestFeatures : info.assembledFeatures).values()) {
                this.addDependenciesFromFeature(env, info, f, config.getScope());
            }
        }
    }

    private void scan(List<File> files, File dir, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        if (includes != null) {
            scanner.setIncludes(includes.split(","));
        }
        if (excludes != null) {
            scanner.setExcludes(excludes.split(","));
        }
        scanner.scan();
        for (String f : scanner.getIncludedFiles()) {
            files.add(new File(dir, f));
        }
    }

    private void addDependenciesFromFeature(Environment env, FeatureProjectInfo info, Feature assembledFeature, String scope) {
        for (Artifact entry : assembledFeature.getBundles()) {
            this.addDependency(env.logger, info.project, entry.getId(), scope);
        }
        for (Extension ext : assembledFeature.getExtensions()) {
            if (ext.getType() != ExtensionType.ARTIFACTS) continue;
            for (Artifact art : ext.getArtifacts()) {
                this.addDependency(env.logger, info.project, art.getId(), scope);
            }
        }
    }

    protected void readProjectFeatures(Logger logger, FeatureProjectInfo info, FeatureProjectConfig config) {
        File dir = new File(info.project.getBasedir(), config.getFeaturesDir());
        if (dir.exists()) {
            ArrayList<File> files = new ArrayList<File>();
            this.scan(files, dir, config.getIncludes(), config.getExcludes());
            for (File file : files) {
                logger.debug("Reading feature file " + file + " in project " + info.project.getId());
                StringBuilder sb = new StringBuilder();
                try (FileReader reader = new FileReader(file);){
                    char[] buf = new char[4096];
                    int l = 0;
                    while ((l = reader.read(buf)) > 0) {
                        sb.append(buf, 0, l);
                    }
                }
                catch (IOException io) {
                    throw new RuntimeException("Unable to read feature " + file.getAbsolutePath(), io);
                }
                String json = this.preprocessFeature(logger, info, config, file, sb.toString());
                try {
                    StringReader reader = new StringReader(json);
                    Throwable throwable = null;
                    try {
                        Feature feature = FeatureJSONReader.read((Reader)reader, (String)file.getAbsolutePath());
                        this.checkFeatureId(info.project, feature);
                        ProjectHelper.setFeatureInfo(info.project, feature);
                        this.postProcessReadFeature(feature);
                        (config.isTestConfig() ? info.testFeatures : info.features).put(file.toPath().normalize().toFile().getAbsolutePath(), feature);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (IOException io) {
                    throw new RuntimeException("Unable to read feature " + file.getAbsolutePath(), io);
                }
            }
        } else {
            logger.debug("Feature directory " + config.getFeaturesDir() + " does not exist in project " + info.project.getId());
        }
    }

    protected String preprocessFeature(Logger logger, FeatureProjectInfo info, FeatureProjectConfig config, File file, String readJson) {
        String json;
        block54: {
            Throwable throwable;
            try {
                throwable = null;
                try (StringWriter out = new StringWriter();
                     StringReader in2 = new StringReader(readJson);){
                    JSMin min = new JSMin((Reader)in2, (Writer)out);
                    min.jsmin();
                    json = ((Object)out).toString();
                }
                catch (Throwable in2) {
                    throwable = in2;
                    throw in2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read feature file " + file.getAbsolutePath(), e);
            }
            throwable = null;
            try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
                JsonObject obj = reader.readObject();
                if (obj.containsKey((Object)"id")) break block54;
                StringBuilder isb = new StringBuilder();
                isb.append(info.project.getGroupId());
                isb.append(':');
                isb.append(info.project.getArtifactId());
                isb.append(':');
                isb.append("slingosgifeature");
                if (config.isTestConfig() || !file.getName().equals("feature.json") || !file.getParentFile().getAbsolutePath().equals(new File(info.project.getBasedir(), config.getFeaturesDir()).getAbsolutePath())) {
                    isb.append(':');
                    int lastDot = file.getName().lastIndexOf(46);
                    isb.append(file.getName().substring(0, lastDot));
                }
                isb.append(':');
                isb.append(info.project.getVersion());
                StringWriter writer = new StringWriter();
                logger.debug("Generating id " + isb.toString() + " for feature file " + file);
                try (JsonGenerator generator = Json.createGenerator((Writer)writer);){
                    generator.writeStartObject();
                    generator.write("id", isb.toString());
                    for (Map.Entry entry : obj.entrySet()) {
                        generator.write((String)entry.getKey(), (JsonValue)entry.getValue());
                    }
                    generator.writeEnd();
                }
                json = writer.toString();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (config.isValidate()) {
            this.checkFeatureFileValidation(file, json);
        }
        return Substitution.replaceMavenVars(info.project, json);
    }

    private void checkFeatureId(MavenProject project, Feature feature) {
        if (!project.getGroupId().equals(feature.getId().getGroupId())) {
            throw new RuntimeException("Wrong group id for feature. It should be " + project.getGroupId() + " but is " + feature.getId().getGroupId());
        }
        if (!project.getArtifactId().equals(feature.getId().getArtifactId())) {
            throw new RuntimeException("Wrong artifact id for feature. It should be " + project.getArtifactId() + " but is " + feature.getId().getArtifactId());
        }
        if (!project.getVersion().equals(feature.getId().getVersion())) {
            throw new RuntimeException("Wrong version for feature. It should be " + project.getVersion() + " but is " + feature.getId().getVersion());
        }
    }

    protected Feature postProcessReadFeature(Feature result) {
        return result;
    }

    protected FeatureProvider createFeatureProvider(final Environment env, final FeatureProjectInfo info, final boolean isTest, final boolean skipAddDependencies, final String dependencyScope, List<Feature> projectFeatures) {
        final String projectKey = info.project.getGroupId() + ":" + info.project.getArtifactId();
        return new FeatureProvider(){
            private final Set<ArtifactId> processing = new HashSet<ArtifactId>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Feature provide(ArtifactId id) {
                if (this.processing.contains(id)) {
                    env.logger.error("Unable to get feature " + id.toMvnId() + " : Recursive dependency list including project " + info.project);
                    return null;
                }
                this.processing.add(id);
                try {
                    Feature feature;
                    Throwable throwable;
                    FileReader r;
                    File featureFile;
                    block31: {
                        block32: {
                            String key;
                            if (!skipAddDependencies) {
                                Preprocessor.this.addDependency(env.logger, info.project, id, dependencyScope);
                            }
                            if (projectKey.equals(key = id.getGroupId() + ":" + id.getArtifactId())) {
                                Feature found = Preprocessor.this.findFeature(info, isTest, id);
                                if (found == null) {
                                    env.logger.error("Unable to find included feature " + id.toMvnId() + " in project " + info.project);
                                    Feature feature2 = null;
                                    return feature2;
                                }
                                Feature feature3 = found;
                                return feature3;
                            }
                            FeatureProjectInfo depProjectInfo = env.modelProjects.get(key);
                            if (depProjectInfo != null) {
                                env.logger.debug("Found reactor " + id.getType() + " dependency to project: " + id);
                                FeatureProjectInfo depInfo = depProjectInfo;
                                if (isTest) {
                                    Preprocessor.this.process(env, depInfo, FeatureProjectConfig.getTestConfig(depInfo));
                                } else {
                                    Preprocessor.this.process(env, depInfo, FeatureProjectConfig.getMainConfig(depInfo));
                                }
                                Feature found = Preprocessor.this.findFeature(info, isTest, id);
                                if (isTest && found == null) {
                                    env.logger.error("Unable to get feature " + id.toMvnId() + " : Recursive test feature dependency list including project " + info.project);
                                } else if (!isTest && found == null) {
                                    env.logger.error("Unable to get feature " + id.toMvnId() + " : Recursive feature dependency list including project " + info.project);
                                }
                                Feature feature4 = found;
                                return feature4;
                            }
                            env.logger.debug("Found external " + id.getType() + " dependency: " + id);
                            featureFile = ProjectHelper.getOrResolveArtifact(info.project, env.session, env.artifactHandlerManager, env.resolver, id).getFile();
                            r = new FileReader(featureFile);
                            throwable = null;
                            feature = FeatureJSONReader.read((Reader)r, (String)featureFile.getAbsolutePath());
                            if (r == null) break block31;
                            if (throwable == null) break block32;
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block31;
                        }
                        r.close();
                    }
                    return feature;
                    catch (Throwable throwable3) {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (r != null) {
                                    if (throwable != null) {
                                        try {
                                            r.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        r.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (IOException ioe) {
                            env.logger.error("Unable to read feature file from " + featureFile, (Throwable)ioe);
                            Feature feature5 = null;
                            this.processing.remove(id);
                            return feature5;
                        }
                    }
                }
                finally {
                    this.processing.remove(id);
                }
            }
        };
    }

    private void addDependency(Logger logger, MavenProject project, ArtifactId id, String scope) {
        if (id.getGroupId().equals(project.getGroupId()) && id.getArtifactId().equals(project.getArtifactId()) && id.getVersion().equals(project.getVersion())) {
            logger.debug("- skipping dependency " + id.toMvnId());
        } else {
            boolean found = false;
            for (Dependency d : project.getDependencies()) {
                if (!d.getGroupId().equals(id.getGroupId()) || !d.getArtifactId().equals(id.getArtifactId()) || !d.getVersion().equals(id.getVersion()) || !d.getType().equals(id.getType())) continue;
                if (d.getClassifier() == null && id.getClassifier() == null) {
                    found = true;
                    break;
                }
                if (d.getClassifier() == null || !d.getClassifier().equals(id.getClassifier())) continue;
                found = true;
                break;
            }
            if (!found) {
                logger.debug("- adding dependency " + id.toMvnId());
                Dependency dep = ProjectHelper.toDependency(id, scope);
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId("*");
                exclusion.setArtifactId("*");
                dep.addExclusion(exclusion);
                project.getDependencies().add(dep);
            }
        }
    }

    private Feature findFeature(FeatureProjectInfo info, boolean isTest, ArtifactId id) {
        Feature found = this.findFeature(isTest ? info.assembledTestFeatures : info.assembledFeatures, id);
        if (found == null && isTest) {
            found = this.findFeature(info.assembledFeatures, id);
        }
        return found;
    }

    private Feature findFeature(Map<String, Feature> featureMap, ArtifactId id) {
        Feature found = null;
        if (featureMap != null) {
            for (Map.Entry<String, Feature> f : featureMap.entrySet()) {
                if (!f.getValue().getId().equals((Object)id)) continue;
                found = f.getValue();
                break;
            }
        }
        return found;
    }
}

