/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

public class Scan
extends FeatureSelectionConfig {
    private Set<String> includeTasks = new HashSet<String>();
    private Set<String> excludeTasks = new HashSet<String>();
    private Map<String, Properties> taskConfiguration = new HashMap<String, Properties>();
    private Dependency framework;

    public void setIncludeTask(String name) {
        this.includeTasks.add(name);
    }

    public void setExcludeTask(String name) {
        this.excludeTasks.add(name);
    }

    public Set<String> getIncludeTasks() {
        return this.includeTasks.isEmpty() ? null : this.includeTasks;
    }

    public Set<String> getExcludeTasks() {
        return this.excludeTasks.isEmpty() ? null : this.excludeTasks;
    }

    public Map<String, Map<String, String>> getTaskConfiguration() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Properties> entry : this.taskConfiguration.entrySet()) {
            result.put(entry.getKey(), ProjectHelper.propertiesToMap(entry.getValue()));
        }
        return result;
    }

    public void setFramework(Dependency d) {
        this.framework = d;
    }

    public Dependency getFramework() {
        return this.framework;
    }

    @Override
    public String toString() {
        return "Scan [selections=" + this.getSelections() + ", filesExcludes=" + this.getFilesExcludes() + "includeTasks=" + this.includeTasks + ", excludeTasks=" + this.excludeTasks + ", contextConfiguration=" + this.taskConfiguration + ", framework=" + ProjectHelper.toString(this.framework) + "]";
    }
}

