/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;

@Mojo(name="report", threadSafe=true)
public class ReportingMojo
extends AbstractIncludingFeatureMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectHelper.checkPreprocessorRun(this.project);
        Map<String, Feature> features = this.selectAllFeatureFiles();
        if (features.isEmpty()) {
            throw new MojoExecutionException("No features found in project!");
        }
        ArrayList<ArtifactId> bundles = new ArrayList<ArtifactId>();
        ArrayList<ArtifactId> artifacts = new ArrayList<ArtifactId>();
        for (Map.Entry<String, Feature> entry : features.entrySet()) {
            for (Artifact bundle : entry.getValue().getBundles()) {
                if (bundles.contains(bundle.getId())) continue;
                bundles.add(bundle.getId());
            }
            for (Extension ext : entry.getValue().getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS) continue;
                for (Artifact artifact : ext.getArtifacts()) {
                    if (artifacts.contains(artifact.getId())) continue;
                    artifacts.add(artifact.getId());
                }
            }
        }
        Collections.sort(bundles);
        Collections.sort(artifacts);
        this.getLog().info((CharSequence)"Bundles:");
        this.getLog().info((CharSequence)"-------------------------------------------");
        for (ArtifactId id : bundles) {
            this.getLog().info((CharSequence)id.toMvnId());
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Artifacts:");
        this.getLog().info((CharSequence)"-------------------------------------------");
        for (ArtifactId id : artifacts) {
            this.getLog().info((CharSequence)id.toMvnId());
        }
    }
}

