/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

final class JavadocExecutor {
    private static final char QUOTE_CHAR = '\"';
    private final File argFile;
    private final PrintWriter argFileWriter;

    public JavadocExecutor(File regionDir) throws MojoExecutionException {
        this.argFile = new File(regionDir, regionDir.getName() + "-javadoc");
        try {
            this.argFileWriter = new PrintWriter(this.argFile);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Impossible to create the javadoc arg file on " + this.argFile, (Exception)e);
        }
    }

    public <T> JavadocExecutor addArgument(T value) {
        return this.addArgument(value, true);
    }

    public <T> JavadocExecutor addArgument(T value, boolean newLine) {
        String stringValue = String.valueOf(value);
        if (newLine) {
            this.argFileWriter.println(stringValue);
        } else {
            this.argFileWriter.print(stringValue);
            this.argFileWriter.print(' ');
        }
        return this;
    }

    public <T> JavadocExecutor addQuotedArgument(T value) {
        return this.addArgument(StringUtils.quoteAndEscape((String)String.valueOf(value), (char)'\"'));
    }

    public <T> JavadocExecutor addArgument(T[] value, String valueSeparator) {
        return this.addArgument(StringUtils.join((Object[])value, (String)valueSeparator));
    }

    public <T> JavadocExecutor addArgument(Collection<T> value, String valueSeparator) {
        return this.addArgument(StringUtils.join(value.iterator(), (String)valueSeparator));
    }

    public <T> JavadocExecutor addArguments(Collection<T> value) {
        for (T current : value) {
            this.addArgument(current);
        }
        return this;
    }

    public <T> JavadocExecutor addArguments(String key, T[] values) {
        return this.addArguments(key, Arrays.asList(values));
    }

    public <T> JavadocExecutor addArguments(String key, Collection<T> value) {
        for (T current : value) {
            this.addArgument(key, false);
            this.addArgument(current);
        }
        return this;
    }

    public void execute(File workingDir, Log logger) throws MojoExecutionException {
        this.argFileWriter.close();
        CommandLine javadocCommand = new CommandLine(JavadocExecutor.getJavadocExecutable());
        javadocCommand.addArgument('@' + this.argFile.getAbsolutePath(), false);
        logger.info((CharSequence)("Executing javadoc tool: " + javadocCommand));
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workingDir);
        executor.setExitValues(new int[]{1, 0, -1});
        try {
            executor.getStreamHandler().setProcessInputStream((OutputStream)new LoggerOutputStream(logger));
            executor.execute(javadocCommand);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Javadoc tool cannot be invoked on that machine", (Exception)ioe);
        }
    }

    private static File getJavadocExecutable() throws MojoExecutionException {
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        File javadocExe = SystemUtils.IS_OS_AIX ? JavadocExecutor.getFile(SystemUtils.getJavaHome(), "..", "sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX && org.apache.commons.lang.SystemUtils.JAVA_VERSION_FLOAT < 1.7f ? JavadocExecutor.getFile(SystemUtils.getJavaHome(), "bin", javadocCommand) : JavadocExecutor.getFile(SystemUtils.getJavaHome(), "..", "bin", javadocCommand));
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            String javaHome = System.getenv().get("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new MojoExecutionException("The environment variable JAVA_HOME is not correctly set.");
            }
            File javaHomeDir = new File(javaHome);
            if (!javaHomeDir.exists() || javaHomeDir.isFile()) {
                throw new MojoExecutionException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javadocExe = JavadocExecutor.getFile(javaHomeDir, "bin", javadocCommand);
        }
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            throw new MojoExecutionException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javadocExe;
    }

    private static File getFile(File parent, String ... path) {
        File tmp = parent;
        for (String current : path) {
            tmp = new File(tmp, current);
        }
        return tmp;
    }

    private static final class LoggerOutputStream
    extends OutputStream {
        private final StringBuilder output = new StringBuilder();
        private final Log log;

        public LoggerOutputStream(Log log) {
            this.log = log;
        }

        @Override
        public void write(int data) throws IOException {
            this.output.append((char)data);
            if (10 == data) {
                this.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            this.log.info((CharSequence)this.output);
            this.output.setLength(0);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            super.close();
        }
    }
}

