/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;

@Mojo(name="attach-features", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachFeaturesMojo
extends AbstractFeatureMojo {
    @Parameter(name="attachTestFeatures", defaultValue="false")
    private boolean attachTestFeatures;

    private void attach(Feature feature, String classifier) throws MojoExecutionException {
        File outputFile = new File(this.getTmpDir(), classifier == null ? "feature.json" : "feature-" + classifier + ".json");
        outputFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(outputFile);){
            FeatureJSONWriter.write((Writer)writer, (Feature)feature);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write feature " + feature.getId().toMvnId() + " to " + outputFile, (Exception)e);
        }
        if (this.project.getPackaging().equals("slingosgifeature") && classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, "slingosgifeature", classifier, outputFile);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectHelper.checkPreprocessorRun(this.project);
        this.attachClassifierFeatures(ProjectHelper.getFeatures(this.project).values());
        if (this.attachTestFeatures) {
            this.attachClassifierFeatures(ProjectHelper.getTestFeatures(this.project).values());
        }
    }

    void attachClassifierFeatures(Collection<Feature> features) throws MojoExecutionException {
        for (Feature f : features) {
            this.attach(f, f.getId().getClassifier());
        }
    }
}

