/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.stream.JsonParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.apache.sling.feature.maven.mojos.JavadocExecutor;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

@Mojo(name="apis-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ApisJarMojo
extends AbstractIncludingFeatureMojo
implements ArtifactFilter {
    private static final String API_REGIONS_KEY = "api-regions";
    private static final String SCM_TAG = "scm-tag";
    private static final String SCM_LOCATION = "scm-location";
    private static final String NAME_KEY = "name";
    private static final String EXPORTS_KEY = "exports";
    private static final String APIS = "apis";
    private static final String SOURCES = "sources";
    private static final String JAVADOC = "javadoc";
    private static final String JAR_TYPE = "jar";
    private static final String JAVA_EXTENSION = ".java";
    private static final String CND_EXTENSION = ".cnd";
    private static final String NON_ASCII_PATTERN = "[^\\p{ASCII}]";
    private static final String SPACE = " ";
    @Parameter
    private FeatureSelectionConfig selection;
    @Parameter(defaultValue="${project.build.directory}/apis-jars", readonly=true)
    private File mainOutputDir;
    @Parameter
    private String[] includeResources;
    @Parameter
    private Set<String> excludeRegions;
    @Parameter
    private String[] javadocLinks;
    @Component(hint="default")
    private ModelBuilder modelBuilder;
    @Component
    private ScmManager scmManager;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private RepositorySystem repositorySystem;
    private ArtifactProvider artifactProvider;
    private final Pattern pomPropertiesPattern = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectHelper.checkPreprocessorRun(this.project);
        this.artifactProvider = new ArtifactProvider(){

            public File provide(ArtifactId id) {
                return ProjectHelper.getOrResolveArtifact(ApisJarMojo.this.project, ApisJarMojo.this.mavenSession, ApisJarMojo.this.artifactHandlerManager, ApisJarMojo.this.artifactResolver, id).getFile();
            }
        };
        this.getLog().debug((CharSequence)"Retrieving Feature files...");
        Collection<Feature> features = this.getSelectedFeatures(this.selection).values();
        if (features.isEmpty()) {
            this.getLog().debug((CharSequence)"There are no assciated Feature files to current project, plugin execution will be interrupted");
            return;
        }
        this.getLog().debug((CharSequence)"Starting APIs JARs creation...");
        for (Feature feature : features) {
            this.onFeature(feature);
        }
    }

    private void onFeature(Feature feature) throws MojoExecutionException {
        this.getLog().debug((CharSequence)MessageUtils.buffer().a((CharSequence)"Creating APIs JARs for Feature ").strong((Object)feature.getId().toMvnId()).a((CharSequence)" ...").toString());
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName(API_REGIONS_KEY);
        if (apiRegionsExtension == null) {
            this.getLog().debug((CharSequence)("Feature file " + feature.getId().toMvnId() + " does not declare '" + API_REGIONS_KEY + "' extension, no API JAR will be created"));
            return;
        }
        String jsonRepresentation = apiRegionsExtension.getJSON();
        if (jsonRepresentation == null || jsonRepresentation.isEmpty()) {
            this.getLog().debug((CharSequence)("Feature file " + feature.getId().toMvnId() + " declares an empty '" + API_REGIONS_KEY + "' extension, no API JAR will be created"));
            return;
        }
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        File featureDir = new File(this.mainOutputDir, feature.getId().getArtifactId());
        File deflatedBinDir = ApisJarMojo.newDir(featureDir, "deflated-bin");
        File deflatedSourcesDir = ApisJarMojo.newDir(featureDir, "deflated-sources");
        File checkedOutSourcesDir = ApisJarMojo.newDir(featureDir, "checkouts");
        List<ApiRegion> apiRegions = ApisJarMojo.fromJson(feature, jsonRepresentation);
        HashSet<String> javadocClasspath = new HashSet<String>();
        for (Artifact artifact : feature.getBundles()) {
            this.onArtifact(artifact, apiRegions, javadocClasspath, deflatedBinDir, deflatedSourcesDir, checkedOutSourcesDir);
        }
        for (ApiRegion apiRegion : apiRegions) {
            if (this.excludeRegions != null && !this.excludeRegions.isEmpty() && this.excludeRegions.contains(apiRegion.getName())) {
                this.getLog().debug((CharSequence)("API Region " + apiRegion.getName() + " will not processed since it is in the exclude list"));
                continue;
            }
            File regionDir = new File(featureDir, apiRegion.getName());
            File apisDir = new File(regionDir, APIS);
            List<String> nodeTypes = this.recollect(featureDir, deflatedBinDir, apiRegion, apisDir);
            this.inflate(feature.getId(), apisDir, apiRegion, APIS, nodeTypes);
            File sourcesDir = new File(regionDir, SOURCES);
            this.recollect(featureDir, deflatedSourcesDir, apiRegion, sourcesDir);
            this.inflate(feature.getId(), sourcesDir, apiRegion, SOURCES, null);
            File javadocsDir = new File(regionDir, JAVADOC);
            this.generateJavadoc(apiRegion, sourcesDir, javadocsDir, javadocClasspath);
            this.inflate(feature.getId(), javadocsDir, apiRegion, JAVADOC, null);
        }
        this.getLog().debug((CharSequence)MessageUtils.buffer().a((CharSequence)"APIs JARs for Feature ").debug((Object)feature.getId().toMvnId()).a((CharSequence)" succesfully created").toString());
    }

    private void onArtifact(Artifact artifact, List<ApiRegion> apiRegions, Set<String> javadocClasspath, File deflatedBinDir, File deflatedSourcesDir, File checkedOutSourcesDir) throws MojoExecutionException {
        ArtifactId artifactId = artifact.getId();
        File bundle = this.retrieve(artifactId);
        File deflatedBundleDirectory = this.deflate(deflatedBinDir, bundle);
        this.computeWrappedBundles(deflatedBundleDirectory, apiRegions, javadocClasspath, deflatedBinDir, deflatedSourcesDir, checkedOutSourcesDir);
        this.renameResources(deflatedBundleDirectory, artifactId);
        this.computeExportPackage(apiRegions, deflatedBundleDirectory, artifactId);
        this.downloadSources(artifact, deflatedSourcesDir, checkedOutSourcesDir);
        this.buildJavadocClasspath(javadocClasspath, artifactId);
    }

    private void computeWrappedBundles(File deflatedBundleDirectory, List<ApiRegion> apiRegions, Set<String> javadocClasspath, File deflatedBinDir, File deflatedSourcesDir, File checkedOutSourcesDir) throws MojoExecutionException {
        String bundleClassPath;
        File manifestFile = new File(deflatedBundleDirectory, "META-INF/MANIFEST.MF");
        this.getLog().debug((CharSequence)("Reading Manifest headers from file " + manifestFile));
        if (!manifestFile.exists()) {
            throw new MojoExecutionException("Manifest file " + manifestFile + " does not exist, make sure " + deflatedBundleDirectory + " contains the valid META-INF/MANIFEST.MF file");
        }
        try (FileInputStream input = new FileInputStream(manifestFile);){
            Manifest manifest = new Manifest(input);
            bundleClassPath = manifest.getMainAttributes().getValue("Bundle-ClassPath");
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while reading " + manifestFile + " file", (Exception)e);
        }
        if (bundleClassPath == null || bundleClassPath.isEmpty()) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(bundleClassPath, ",");
        while (tokenizer.hasMoreTokens()) {
            String bundleName = tokenizer.nextToken();
            if (".".equals(bundleName)) continue;
            File wrappedJar = new File(deflatedBundleDirectory, bundleName);
            this.getLog().info((CharSequence)("Processing wrapped bundle " + wrappedJar));
            Properties properties = new Properties();
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(wrappedJar);
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    if (jarEntry.isDirectory() || !this.pomPropertiesPattern.matcher(jarEntry.getName()).matches()) continue;
                    this.getLog().info((CharSequence)("Loading Maven GAV from " + wrappedJar + '!' + jarEntry.getName()));
                    properties.load(jarFile.getInputStream(jarEntry));
                }
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("An error occurred while processing wrapped bundle " + wrappedJar, (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(jarFile);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)jarFile);
            if (properties.isEmpty()) {
                this.getLog().info((CharSequence)("No Maven GAV info attached to wrapped bundle " + wrappedJar + ", it will be ignored"));
                return;
            }
            this.getLog().info((CharSequence)("Handling synthetic artifacts from Maven GAV: " + properties));
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            Artifact syntheticArtifact = new Artifact(new ArtifactId(groupId, artifactId, version, null, null));
            this.onArtifact(syntheticArtifact, apiRegions, javadocClasspath, deflatedBinDir, deflatedSourcesDir, checkedOutSourcesDir);
        }
    }

    private void buildJavadocClasspath(Set<String> javadocClasspath, ArtifactId artifactId) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Retrieving " + artifactId + " and related dependencies..."));
        org.apache.maven.artifact.Artifact toBeResolvedArtifact = this.repositorySystem.createArtifactWithClassifier(artifactId.getGroupId(), artifactId.getArtifactId(), artifactId.getVersion(), artifactId.getType(), artifactId.getClassifier());
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(toBeResolvedArtifact).setServers(this.mavenSession.getRequest().getServers()).setMirrors(this.mavenSession.getRequest().getMirrors()).setProxies(this.mavenSession.getRequest().getProxies()).setLocalRepository(this.mavenSession.getLocalRepository()).setRemoteRepositories(this.mavenSession.getRequest().getRemoteRepositories()).setForceUpdate(false).setResolveRoot(true).setResolveTransitively(true).setCollectionFilter((ArtifactFilter)this);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        if (!result.isSuccess()) {
            if (result.hasCircularDependencyExceptions()) {
                this.getLog().warn((CharSequence)"Cyclic dependency errors detected:");
                this.reportWarningMessages(result.getCircularDependencyExceptions());
            }
            if (result.hasErrorArtifactExceptions()) {
                this.getLog().warn((CharSequence)"Resolution errors detected:");
                this.reportWarningMessages(result.getErrorArtifactExceptions());
            }
            if (result.hasMetadataResolutionExceptions()) {
                this.getLog().warn((CharSequence)"Metadata resolution errors detected:");
                this.reportWarningMessages(result.getMetadataResolutionExceptions());
            }
            if (result.hasMissingArtifacts()) {
                this.getLog().warn((CharSequence)"Missing artifacts detected:");
                for (org.apache.maven.artifact.Artifact missingArtifact : result.getMissingArtifacts()) {
                    this.getLog().warn((CharSequence)(" - " + missingArtifact.getId()));
                }
            }
            if (result.hasExceptions()) {
                this.getLog().warn((CharSequence)"Generic errors detected:");
                for (Exception exception : result.getExceptions()) {
                    this.getLog().warn((CharSequence)(" - " + exception.getMessage()));
                }
            }
        }
        for (org.apache.maven.artifact.Artifact resolvedArtifact : result.getArtifacts()) {
            javadocClasspath.add(resolvedArtifact.getFile().getAbsolutePath());
        }
    }

    private <E extends ArtifactResolutionException> void reportWarningMessages(Collection<E> exceptions) {
        for (ArtifactResolutionException exception : exceptions) {
            this.getLog().warn((CharSequence)(" - " + exception.getMessage() + " (" + exception.getArtifact().getId() + ")"));
        }
    }

    private File retrieve(ArtifactId artifactId) {
        this.getLog().debug((CharSequence)("Retrieving artifact " + artifactId + "..."));
        File sourceFile = this.artifactProvider.provide(artifactId);
        this.getLog().debug((CharSequence)("Artifact " + artifactId + " successfully retrieved"));
        return sourceFile;
    }

    private File deflate(File deflatedDir, File artifact) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Deflating bundle " + artifact + "..."));
        File destDirectory = new File(deflatedDir, artifact.getName());
        destDirectory.mkdirs();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact);
            unArchiver.setSourceFile(artifact);
            unArchiver.setDestDirectory(destDirectory);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("An error occurred while deflating file " + artifact + " to directory " + destDirectory, (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)("Bundle " + artifact + " successfully deflated"));
        return destDirectory;
    }

    private void renameResources(File destDirectory, ArtifactId artifactId) throws MojoExecutionException {
        if (this.includeResources == null || this.includeResources.length == 0) {
            this.getLog().debug((CharSequence)("No configured resources to rename in " + destDirectory));
        }
        this.getLog().debug((CharSequence)("Renaming " + Arrays.toString((Object[])this.includeResources) + " files in " + destDirectory + "..."));
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(destDirectory);
        directoryScanner.setIncludes(this.includeResources);
        directoryScanner.scan();
        if (directoryScanner.getIncludedFiles().length == 0) {
            this.getLog().debug((CharSequence)("No " + Arrays.toString((Object[])this.includeResources) + " resources in " + destDirectory + " to be renamed renamed."));
            return;
        }
        for (String resourceName : directoryScanner.getIncludedFiles()) {
            File resource = new File(destDirectory, resourceName);
            File renamed = new File(resource.getParentFile(), artifactId.getGroupId() + "-" + artifactId.getArtifactId() + "-" + resource.getName());
            this.getLog().debug((CharSequence)("Renaming resource " + resource + " to " + renamed + "..."));
            if (resource.renameTo(renamed)) {
                this.getLog().debug((CharSequence)("Resource renamed to " + renamed));
                continue;
            }
            this.getLog().warn((CharSequence)("Impossible to rename resource " + resource + " to " + renamed + ", please check the current user has enough rights on the File System"));
        }
        this.getLog().debug((CharSequence)(Arrays.toString((Object[])this.includeResources) + " resources in " + destDirectory + " successfully renamed"));
    }

    private void downloadSources(Artifact artifact, File deflatedSourcesDir, File checkedOutSourcesDir) throws MojoExecutionException {
        ArtifactId artifactId = artifact.getId();
        ArtifactId sourcesArtifactId = ApisJarMojo.newArtifacId(artifactId, SOURCES, JAR_TYPE);
        try {
            File sourcesBundle = this.retrieve(sourcesArtifactId);
            this.deflate(deflatedSourcesDir, sourcesBundle);
        }
        catch (Throwable t) {
            this.getLog().warn((CharSequence)("Impossible to download -sources bundle " + sourcesArtifactId + " due to " + t.getMessage() + ", following back to source checkout..."));
            String connection = (String)artifact.getMetadata().get(SCM_LOCATION);
            String tag = (String)artifact.getMetadata().get(SCM_TAG);
            ArtifactId pomArtifactId = ApisJarMojo.newArtifacId(artifactId, null, "pom");
            this.getLog().debug((CharSequence)("Falling back to SCM checkout, retrieving POM " + pomArtifactId + "..."));
            File pomFile = this.retrieve(pomArtifactId);
            this.getLog().debug((CharSequence)("POM " + pomArtifactId + " successfully retrieved, reading the model..."));
            Model pomModel = (Model)this.modelBuilder.buildRawModel(pomFile, 0, false).get();
            this.getLog().debug((CharSequence)("POM model " + pomArtifactId + " successfully read, processing the SCM..."));
            Scm scm = pomModel.getScm();
            if (scm != null) {
                connection = ApisJarMojo.setIfNull(connection, scm.getConnection());
                tag = ApisJarMojo.setIfNull(tag, scm.getTag());
            }
            if (connection == null) {
                this.getLog().warn((CharSequence)("SCM not defined in " + artifactId + " bundle neither in " + pomModel + " POM file, sources can not be retrieved, then will be ignored"));
                return;
            }
            try {
                File javaSources;
                ScmRepository repository = this.scmManager.makeScmRepository(connection);
                ScmTag scmVersion = null;
                if (tag != null) {
                    scmVersion = new ScmTag(tag);
                }
                File basedir = ApisJarMojo.newDir(checkedOutSourcesDir, artifactId.getArtifactId());
                ScmFileSet fileSet = new ScmFileSet(basedir);
                CheckOutScmResult result = null;
                try {
                    result = scmVersion != null ? this.scmManager.checkOut(repository, fileSet, true) : this.scmManager.checkOut(repository, fileSet, (ScmVersion)scmVersion, true);
                }
                catch (ScmException se) {
                    throw new MojoExecutionException("An error occurred while checking sources from " + repository + " for artifact " + artifactId + " model", (Exception)((Object)se));
                }
                if (!result.isSuccess()) {
                    this.getLog().error((CharSequence)("An error occurred while checking out sources from " + connection + ": " + result.getProviderMessage() + "\nSources may be missing from collecting public APIs."));
                    return;
                }
                DirectoryScanner pomScanner = new DirectoryScanner();
                pomScanner.setBasedir(basedir);
                pomScanner.setIncludes(new String[]{"**/pom.xml"});
                pomScanner.scan();
                for (String pomFileLocation : pomScanner.getIncludedFiles()) {
                    pomFile = new File(basedir, pomFileLocation);
                    pomModel = (Model)this.modelBuilder.buildRawModel(pomFile, 0, false).get();
                    if (!artifactId.getArtifactId().equals(pomModel.getArtifactId())) continue;
                    basedir = pomFile.getParentFile();
                    break;
                }
                if (!(javaSources = new File(basedir, "src/main/java")).exists() && !(javaSources = new File(basedir, "src/java")).exists()) {
                    this.getLog().debug((CharSequence)(artifactId + " does not contain any source, will be ignored"));
                    return;
                }
                File destDirectory = ApisJarMojo.newDir(deflatedSourcesDir, artifactId.toMvnId());
                DirectoryScanner directoryScanner = new DirectoryScanner();
                directoryScanner.setBasedir(javaSources);
                directoryScanner.setIncludes(new String[]{"*"});
                directoryScanner.scan();
                for (String file : directoryScanner.getIncludedFiles()) {
                    File source = new File(javaSources, file);
                    File destination = new File(destDirectory, file);
                    destination.getParentFile().mkdirs();
                    try {
                        FileUtils.copyFile((File)source, (File)destination);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("An error occurred while copying sources from " + source + " to " + destination, (Exception)e);
                    }
                }
            }
            catch (ScmRepositoryException se) {
                throw new MojoExecutionException("An error occurred while reading SCM from " + connection + " connection for bundle " + artifactId, (Exception)((Object)se));
            }
            catch (NoSuchScmProviderException nsspe) {
                this.getLog().error((CharSequence)(artifactId + " bundle points to an SCM connection " + connection + " which does not specify a valid or supported SCM provider"), (Throwable)nsspe);
            }
        }
    }

    private void computeExportPackage(List<ApiRegion> apiRegions, File destDirectory, ArtifactId artifactId) throws MojoExecutionException {
        File manifestFile = new File(destDirectory, "META-INF/MANIFEST.MF");
        this.getLog().debug((CharSequence)("Reading Manifest headers from file " + manifestFile));
        if (!manifestFile.exists()) {
            throw new MojoExecutionException("Manifest file " + manifestFile + " does not exist, make sure " + destDirectory + " contains the valid deflated " + artifactId + " bundle");
        }
        try (FileInputStream input = new FileInputStream(manifestFile);){
            Clause[] exportPackages;
            Manifest manifest = new Manifest(input);
            String exportPackageHeader = manifest.getMainAttributes().getValue("Export-Package");
            for (Clause exportPackage : exportPackages = Parser.parseHeader((String)exportPackageHeader)) {
                String api = exportPackage.getName();
                for (ApiRegion apiRegion : apiRegions) {
                    if (!apiRegion.containsApi(api)) continue;
                    apiRegion.addExportPackage(exportPackage);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while reading " + manifestFile + " file", (Exception)e);
        }
    }

    private List<String> recollect(File featureDir, File deflatedDir, ApiRegion apiRegion, File destination) throws MojoExecutionException {
        LinkedList<String> nodeTypes = new LinkedList<String>();
        destination.mkdirs();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(deflatedDir);
        String[] includes = APIS.equals(destination.getName()) ? ApisJarMojo.concatenate(apiRegion.getFilteringApis(), this.includeResources) : apiRegion.getFilteringApis();
        directoryScanner.setIncludes(includes);
        directoryScanner.scan();
        for (String includedFile : directoryScanner.getIncludedFiles()) {
            String fileName = includedFile.substring(includedFile.indexOf(File.separator) + 1);
            File target = new File(destination, fileName);
            target.getParentFile().mkdirs();
            try {
                File source = new File(deflatedDir, includedFile);
                if (includedFile.endsWith(JAVA_EXTENSION)) {
                    String javaSource = FileUtils.fileRead((File)source, (String)StandardCharsets.UTF_8.name()).replaceAll(NON_ASCII_PATTERN, SPACE);
                    FileUtils.fileWrite((File)target, (String)StandardCharsets.UTF_8.name(), (String)javaSource);
                    continue;
                }
                if (includedFile.endsWith(CND_EXTENSION)) {
                    nodeTypes.add(fileName);
                }
                FileUtils.copyFile((File)source, (File)target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while copying file " + includedFile + " to " + destination, (Exception)e);
            }
        }
        return nodeTypes;
    }

    private void inflate(ArtifactId featureId, File collectedDir, ApiRegion apiRegion, String classifier, List<String> nodeTypes) throws MojoExecutionException {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(collectedDir);
        directoryScanner.setIncludes(new String[]{"**/*.*"});
        directoryScanner.scan();
        JarArchiver jarArchiver = new JarArchiver();
        for (String includedFile : directoryScanner.getIncludedFiles()) {
            jarArchiver.addFile(new File(collectedDir, includedFile), includedFile);
        }
        StringBuilder classifierBuilder = new StringBuilder();
        if (featureId.getClassifier() != null) {
            classifierBuilder.append(featureId.getClassifier()).append('-');
        }
        String finalClassifier = classifierBuilder.append(apiRegion.getName()).append('-').append(classifier).toString();
        String bundleName = String.format("%s-%s", this.project.getArtifactId(), finalClassifier);
        String symbolicName = bundleName.replace('-', '.');
        MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();
        if (APIS.equals(classifier)) {
            archiveConfiguration.addManifestEntry("Export-Package", StringUtils.join(apiRegion.getExportPackage(), (String)","));
            archiveConfiguration.addManifestEntry("Bundle-Description", this.project.getDescription());
            archiveConfiguration.addManifestEntry("Bundle-Version", featureId.getOSGiVersion().toString());
            archiveConfiguration.addManifestEntry("Bundle-ManifestVersion", "2");
            archiveConfiguration.addManifestEntry("Bundle-SymbolicName", symbolicName);
            archiveConfiguration.addManifestEntry("Bundle-Name", bundleName);
            if (nodeTypes != null && !nodeTypes.isEmpty()) {
                archiveConfiguration.addManifestEntry("Sling-Nodetypes", StringUtils.join(nodeTypes.iterator(), (String)","));
            }
        }
        if (this.project.getOrganization() != null) {
            archiveConfiguration.addManifestEntry("Bundle-Vendor", this.project.getOrganization().getName());
        }
        archiveConfiguration.addManifestEntry("Specification-Version", featureId.getVersion());
        archiveConfiguration.addManifestEntry("Implementation-Title", bundleName);
        String targetName = String.format("%s-%s-%s.jar", this.project.getArtifactId(), this.project.getVersion(), finalClassifier);
        File target = new File(this.mainOutputDir, targetName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(jarArchiver);
        archiver.setOutputFile(target);
        try {
            archiver.createArchive(this.mavenSession, this.project, archiveConfiguration);
            this.projectHelper.attachArtifact(this.project, JAR_TYPE, finalClassifier, target);
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error occurred while creating APIs " + target + " archive", e);
        }
    }

    private void generateJavadoc(ApiRegion apiRegion, File sourcesDir, File javadocDir, Set<String> javadocClasspath) throws MojoExecutionException {
        javadocDir.mkdirs();
        JavadocExecutor javadocExecutor = new JavadocExecutor(javadocDir.getParentFile()).addArgument("-public").addArgument("-d", false).addArgument(javadocDir.getAbsolutePath()).addArgument("-sourcepath", false).addArgument(sourcesDir.getAbsolutePath());
        if (ApisJarMojo.isNotEmpty(this.project.getName())) {
            javadocExecutor.addArgument("-doctitle", false).addQuotedArgument(this.project.getName());
        }
        if (ApisJarMojo.isNotEmpty(this.project.getDescription())) {
            javadocExecutor.addArgument("-windowtitle", false).addQuotedArgument(this.project.getDescription());
        }
        if (ApisJarMojo.isNotEmpty(this.project.getInceptionYear()) && this.project.getOrganization() != null && ApisJarMojo.isNotEmpty(this.project.getOrganization().getName())) {
            javadocExecutor.addArgument("-bottom", false).addQuotedArgument(String.format("Copyright &copy; %s - %s %s. All Rights Reserved", this.project.getInceptionYear(), Calendar.getInstance().get(1), this.project.getOrganization().getName()));
        }
        if (this.javadocLinks != null && this.javadocLinks.length > 0) {
            javadocExecutor.addArguments("-link", this.javadocLinks);
        }
        if (!javadocClasspath.isEmpty()) {
            javadocExecutor.addArgument("-classpath", false).addArgument(javadocClasspath, File.pathSeparator);
        }
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
            javadocExecutor.addArgument("-Xdoclint:none");
        }
        javadocExecutor.addArgument("--allow-script-in-comments").addArgument("-subpackages", false).addArgument(sourcesDir.list(), File.pathSeparator).execute(javadocDir, this.getLog());
    }

    private static ArtifactId newArtifacId(ArtifactId original, String classifier, String type) {
        return new ArtifactId(original.getGroupId(), original.getArtifactId(), original.getVersion(), classifier, type);
    }

    private static List<ApiRegion> fromJson(Feature feature, String jsonRepresentation) throws MojoExecutionException {
        JsonParser.Event event;
        ArrayList<ApiRegion> apiRegions = new ArrayList<ApiRegion>();
        JsonParser parser = Json.createParser((Reader)new StringReader(jsonRepresentation));
        if (JsonParser.Event.START_ARRAY != parser.next()) {
            throw new MojoExecutionException("Expected 'api-region' element to start with an Array in Feature " + feature.getId().toMvnId() + ": " + parser.getLocation());
        }
        while (JsonParser.Event.END_ARRAY != (event = parser.next())) {
            if (JsonParser.Event.START_OBJECT != event) {
                throw new MojoExecutionException("Expected 'api-region' data to start with an Object in Feature " + feature.getId().toMvnId() + ": " + parser.getLocation());
            }
            ApiRegion apiRegion = new ApiRegion();
            while (JsonParser.Event.END_OBJECT != (event = parser.next())) {
                if (JsonParser.Event.KEY_NAME != event) continue;
                switch (parser.getString()) {
                    case "name": {
                        parser.next();
                        apiRegion.setName(parser.getString());
                        break;
                    }
                    case "exports": {
                        parser.next();
                        while (parser.hasNext() && JsonParser.Event.VALUE_STRING == parser.next()) {
                            String api = parser.getString();
                            if ('#' == api.charAt(0)) continue;
                            apiRegion.addApi(api);
                        }
                        break;
                    }
                }
            }
            if (apiRegions.size() > 0) {
                apiRegion.doInherit((ApiRegion)apiRegions.get(apiRegions.size() - 1));
            }
            apiRegions.add(apiRegion);
        }
        return apiRegions;
    }

    private static String[] concatenate(String[] a, String[] b) {
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private static File newDir(File parent, String child) {
        File dir = new File(parent, child);
        dir.mkdirs();
        return dir;
    }

    private static <T> T setIfNull(T what, T with) {
        if (what == null) {
            return with;
        }
        return what;
    }

    private static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public boolean include(org.apache.maven.artifact.Artifact artifact) {
        return !"test".equals(artifact.getScope());
    }

    private static final class ApiRegion {
        private static final Pattern PACKAGE_NAME_VALIDATION = Pattern.compile("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");
        private static final Set<String> KEYWORDS = new HashSet<String>();
        private final Set<String> apis = new TreeSet<String>();
        private final Set<String> filteringApis = new TreeSet<String>();
        private final List<Clause> exportPackage = new ArrayList<Clause>();
        private String name;
        private String inherits;

        private ApiRegion() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getFilteringApis() {
            return this.filteringApis.toArray(new String[this.filteringApis.size()]);
        }

        public void addApi(String api) {
            if (!PACKAGE_NAME_VALIDATION.matcher(api).matches()) {
                return;
            }
            for (String apiPart : api.split("\\.")) {
                if (!KEYWORDS.contains(apiPart)) continue;
                return;
            }
            this.apis.add(api);
            this.filteringApis.add("**/" + api.replace('.', '/') + "/*");
        }

        public boolean containsApi(String api) {
            return this.apis.contains(api);
        }

        public void addExportPackage(Clause exportPackage) {
            this.exportPackage.add(exportPackage);
        }

        public Iterator<Clause> getExportPackage() {
            return this.exportPackage.iterator();
        }

        public void doInherit(ApiRegion parent) {
            this.inherits = parent.getName();
            this.apis.addAll(parent.apis);
            this.filteringApis.addAll(parent.filteringApis);
        }

        public String toString() {
            Formatter formatter = new Formatter();
            formatter.format("Region '%s'", this.name);
            if (this.inherits != null && !this.inherits.isEmpty()) {
                formatter.format(" inherits from '%s'", this.inherits);
            }
            formatter.format(":%n", new Object[0]);
            for (String api : this.apis) {
                formatter.format(" * %s%n", api);
            }
            String toString = formatter.toString();
            formatter.close();
            return toString;
        }

        static {
            KEYWORDS.add("abstract");
            KEYWORDS.add("continue");
            KEYWORDS.add("for");
            KEYWORDS.add("new");
            KEYWORDS.add("switch");
            KEYWORDS.add("assert");
            KEYWORDS.add("default");
            KEYWORDS.add("package");
            KEYWORDS.add("synchronized");
            KEYWORDS.add("boolean");
            KEYWORDS.add("do");
            KEYWORDS.add("if");
            KEYWORDS.add("private");
            KEYWORDS.add("this");
            KEYWORDS.add("break");
            KEYWORDS.add("double");
            KEYWORDS.add("implements");
            KEYWORDS.add("protected");
            KEYWORDS.add("throw");
            KEYWORDS.add("byte");
            KEYWORDS.add("else");
            KEYWORDS.add("import");
            KEYWORDS.add("public");
            KEYWORDS.add("throws");
            KEYWORDS.add("case");
            KEYWORDS.add("enum");
            KEYWORDS.add("instanceof");
            KEYWORDS.add("return");
            KEYWORDS.add("transient");
            KEYWORDS.add("catch");
            KEYWORDS.add("extends");
            KEYWORDS.add("int");
            KEYWORDS.add("short");
            KEYWORDS.add("try");
            KEYWORDS.add("char");
            KEYWORDS.add("final");
            KEYWORDS.add("interface");
            KEYWORDS.add("static");
            KEYWORDS.add("void");
            KEYWORDS.add("class");
            KEYWORDS.add("finally");
            KEYWORDS.add("long");
            KEYWORDS.add("strictfp");
            KEYWORDS.add("volatile");
            KEYWORDS.add("float");
            KEYWORDS.add("native");
            KEYWORDS.add("super");
            KEYWORDS.add("while");
        }
    }
}

