/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractFsMountMojo;
import org.apache.sling.maven.bundlesupport.BundlePrerequisite;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.apache.sling.maven.bundlesupport.deploy.BundleDeploymentMethod;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.fsresource.FileVaultXmlMounter;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="fsmount", requiresProject=true)
public class FsMountMojo
extends AbstractFsMountMojo {
    private static final String BUNDLE_GROUP_ID = "org.apache.sling";
    private static final String FS_BUNDLE_ARTIFACT_ID = "org.apache.sling.fsresource";
    private static final String FS_BUNDLE_DEFAULT_VERSION = "2.1.16";
    private static final String FS_BUNDLE_LEGACY_DEFAULT_VERSION = "1.4.8";
    private static final String RESOURCE_RESOLVER_BUNDLE_ARTIFACT_ID = "org.apache.sling.resourceresolver";
    private static final String RESOURCE_RESOLVER_BUNDLE_MIN_VERSION = "1.5.18";
    private static final String JOHNZON_BUNDLE_ARTIFACT_ID = "org.apache.sling.commons.johnzon";
    private static final String JOHNZON_BUNDLE_MIN_VERSION = "1.0.0";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_GROUP_ID = "org.apache.commons";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_ARTIFACT_ID = "commons-collections4";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_MIN_VERSION = "4.1";
    private static final String COMMONS_COLLECTIONS4_BUNDLE_SYMBOLICNAME = "org.apache.commons.collections4";
    @Parameter(property="sling.deploy.method", required=false, defaultValue="WebConsole")
    private BundleDeploymentMethod deploymentMethod;
    @Parameter(required=false, defaultValue="true")
    private boolean deployFsResourceBundle;
    @Parameter(required=false)
    private List<BundlePrerequisite> deployFsResourceBundlePrerequisites;

    public void addDeployFsResourceBundlePrerequisite(BundlePrerequisite item) {
        if (this.deployFsResourceBundlePrerequisites == null) {
            this.deployFsResourceBundlePrerequisites = new ArrayList<BundlePrerequisite>();
        }
        this.deployFsResourceBundlePrerequisites.add(item);
    }

    @Override
    protected void configureSlingInitialContent(CloseableHttpClient httpClient, URI consoleTargetUrl, File bundleFile) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), this.getHttpClient(), this.getRequestConfigBuilder(), this.project).mount(consoleTargetUrl, bundleFile);
    }

    @Override
    protected void configureFileVaultXml(CloseableHttpClient httpClient, URI consoleTargetUrl, File jcrRootFile, File filterXmlFile) throws MojoExecutionException {
        new FileVaultXmlMounter(this.getLog(), httpClient, this.getRequestConfigBuilder(), this.project).mount(consoleTargetUrl, jcrRootFile, filterXmlFile);
    }

    @Override
    protected void ensureBundlesInstalled(CloseableHttpClient httpClient, URI consoleTargetUrl) throws MojoExecutionException {
        Iterator<BundlePrerequisite> iterator;
        if (!this.deployFsResourceBundle) {
            return;
        }
        if (this.deployFsResourceBundlePrerequisites == null) {
            BundlePrerequisite latest = new BundlePrerequisite();
            latest.addBundle(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, JOHNZON_BUNDLE_ARTIFACT_ID, JOHNZON_BUNDLE_MIN_VERSION));
            latest.addBundle(new BundlePrerequisite.Bundle(COMMONS_COLLECTIONS4_BUNDLE_GROUP_ID, COMMONS_COLLECTIONS4_BUNDLE_ARTIFACT_ID, COMMONS_COLLECTIONS4_BUNDLE_MIN_VERSION, COMMONS_COLLECTIONS4_BUNDLE_SYMBOLICNAME));
            latest.addBundle(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, FS_BUNDLE_ARTIFACT_ID, FS_BUNDLE_DEFAULT_VERSION));
            latest.addPrecondition(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, RESOURCE_RESOLVER_BUNDLE_ARTIFACT_ID, RESOURCE_RESOLVER_BUNDLE_MIN_VERSION));
            this.addDeployFsResourceBundlePrerequisite(latest);
            BundlePrerequisite legacy = new BundlePrerequisite();
            legacy.addBundle(new BundlePrerequisite.Bundle(BUNDLE_GROUP_ID, FS_BUNDLE_ARTIFACT_ID, FS_BUNDLE_LEGACY_DEFAULT_VERSION));
            this.addDeployFsResourceBundlePrerequisite(legacy);
        }
        if ((iterator = this.deployFsResourceBundlePrerequisites.iterator()).hasNext()) {
            BundlePrerequisite bundlePrerequisite = iterator.next();
            if (this.isBundlePrerequisitesPreconditionsMet(httpClient, bundlePrerequisite, consoleTargetUrl)) {
                for (BundlePrerequisite.Bundle bundle : bundlePrerequisite.getBundles()) {
                    this.deployBundle(httpClient, bundle, consoleTargetUrl);
                }
            } else {
                throw new MojoExecutionException("Target server does not meet prerequisites for this goal. Haven't found the necessary bundles: " + bundlePrerequisite.getPreconditions().stream().map(BundlePrerequisite.Bundle::toString).collect(Collectors.joining(", ")));
            }
        }
    }

    private void deployBundle(CloseableHttpClient httpClient, BundlePrerequisite.Bundle bundle, URI consoleTargetUrl) throws MojoExecutionException {
        try {
            if (this.isBundleInstalled(httpClient, bundle, consoleTargetUrl)) {
                this.getLog().debug((CharSequence)("Bundle " + bundle.getSymbolicName() + " " + bundle.getOsgiVersion() + " (or higher) already installed."));
                return;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting installation status of " + bundle + " via " + consoleTargetUrl + ": " + e.getMessage(), (Exception)e);
        }
        try {
            this.getLog().info((CharSequence)("Installing Bundle " + bundle.getSymbolicName() + " " + bundle.getOsgiVersion() + " to " + consoleTargetUrl + " via " + (Object)((Object)this.deploymentMethod)));
            File file = this.getArtifactFile(bundle, "jar");
            this.deploymentMethod.execute().deploy(this.getTargetURL(), file, bundle.getSymbolicName(), new DeployContext().log(this.getLog()).httpClient(httpClient).failOnError(this.failOnError));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error deploying bundle " + bundle + " to " + this.getTargetURL() + ": " + e.getMessage(), (Exception)e);
        }
    }

    private boolean isBundlePrerequisitesPreconditionsMet(CloseableHttpClient httpClient, BundlePrerequisite bundlePrerequisite, URI targetUrl) throws MojoExecutionException {
        for (BundlePrerequisite.Bundle precondition : bundlePrerequisite.getPreconditions()) {
            try {
                if (this.isBundleInstalled(httpClient, precondition, targetUrl)) continue;
                this.getLog().debug((CharSequence)("Bundle " + precondition.getSymbolicName() + " " + precondition.getOsgiVersion() + " (or higher) is not installed."));
                return false;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Reading bundle data for bundle " + precondition + " failed, cause: " + e.getMessage(), (Exception)e);
            }
        }
        return true;
    }

    private boolean isBundleInstalled(CloseableHttpClient httpClient, BundlePrerequisite.Bundle bundle, URI consoleTargetUrl) throws IOException {
        String installedVersionString = this.getBundleInstalledVersion(httpClient, bundle.getSymbolicName(), consoleTargetUrl);
        if (StringUtils.isBlank((CharSequence)installedVersionString)) {
            return false;
        }
        DefaultArtifactVersion installedVersion = new DefaultArtifactVersion(installedVersionString);
        DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(bundle.getOsgiVersion());
        return installedVersion.compareTo((ArtifactVersion)requiredVersion) >= 0;
    }

    private String getBundleInstalledVersion(CloseableHttpClient httpClient, String bundleSymbolicName, URI consoleTargetUrl) throws IOException {
        URI getUrl = consoleTargetUrl.resolve("bundles/" + bundleSymbolicName + ".json");
        this.getLog().debug((CharSequence)("Get bundle data via request to " + getUrl));
        HttpGet get = new HttpGet(getUrl);
        try {
            String jsonText = (String)httpClient.execute((ClassicHttpRequest)get, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            JsonObject response = JsonSupport.parseObject(jsonText);
            JsonArray data = response.getJsonArray("data");
            if (!data.isEmpty()) {
                JsonObject bundleData = data.getJsonObject(0);
                return bundleData.getString("version");
            }
        }
        catch (JsonException ex) {
            throw new IOException("Reading bundle data from " + getUrl + " failed, cause: " + ex.getMessage(), ex);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
        return null;
    }

    private File getArtifactFile(BundlePrerequisite.Bundle bundle, String extension) throws MojoExecutionException {
        return this.resolveArtifact((Artifact)new DefaultArtifact(bundle.getGroupId(), bundle.getArtifactId(), extension, bundle.getVersion()));
    }
}

