/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.fsresource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.apache.sling.maven.bundlesupport.fsresource.FsResourceConfiguration;

final class FsMountHelper {
    private static final String FS_FACTORY = "org.apache.sling.fsprovider.internal.FsResourceProvider";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String PROPERTY_FSMODE = "provider.fs.mode";
    private static final String PROPERTY_ROOT = "provider.root";
    private static final String PROPERTY_ROOTS = "provider.roots";
    private static final String PROPERTY_PATH = "provider.file";
    private static final String PROPERTY_INITIAL_CONTENT_IMPORT_OPTIONS = "provider.initial.content.import.options";
    private static final String PROPERTY_FILEVAULT_FILTER_XML = "provider.filevault.filterxml.path";
    private final Log log;
    private final HttpClient httpClient;
    private final MavenProject project;

    public FsMountHelper(Log log, HttpClient httpClient, MavenProject project) {
        this.log = log;
        this.httpClient = httpClient;
        this.project = project;
    }

    public void addConfigurations(String targetUrl, Collection<FsResourceConfiguration> cfgs) throws MojoExecutionException {
        Map<String, FsResourceConfiguration> oldConfigs = this.getCurrentConfigurations(targetUrl);
        for (FsResourceConfiguration cfg : cfgs) {
            this.log.info((CharSequence)("Mapping " + cfg.getContentRootDir() + " to " + cfg.getProviderRootPath()));
            boolean found = false;
            Iterator<Map.Entry<String, FsResourceConfiguration>> entryIterator = oldConfigs.entrySet().iterator();
            while (!found && entryIterator.hasNext()) {
                Map.Entry<String, FsResourceConfiguration> current = entryIterator.next();
                FsResourceConfiguration oldcfg = current.getValue();
                this.log.debug((CharSequence)("Comparing " + oldcfg.getContentRootDir() + " with " + oldcfg));
                if (!StringUtils.equals((CharSequence)oldcfg.getContentRootDir(), (CharSequence)oldcfg.getContentRootDir())) continue;
                if (cfg.equals(oldcfg)) {
                    this.log.debug((CharSequence)("Using existing configuration for " + cfg.getContentRootDir() + " and " + cfg.getProviderRootPath()));
                    found = true;
                } else {
                    this.log.debug((CharSequence)("Removing old configuration for " + oldcfg));
                    this.removeConfiguration(targetUrl, current.getKey());
                }
                entryIterator.remove();
            }
            if (found) continue;
            this.log.debug((CharSequence)("Adding new configuration for " + cfg.getContentRootDir() + " and " + cfg.getProviderRootPath()));
            this.addConfiguration(targetUrl, cfg);
        }
        this.removeConfigurations(targetUrl, oldConfigs);
    }

    private void addConfiguration(String targetUrl, FsResourceConfiguration cfg) throws MojoExecutionException {
        String postUrl = targetUrl + "/configMgr/" + FS_FACTORY;
        PostMethod post = new PostMethod(postUrl);
        post.addParameter("apply", "true");
        post.addParameter("factoryPid", FS_FACTORY);
        post.addParameter("pid", "[Temporary PID replaced by real PID upon save]");
        Map<String, String> props = this.toMap(cfg);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            post.addParameter(entry.getKey(), entry.getValue());
        }
        post.addParameter("propertylist", StringUtils.join(props.keySet(), (String)","));
        try {
            int status = this.httpClient.executeMethod((HttpMethod)post);
            if (status == 302 || status == 200) {
                this.log.info((CharSequence)"Configuration created.");
            } else {
                this.log.error((CharSequence)("Configuration on " + postUrl + " failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (HttpException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    private Map<String, String> toMap(FsResourceConfiguration cfg) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (cfg.getFsMode() != null) {
            props.put(PROPERTY_FSMODE, cfg.getFsMode().name());
        }
        if (cfg.getContentRootDir() != null) {
            props.put(PROPERTY_PATH, cfg.getContentRootDir());
        }
        if (cfg.getProviderRootPath() != null) {
            props.put(PROPERTY_ROOT, cfg.getProviderRootPath());
            props.put(PROPERTY_ROOTS, cfg.getProviderRootPath());
        }
        if (cfg.getInitialContentImportOptions() != null) {
            props.put(PROPERTY_INITIAL_CONTENT_IMPORT_OPTIONS, cfg.getInitialContentImportOptions());
        }
        if (cfg.getStringVaultFilterXml() != null) {
            props.put(PROPERTY_FILEVAULT_FILTER_XML, cfg.getStringVaultFilterXml());
        }
        return props;
    }

    public void removeConfigurations(String targetUrl, Map<String, FsResourceConfiguration> configs) throws MojoExecutionException {
        for (Map.Entry<String, FsResourceConfiguration> current : configs.entrySet()) {
            this.log.debug((CharSequence)("Removing configuration for " + current.getValue()));
            this.removeConfiguration(targetUrl, current.getKey());
        }
    }

    private void removeConfiguration(String targetUrl, String pid) throws MojoExecutionException {
        String postUrl = targetUrl + "/configMgr/" + pid;
        PostMethod post = new PostMethod(postUrl);
        post.addParameter("apply", "true");
        post.addParameter("delete", "true");
        try {
            int status = this.httpClient.executeMethod((HttpMethod)post);
            if (status == 302 || status == 200) {
                this.log.debug((CharSequence)"Configuration removed.");
            } else {
                this.log.error((CharSequence)("Removing configuration failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (HttpException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    public Map<String, FsResourceConfiguration> getCurrentConfigurations(String targetUrl) throws MojoExecutionException {
        HashMap<String, FsResourceConfiguration> result;
        block24: {
            this.log.debug((CharSequence)"Getting current file provider configurations.");
            result = new HashMap<String, FsResourceConfiguration>();
            String getUrl = targetUrl + "/configMgr/(service.factoryPid=" + FS_FACTORY + ").json";
            GetMethod get = new GetMethod(getUrl);
            try {
                String jsonText;
                int status = this.httpClient.executeMethod((HttpMethod)get);
                if (status != 200) break block24;
                String contentType = get.getResponseHeader(HEADER_CONTENT_TYPE).getValue();
                int pos = contentType.indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos);
                }
                if (!"application/json".equals(contentType)) {
                    this.log.debug((CharSequence)("Response type from web console is not JSON, but " + contentType));
                    throw new MojoExecutionException("The Apache Felix Web Console is too old to mount the initial content through file system provider configs. Either upgrade the web console or disable this feature.");
                }
                try (InputStream jsonResponse = get.getResponseBodyAsStream();){
                    jsonText = IOUtils.toString((InputStream)jsonResponse, (Charset)StandardCharsets.UTF_8);
                }
                try {
                    JsonArray array = JsonSupport.parseArray(jsonText);
                    for (int i = 0; i < array.size(); ++i) {
                        JsonObject obj = array.getJsonObject(i);
                        String pid = obj.getString("pid");
                        JsonObject properties = obj.getJsonObject("properties");
                        String fsmode = this.getConfigPropertyValue(properties, PROPERTY_FSMODE);
                        String path = this.getConfigPropertyValue(properties, PROPERTY_PATH);
                        String initialContentImportOptions = this.getConfigPropertyValue(properties, PROPERTY_INITIAL_CONTENT_IMPORT_OPTIONS);
                        String fileVaultFilterXml = this.getConfigPropertyValue(properties, PROPERTY_FILEVAULT_FILTER_XML);
                        String root = this.getConfigPropertyValue(properties, PROPERTY_ROOTS);
                        if (root == null) {
                            root = this.getConfigPropertyValue(properties, PROPERTY_ROOT);
                        }
                        if (path == null || !path.startsWith(this.project.getBasedir().getAbsolutePath()) || root == null) continue;
                        FsResourceConfiguration cfg = new FsResourceConfiguration().fsMode(fsmode).providerRootPath(path).contentRootDir(root).initialContentImportOptions(initialContentImportOptions).fileVaultFilterXml(fileVaultFilterXml);
                        this.log.debug((CharSequence)("Found configuration with pid: " + pid + ", " + cfg));
                        result.put(pid, cfg);
                    }
                }
                catch (JsonException ex) {
                    throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
                }
            }
            catch (HttpException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
            }
            finally {
                get.releaseConnection();
            }
        }
        return result;
    }

    private String getConfigPropertyValue(JsonObject obj, String subKey) {
        if (obj.containsKey((Object)subKey)) {
            JsonArray array;
            JsonObject subObj = obj.getJsonObject(subKey);
            if (subObj.containsKey((Object)"value")) {
                return subObj.getString("value");
            }
            if (subObj.containsKey((Object)"values") && (array = subObj.getJsonArray("values")).size() > 0) {
                return array.getString(0);
            }
        }
        return null;
    }
}

