/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="install-file", requiresProject=false)
public class BundleInstallFileMojo
extends AbstractBundleInstallMojo {
    @Parameter(property="sling.file")
    private String bundleFileName;
    @Parameter(property="sling.groupId")
    private String groupId;
    @Parameter(property="sling.artifactId")
    private String artifactId;
    @Parameter(property="sling.version")
    private String version;
    @Parameter(property="sling.packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="sling.classifier")
    private String classifier;
    @Parameter(property="sling.artifact")
    private String artifact;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    private List pomRemoteRepositories;
    @Parameter(property="sling.repoId", defaultValue="temp")
    private String repositoryId = "temp";
    @Parameter(property="sling.repoUrl")
    private String repositoryUrl;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component(hint="default")
    private ArtifactRepositoryLayout repositoryLayout;
    @Parameter(property="localRepository", readonly=true)
    private ArtifactRepository localRepository;

    @Override
    protected String getBundleFileName() throws MojoExecutionException {
        String fileName = this.bundleFileName;
        if (fileName == null && (fileName = this.resolveBundleFileFromArtifact()) == null) {
            throw new MojoExecutionException("Must provide either sling.file or sling.artifact parameters");
        }
        return fileName;
    }

    private String resolveBundleFileFromArtifact() throws MojoExecutionException {
        if (this.artifactId == null && this.artifact == null) {
            return null;
        }
        if (this.artifactId == null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length != 3 && tokens.length != 4 && tokens.length != 5) {
                throw new MojoExecutionException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length >= 4) {
                this.packaging = tokens[3];
            }
            if (tokens.length == 5) {
                this.classifier = tokens[4];
            }
        }
        Artifact packageArtifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.pomRemoteRepositories == null) {
            this.pomRemoteRepositories = new ArrayList();
        }
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>(this.pomRemoteRepositories);
        if (this.repositoryUrl != null) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArtifactRepository remoteRepo = this.artifactRepositoryFactory.createArtifactRepository(this.repositoryId, this.repositoryUrl, this.repositoryLayout, policy, policy);
            repoList.add(remoteRepo);
        }
        try {
            this.artifactResolver.resolve(packageArtifact, repoList, this.localRepository);
            this.getLog().info((CharSequence)("Resolved artifact to " + packageArtifact.getFile().getAbsolutePath()));
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        return packageArtifact.getFile().getAbsolutePath();
    }
}

