/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.AbstractBundleDeployMojo;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class BundleDeployMojo
extends AbstractBundleDeployMojo {
    @Parameter(property="sling.deploy.skip", defaultValue="false", required=true)
    private boolean skip;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private String buildDirectory;
    @Parameter(property="project.build.finalName", alias="jarName", required=true)
    private String jarName;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping bundle deployment as instructed");
            return;
        }
        super.execute();
    }

    @Override
    protected String getJarFileName() {
        return this.buildDirectory + "/" + this.jarName;
    }

    @Override
    protected File fixBundleVersion(File jarFile) throws MojoExecutionException {
        if (this.project.getVersion().indexOf("SNAPSHOT") > 0) {
            String newVersion = this.project.getArtifact().getVersion();
            int firstPos = newVersion.indexOf(45) + 1;
            int pos = 0;
            while (pos != -1) {
                pos = newVersion.indexOf(45);
                if (pos == -1) continue;
                newVersion = newVersion.substring(0, pos) + '.' + newVersion.substring(pos + 1);
            }
            pos = newVersion.indexOf(46, firstPos);
            while (pos != -1) {
                newVersion = newVersion.substring(0, pos) + newVersion.substring(pos + 1);
                pos = newVersion.indexOf(46, pos + 1);
            }
            return this.changeVersion(jarFile, this.project.getVersion(), newVersion);
        }
        try {
            ArtifactVersion v = this.project.getArtifact().getSelectedVersion();
            if (v.getBuildNumber() == 0 && v.getQualifier() == null) {
                String newVersion = this.project.getArtifact().getVersion() + ".FINAL";
                return this.changeVersion(jarFile, this.project.getVersion(), newVersion);
            }
        }
        catch (OverConstrainedVersionException overConstrainedVersionException) {
            // empty catch block
        }
        return jarFile;
    }
}

