/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;
import org.apache.sling.scriptingbundle.plugin.processor.Script;
import org.osgi.framework.Version;

public class ResourceTypeFolderPredicate
implements Predicate<Path> {
    private final Logger logger;

    public ResourceTypeFolderPredicate(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean test(Path folder) {
        if (folder == null) {
            return false;
        }
        Path lastSegment = folder.getFileName();
        if (lastSegment == null) {
            return false;
        }
        try {
            Version.parseVersion((String)lastSegment.toString());
            Path parent = folder.getParent();
            if (parent != null) {
                lastSegment = parent.getFileName();
            }
        }
        catch (IllegalArgumentException parent) {
            // empty catch block
        }
        if (lastSegment == null) return false;
        String lastSegmentString = lastSegment.toString();
        int lastDotIndex = lastSegmentString.lastIndexOf(46);
        String resourceTypeLabel = lastDotIndex != -1 && lastDotIndex < lastSegmentString.length() - 1 ? lastSegmentString.substring(++lastDotIndex) : lastSegmentString;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folder, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            block16: {
                Iterator<Path> iterator = directoryStream.iterator();
                while (iterator.hasNext()) {
                    Path path = iterator.next();
                    Path fileName = path.getFileName();
                    if (fileName == null) continue;
                    String childName = fileName.toString();
                    Script script = Script.parseScript(childName);
                    if (!("extends".equals(childName) || script != null && (resourceTypeLabel.equals(script.getName()) || script.getName() == null && ("html".equals(script.getRequestExtension()) || "GET".equals(script.getRequestMethod()))))) {
                        continue;
                    }
                    break block16;
                }
                return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.logger.error(String.format("Could not check if folder %s denotes a resource type.", folder.toString()), e);
        }
        return false;
    }
}

