/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.capability.RequiredResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;
import org.apache.sling.scriptingbundle.plugin.processor.Script;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.VersionRange;

public class FileProcessor {
    private final Logger log;
    private final Set<String> searchPaths;
    private final Map<String, String> scriptEngineMappings;
    private static final Collection<String> EXTENDS_ALLOWED_ATTRIBUTE_NAMES = Arrays.asList("resolution:", "version");
    private static final Collection<String> REQUIRES_ALLOWED_ATTRIBUTE_NAMES = Arrays.asList("resolution:", "version");

    public FileProcessor(Logger log, Set<String> searchPaths, Map<String, String> scriptEngineMappings) {
        this.log = log;
        this.searchPaths = searchPaths;
        this.scriptEngineMappings = scriptEngineMappings;
    }

    public void processExtendsFile(@NotNull ResourceType resourceType, @NotNull Path extendsFile, @NotNull Set<ProvidedResourceTypeCapability> providedCapabilities, @NotNull Set<RequiredResourceTypeCapability> requiredCapabilities) throws IllegalArgumentException {
        try {
            RequiredResourceTypeCapability.Builder requiredBuilder;
            Map.Entry extendsParameter;
            List<String> extendResources = Files.readAllLines(extendsFile, StandardCharsets.UTF_8);
            if (extendResources.size() == 1) {
                String extend = extendResources.get(0);
                Parameters parameters = OSGiHeader.parseHeader((String)extend);
                if (parameters.size() < 1 || parameters.size() > 1) {
                    throw new IllegalArgumentException(String.format("The file '%s' must contain one clause only (not multiple ones separated by ',')", extendsFile));
                }
                extendsParameter = (Map.Entry)parameters.entrySet().iterator().next();
                for (String attributeName : ((Attrs)extendsParameter.getValue()).keySet()) {
                    if (EXTENDS_ALLOWED_ATTRIBUTE_NAMES.contains(attributeName)) continue;
                    throw new IllegalArgumentException(String.format("Found unsupported attribute/directive '%s' in file '%s'. Only the following attributes or directives may be used in the extends file: %s", attributeName, extendsFile, String.join((CharSequence)",", EXTENDS_ALLOWED_ATTRIBUTE_NAMES)));
                }
                String extendedResourceType = FilenameUtils.normalize((String)((String)extendsParameter.getKey()), (boolean)true);
                boolean isOptional = "optional".equals(((Attrs)extendsParameter.getValue()).get("resolution:"));
                Set<String> searchPathResourceTypes = this.processSearchPathResourceTypes(resourceType);
                Optional<ProvidedResourceTypeCapability> rootCapability = providedCapabilities.stream().filter(capability -> capability.getResourceTypes().equals(searchPathResourceTypes) && capability.getSelectors().isEmpty() && StringUtils.isEmpty((CharSequence)capability.getRequestMethod()) && StringUtils.isEmpty((CharSequence)capability.getRequestExtension())).findFirst();
                rootCapability.ifPresent(capability -> {
                    providedCapabilities.remove(capability);
                    ProvidedResourceTypeCapability replacement = ProvidedResourceTypeCapability.builder().fromCapability((ProvidedResourceTypeCapability)capability).withExtendsResourceType(extendedResourceType).build();
                    providedCapabilities.add(replacement);
                });
                if (!rootCapability.isPresent()) {
                    providedCapabilities.add(ProvidedResourceTypeCapability.builder().withResourceTypes(this.processSearchPathResourceTypes(resourceType)).withVersion(resourceType.getVersion()).withExtendsResourceType(extendedResourceType).build());
                }
                requiredBuilder = RequiredResourceTypeCapability.builder().withResourceType(extendedResourceType);
                if (isOptional) {
                    requiredBuilder.withIsOptional();
                }
            } else {
                throw new IllegalArgumentException(String.format("The file '%s' must contain one line only (not multiple ones)", extendsFile));
            }
            this.extractVersionRange(extendsFile, requiredBuilder, ((Attrs)extendsParameter.getValue()).getVersion());
            requiredCapabilities.add(requiredBuilder.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to read file %s.", extendsFile.toString()), e);
        }
    }

    void processRequiresFile(@NotNull Path requiresFile, @NotNull Set<RequiredResourceTypeCapability> requiredCapabilities) {
        try {
            List<String> requiredResourceTypes = Files.readAllLines(requiresFile, StandardCharsets.UTF_8);
            for (String requiredResourceType : requiredResourceTypes) {
                Parameters parameters = OSGiHeader.parseHeader((String)requiredResourceType);
                if (parameters.size() < 1 || parameters.size() > 1) {
                    throw new IllegalArgumentException(String.format("Each line in file '%s' must contain one clause only (not multiple ones separated by ',')", requiresFile));
                }
                Map.Entry requiresParameter = (Map.Entry)parameters.entrySet().iterator().next();
                for (String attributeName : ((Attrs)requiresParameter.getValue()).keySet()) {
                    if (REQUIRES_ALLOWED_ATTRIBUTE_NAMES.contains(attributeName)) continue;
                    throw new IllegalArgumentException(String.format("Found unsupported attribute/directive '%s' in file '%s'. Only the following attributes or directives may be used in the requires file: %s", attributeName, requiresFile, String.join((CharSequence)",", REQUIRES_ALLOWED_ATTRIBUTE_NAMES)));
                }
                String resourceType = FilenameUtils.normalize((String)((String)requiresParameter.getKey()), (boolean)true);
                boolean isOptional = "optional".equals(((Attrs)requiresParameter.getValue()).get("resolution:"));
                RequiredResourceTypeCapability.Builder requiredBuilder = RequiredResourceTypeCapability.builder().withResourceType(resourceType);
                if (isOptional) {
                    requiredBuilder.withIsOptional();
                }
                this.extractVersionRange(requiresFile, requiredBuilder, ((Attrs)requiresParameter.getValue()).getVersion());
                requiredCapabilities.add(requiredBuilder.build());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to read file %s.", requiresFile.toString()), e);
        }
    }

    public void processScriptFile(@NotNull Path resourceTypeDirectory, @NotNull Path scriptPath, @NotNull ResourceType resourceType, @NotNull Set<ProvidedResourceTypeCapability> providedCapabilities) {
        String filePath = scriptPath.toString();
        String extension = FilenameUtils.getExtension((String)filePath);
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            Path scriptFile = scriptPath.getFileName();
            if (scriptFile != null) {
                String scriptFileName;
                Script script;
                Path relativeResourceTypeFolder = resourceTypeDirectory.relativize(scriptPath);
                int pathSegments = relativeResourceTypeFolder.getNameCount();
                ArrayList<String> selectors = new ArrayList<String>();
                if (pathSegments > 1) {
                    for (int i = 0; i < pathSegments - 1; ++i) {
                        selectors.add(relativeResourceTypeFolder.getName(i).toString());
                    }
                }
                if ((script = Script.parseScript(scriptFileName = scriptFile.toString())) != null) {
                    String scriptEngine = this.scriptEngineMappings.get(script.getScriptExtension());
                    if (scriptEngine != null) {
                        String scriptName = script.getName();
                        Set<String> searchPathProcessesResourceTypes = this.processSearchPathResourceTypes(resourceType);
                        if (scriptName != null && !resourceType.getResourceLabel().equals(scriptName)) {
                            selectors.add(script.getName());
                        }
                        Optional<Object> extendsCapability = Optional.empty();
                        if (selectors.isEmpty() && StringUtils.isEmpty((CharSequence)script.getRequestExtension()) && StringUtils.isEmpty((CharSequence)script.getRequestMethod())) {
                            extendsCapability = providedCapabilities.stream().filter(capability -> StringUtils.isNotEmpty((CharSequence)capability.getExtendsResourceType()) && capability.getResourceTypes().equals(searchPathProcessesResourceTypes) && capability.getSelectors().isEmpty() && StringUtils.isEmpty((CharSequence)capability.getRequestExtension()) && StringUtils.isEmpty((CharSequence)capability.getRequestMethod())).findAny();
                        }
                        ProvidedResourceTypeCapability.Builder builder = ProvidedResourceTypeCapability.builder().withResourceTypes(searchPathProcessesResourceTypes).withVersion(resourceType.getVersion()).withSelectors(selectors).withRequestExtension(script.getRequestExtension()).withRequestMethod(script.getRequestMethod()).withScriptEngine(scriptEngine).withScriptExtension(script.getScriptExtension());
                        extendsCapability.ifPresent(capability -> {
                            builder.withExtendsResourceType(capability.getExtendsResourceType());
                            providedCapabilities.remove(capability);
                        });
                        providedCapabilities.add(builder.build());
                    } else {
                        this.log.warn(String.format("Cannot find a script engine mapping for script %s.", scriptPath));
                    }
                } else {
                    this.log.warn(String.format("Skipping file %s not denoting a script as it does not follow the filename patterns outlined at https://sling.apache.org/documentation/the-sling-engine/url-to-script-resolution.html#script-naming-conventions", scriptPath));
                }
            } else {
                throw new IllegalArgumentException(String.format("Invalid path given: '%s'.", scriptPath));
            }
        }
    }

    private Set<String> processSearchPathResourceTypes(@NotNull ResourceType resourceType) {
        HashSet<String> resourceTypes = new HashSet<String>();
        for (String searchPath : this.searchPaths) {
            String absoluteType;
            if (!searchPath.endsWith("/")) {
                searchPath = searchPath + "/";
            }
            if (!(absoluteType = "/" + resourceType.getType()).startsWith(searchPath)) continue;
            resourceTypes.add(absoluteType);
            resourceTypes.add(absoluteType.substring(searchPath.length()));
        }
        if (resourceTypes.isEmpty()) {
            resourceTypes.add(resourceType.getType());
        }
        return resourceTypes;
    }

    private void extractVersionRange(@NotNull Path requiresFile, @NotNull RequiredResourceTypeCapability.Builder requiredBuilder, String version) {
        try {
            if (version != null) {
                requiredBuilder.withVersionRange(VersionRange.valueOf((String)version.substring(version.indexOf(61) + 1)));
            }
        }
        catch (IllegalArgumentException ignored) {
            this.log.warn(String.format("Invalid version range format %s in file %s.", version, requiresFile));
        }
    }
}

