/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Constants {
    public static final Set<String> METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TRACE", "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "PATCH")));
    public static final String EXTENDS_FILE = "extends";
    public static final String REQUIRES_FILE = "requires";
    public static final String CAPABILITY_NS = "sling.servlet";
    public static final String CAPABILITY_RESOURCE_TYPE_AT = "sling.servlet.resourceTypes";
    public static final String CAPABILITY_SELECTORS_AT = "sling.servlet.selectors";
    public static final String CAPABILITY_EXTENSIONS_AT = "sling.servlet.extensions";
    public static final String CAPABILITY_METHODS_AT = "sling.servlet.methods";
    public static final String CAPABILITY_PATH_AT = "sling.servlet.paths";
    public static final String CAPABILITY_VERSION_AT = "version";
    public static final String CAPABILITY_EXTENDS_AT = "extends";
    public static final String CAPABILITY_SCRIPT_ENGINE_AT = "scriptEngine";
    public static final String CAPABILITY_SCRIPT_EXTENSION_AT = "scriptExtension";
    public static final String BND_SOURCE_DIRECTORIES = "sourceDirectories";
    public static final String BND_EXCLUDES = "excludes";
    public static final String BND_INCLUDES = "includes";
    public static final String BND_SCRIPT_ENGINE_MAPPINGS = "scriptEngineMappings";
    public static final String BND_SEARCH_PATHS = "searchPaths";
    public static final Map<String, String> DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING;
    public static final Set<String> DEFAULT_SEARCH_PATHS;
    public static final Set<String> DEFAULT_SOURCE_DIRECTORIES;
    public static final Set<String> DEFAULT_EXCLUDES;

    private Constants() {
    }

    static {
        DEFAULT_EXCLUDES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/.svn", "**/.svn/**", "**/.bzr", "**/.bzr/**", "**/.DS_Store", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**")));
        HashMap<String, String> scriptEngineMapping = new HashMap<String, String>();
        scriptEngineMapping.put("ftl", "freemarker");
        scriptEngineMapping.put("gst", "gstring");
        scriptEngineMapping.put("html", "htl");
        scriptEngineMapping.put("java", "java");
        scriptEngineMapping.put("esp", "rhino");
        scriptEngineMapping.put("ecma", "rhino");
        scriptEngineMapping.put("jsp", "jsp");
        scriptEngineMapping.put("jspf", "jsp");
        scriptEngineMapping.put("jspx", "jsp");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING = Collections.unmodifiableMap(scriptEngineMapping);
        DEFAULT_SEARCH_PATHS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("/libs", "/apps")));
        DEFAULT_SOURCE_DIRECTORIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Paths.get("src", "main", "scripts").toString(), Paths.get("src", "main", "resources", "javax.script").toString())));
    }
}

