/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.capability;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.version.Version;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedScriptCapability;
import org.apache.sling.scriptingbundle.plugin.capability.RequiredResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.processor.FileProcessor;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;
import org.apache.sling.scriptingbundle.plugin.processor.PathOnlyScriptAnalyser;
import org.apache.sling.scriptingbundle.plugin.processor.ResourceTypeFolderAnalyser;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.VersionRange;

public class Capabilities {
    private final Set<ProvidedResourceTypeCapability> providedResourceTypeCapabilities;
    private final Set<ProvidedScriptCapability> providedScriptCapabilities;
    private final Set<RequiredResourceTypeCapability> requiredResourceTypeCapabilities;
    private final Set<RequiredResourceTypeCapability> unresolvedRequiredResourceTypeCapabilities;
    public static final Capabilities EMPTY = new Capabilities(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());

    public Capabilities(@NotNull Set<ProvidedResourceTypeCapability> providedResourceTypeCapabilities, @NotNull Set<ProvidedScriptCapability> providedScriptCapabilities, @NotNull Set<RequiredResourceTypeCapability> requiredResourceTypeCapabilities) {
        this.providedResourceTypeCapabilities = providedResourceTypeCapabilities;
        this.providedScriptCapabilities = providedScriptCapabilities;
        this.requiredResourceTypeCapabilities = requiredResourceTypeCapabilities;
        this.unresolvedRequiredResourceTypeCapabilities = new HashSet<RequiredResourceTypeCapability>(requiredResourceTypeCapabilities);
        providedResourceTypeCapabilities.forEach(providedResourceTypeCapability -> this.unresolvedRequiredResourceTypeCapabilities.removeIf(requiredResourceTypeCapability -> requiredResourceTypeCapability.isSatisfied((ProvidedResourceTypeCapability)providedResourceTypeCapability)));
    }

    @NotNull
    public Set<ProvidedResourceTypeCapability> getProvidedResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.providedResourceTypeCapabilities);
    }

    @NotNull
    public Set<ProvidedScriptCapability> getProvidedScriptCapabilities() {
        return Collections.unmodifiableSet(this.providedScriptCapabilities);
    }

    @NotNull
    public Set<RequiredResourceTypeCapability> getRequiredResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.requiredResourceTypeCapabilities);
    }

    @NotNull
    public Set<RequiredResourceTypeCapability> getUnresolvedRequiredResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.unresolvedRequiredResourceTypeCapabilities);
    }

    @NotNull
    public String getProvidedCapabilitiesString() {
        Attrs attributes;
        Parameters parameters = new Parameters();
        for (ProvidedResourceTypeCapability capability : this.getProvidedResourceTypeCapabilities()) {
            attributes = new Attrs();
            attributes.putTyped("sling.servlet.resourceTypes", capability.getResourceTypes());
            Optional.ofNullable(capability.getScriptEngine()).ifPresent(scriptEngine -> attributes.put("scriptEngine", scriptEngine));
            Optional.ofNullable(capability.getScriptExtension()).ifPresent(scriptExtension -> attributes.put("scriptExtension", scriptExtension));
            Optional.ofNullable(capability.getVersion()).ifPresent(version -> attributes.putTyped("version", (Object)new Version(version.toString())));
            Optional.ofNullable(capability.getExtendsResourceType()).ifPresent(extendedResourceType -> attributes.put("extends", extendedResourceType));
            Optional.ofNullable(capability.getRequestMethod()).ifPresent(method -> attributes.put("sling.servlet.methods", method));
            Optional.ofNullable(capability.getRequestExtension()).ifPresent(requestExtension -> attributes.put("sling.servlet.extensions", requestExtension));
            if (!capability.getSelectors().isEmpty()) {
                attributes.putTyped("sling.servlet.selectors", capability.getSelectors());
            }
            parameters.add("sling.servlet", attributes);
        }
        for (ProvidedScriptCapability scriptCapability : this.getProvidedScriptCapabilities()) {
            attributes = new Attrs();
            attributes.put("sling.servlet.paths", scriptCapability.getPath());
            attributes.put("scriptEngine", scriptCapability.getScriptEngine());
            attributes.put("scriptExtension", scriptCapability.getScriptExtension());
            parameters.add("sling.servlet", attributes);
        }
        return parameters.toString();
    }

    @NotNull
    public String getRequiredCapabilitiesString() {
        Parameters parameters = new Parameters();
        for (RequiredResourceTypeCapability capability : this.getRequiredResourceTypeCapabilities()) {
            Attrs attributes = new Attrs();
            StringBuilder filterValue = new StringBuilder("(&(!(sling.servlet.selectors=*))");
            VersionRange versionRange = capability.getVersionRange();
            if (versionRange != null) {
                filterValue.append("(&").append(versionRange.toFilterString("version")).append("(").append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType()).append(")))");
            } else {
                filterValue.append("(").append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType()).append("))");
            }
            attributes.put("filter:", filterValue.toString());
            if (capability.isOptional()) {
                attributes.put("resolution:", "optional");
            }
            parameters.add("sling.servlet", attributes);
        }
        return parameters.toString();
    }

    @NotNull
    public static Capabilities fromFileSystemTree(@NotNull Path root, @NotNull Stream<Path> files, @NotNull Logger logger, @NotNull Set<String> searchPaths, @NotNull Map<String, String> scriptEngineMappings) {
        LinkedHashSet<ProvidedResourceTypeCapability> providedResourceTypeCapabilities = new LinkedHashSet<ProvidedResourceTypeCapability>();
        LinkedHashSet<ProvidedScriptCapability> providedScriptCapabilities = new LinkedHashSet<ProvidedScriptCapability>();
        LinkedHashSet<RequiredResourceTypeCapability> requiredResourceTypeCapabilities = new LinkedHashSet<RequiredResourceTypeCapability>();
        FileProcessor fileProcessor = new FileProcessor(logger, searchPaths, scriptEngineMappings);
        ResourceTypeFolderAnalyser resourceTypeFolderAnalyser = new ResourceTypeFolderAnalyser(logger, root, fileProcessor);
        PathOnlyScriptAnalyser pathOnlyScriptAnalyser = new PathOnlyScriptAnalyser(logger, root, scriptEngineMappings, fileProcessor);
        files.forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Capabilities resourceTypeCapabilities = resourceTypeFolderAnalyser.getCapabilities((Path)path);
                providedResourceTypeCapabilities.addAll(resourceTypeCapabilities.getProvidedResourceTypeCapabilities());
                requiredResourceTypeCapabilities.addAll(resourceTypeCapabilities.getRequiredResourceTypeCapabilities());
            } else {
                Capabilities pathCapabilities = pathOnlyScriptAnalyser.getProvidedScriptCapability((Path)path);
                providedScriptCapabilities.addAll(pathCapabilities.getProvidedScriptCapabilities());
                requiredResourceTypeCapabilities.addAll(pathCapabilities.getRequiredResourceTypeCapabilities());
            }
        });
        return new Capabilities(providedResourceTypeCapabilities, providedScriptCapabilities, requiredResourceTypeCapabilities);
    }
}

