/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.service.reporter.Reporter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scriptingbundle.plugin.bnd.BndLogger;
import org.apache.sling.scriptingbundle.plugin.capability.Capabilities;
import org.apache.sling.scriptingbundle.plugin.processor.Constants;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;

public class BundledScriptsScannerPlugin
implements AnalyzerPlugin,
Plugin {
    public static final String GLOB = "glob:";
    static final String PROJECT_BUILD_FOLDER = "project.output";
    static final String PROJECT_ROOT_FOLDER = "project.dir";
    private Map<String, String> pluginProperties;
    private Reporter reporter;
    private Logger logger;
    private Capabilities capabilities;
    private Map<String, String> scriptEngineMappings;

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        this.logger = new BndLogger(this.reporter);
        Path workDirectory = Paths.get(analyzer.get(PROJECT_BUILD_FOLDER), "scriptingbundle-maven-plugin");
        Files.createDirectories(workDirectory, new FileAttribute[0]);
        Set<PathMatcher> includes = this.getConfiguredIncludes();
        Set<PathMatcher> excludes = this.getConfiguredExcludes();
        this.getConfiguredSourceDirectories().stream().map(sourceDirectory -> {
            Path sourceDirectoryPath = Paths.get(sourceDirectory, new String[0]);
            if (!Files.exists(sourceDirectoryPath, new LinkOption[0])) {
                sourceDirectoryPath = Paths.get(analyzer.get(PROJECT_ROOT_FOLDER), sourceDirectory);
            }
            return sourceDirectoryPath;
        }).filter(sourceDirectoryPath -> Files.exists(sourceDirectoryPath, new LinkOption[0]) && Files.isDirectory(sourceDirectoryPath, new LinkOption[0])).forEach(sourceDirectoryPath -> {
            try (Stream<Path> includedFiles = this.walkPath((Path)sourceDirectoryPath, includes, excludes);){
                includedFiles.forEach(file -> {
                    try {
                        if (!Files.isDirectory(file, new LinkOption[0])) {
                            Path workingCopy = Paths.get(workDirectory.toString(), sourceDirectoryPath.relativize((Path)file).toString());
                            Files.createDirectories(workingCopy.getParent(), new FileAttribute[0]);
                            Files.copy(file, workingCopy, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Cannot copy file into working directory.", e);
                    }
                });
            }
            catch (IOException e) {
                this.logger.error("Cannot analyse source folders.", e);
            }
        });
        this.scriptEngineMappings = this.getConfiguredScriptEngineMappings();
        this.capabilities = Capabilities.fromFileSystemTree(workDirectory, this.walkPath(workDirectory, includes, excludes), this.logger, this.getConfiguredSearchPaths(), this.scriptEngineMappings);
        String providedCapabilitiesDefinition = this.capabilities.getProvidedCapabilitiesString();
        String requiredCapabilitiesDefinition = this.capabilities.getRequiredCapabilitiesString();
        String providedCapabilities = analyzer.get("Provide-Capability");
        providedCapabilities = StringUtils.isNotEmpty((CharSequence)providedCapabilities) ? providedCapabilities + ", " + providedCapabilitiesDefinition : providedCapabilitiesDefinition;
        analyzer.set("Provide-Capability", providedCapabilities);
        String requiredCapabilities = analyzer.get("Require-Capability");
        requiredCapabilities = StringUtils.isNotEmpty((CharSequence)requiredCapabilities) ? requiredCapabilities + ", " + requiredCapabilitiesDefinition : requiredCapabilitiesDefinition;
        analyzer.set("Require-Capability", requiredCapabilities);
        return false;
    }

    public void setProperties(Map<String, String> pluginProperties) {
        this.pluginProperties = pluginProperties;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public Map<String, String> getScriptEngineMappings() {
        return this.scriptEngineMappings;
    }

    private Set<String> getConfiguredSourceDirectories() {
        String sourceDirectoriesCSV = this.pluginProperties.get("sourceDirectories");
        if (StringUtils.isNotEmpty((CharSequence)sourceDirectoriesCSV)) {
            return Collections.unmodifiableSet(Arrays.stream(sourceDirectoriesCSV.split(",")).map(String::trim).collect(Collectors.toSet()));
        }
        return Constants.DEFAULT_SOURCE_DIRECTORIES;
    }

    private Set<PathMatcher> getConfiguredExcludes() {
        String excludesCSV = this.pluginProperties.get("excludes");
        if (StringUtils.isNotEmpty((CharSequence)excludesCSV)) {
            return Collections.unmodifiableSet(Arrays.stream(excludesCSV.split(",")).map(String::trim).map(pattern -> FileSystems.getDefault().getPathMatcher(GLOB + pattern)).collect(Collectors.toSet()));
        }
        return Collections.unmodifiableSet(Constants.DEFAULT_EXCLUDES.stream().map(pattern -> FileSystems.getDefault().getPathMatcher(GLOB + pattern)).collect(Collectors.toSet()));
    }

    private Set<PathMatcher> getConfiguredIncludes() {
        String includesCSV = this.pluginProperties.get("includes");
        if (StringUtils.isNotEmpty((CharSequence)includesCSV)) {
            return Collections.unmodifiableSet(Arrays.stream(includesCSV.split(",")).map(String::trim).map(pattern -> FileSystems.getDefault().getPathMatcher(GLOB + pattern)).collect(Collectors.toSet()));
        }
        return Collections.emptySet();
    }

    private Map<String, String> getConfiguredScriptEngineMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>(Constants.DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING);
        String scriptEngineMappingsCSV = this.pluginProperties.get("scriptEngineMappings");
        if (StringUtils.isNotEmpty((CharSequence)scriptEngineMappingsCSV)) {
            List<String> extensionEngineMappings = Arrays.stream(scriptEngineMappingsCSV.split(",")).map(String::trim).collect(Collectors.toList());
            extensionEngineMappings.forEach(mapping -> {
                String[] mappingArray = mapping.split(":");
                if (mappingArray.length != 2) {
                    this.logger.error(String.format("Invalid script engine mapping: %s.", mapping));
                } else {
                    mappings.put(mappingArray[0].trim(), mappingArray[1].trim());
                }
            });
        }
        return Collections.unmodifiableMap(mappings);
    }

    private Set<String> getConfiguredSearchPaths() {
        String searchPathsString = this.pluginProperties.get("searchPaths");
        if (StringUtils.isNotEmpty((CharSequence)searchPathsString)) {
            return Collections.unmodifiableSet(Arrays.stream(searchPathsString.split(",")).map(String::trim).collect(Collectors.toSet()));
        }
        return Constants.DEFAULT_SEARCH_PATHS;
    }

    private Stream<Path> walkPath(Path path, Set<PathMatcher> includes, Set<PathMatcher> excludes) throws IOException {
        return Files.walk(path, new FileVisitOption[0]).filter(file -> {
            Optional<PathMatcher> excludeOptions;
            Optional<PathMatcher> includeOptions;
            boolean include = false;
            if (includes.isEmpty()) {
                include = true;
            }
            if ((includeOptions = includes.stream().filter(pathMatcher -> pathMatcher.matches((Path)file)).findFirst()).isPresent()) {
                include = true;
            }
            if ((excludeOptions = excludes.stream().filter(pathMatcher -> pathMatcher.matches((Path)file)).findFirst()).isPresent()) {
                include = false;
            }
            return include;
        }).flatMap(file -> {
            if (!Files.isDirectory(file, new LinkOption[0])) {
                return Stream.of(file, file.getParent());
            }
            return Stream.of(file);
        });
    }
}

