/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.capability.RequiredResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;
import org.apache.sling.scriptingbundle.plugin.processor.Script;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.VersionRange;

public class FileProcessor {
    private final Logger log;
    private final Set<String> searchPaths;
    private final Map<String, String> scriptEngineMappings;

    public FileProcessor(Logger log, Set<String> searchPaths, Map<String, String> scriptEngineMappings) {
        this.log = log;
        this.searchPaths = searchPaths;
        this.scriptEngineMappings = scriptEngineMappings;
    }

    public void processExtendsFile(@NotNull ResourceType resourceType, @NotNull Path extendsFile, @NotNull Set<ProvidedResourceTypeCapability> providedCapabilities, @NotNull Set<RequiredResourceTypeCapability> requiredCapabilities) {
        try {
            String extend;
            List<String> extendResources = Files.readAllLines(extendsFile, StandardCharsets.UTF_8);
            if (extendResources.size() == 1 && StringUtils.isNotEmpty((CharSequence)(extend = extendResources.get(0)))) {
                String[] extendParts = extend.split(";");
                String extendedResourceType = FilenameUtils.normalize((String)extendParts[0], (boolean)true);
                String extendedResourceTypeVersion = extendParts.length > 1 ? extendParts[1] : null;
                Set<String> searchPathResourceTypes = this.processSearchPathResourceTypes(resourceType);
                Optional<ProvidedResourceTypeCapability> rootCapability = providedCapabilities.stream().filter(capability -> capability.getResourceTypes().equals(searchPathResourceTypes) && capability.getSelectors().isEmpty() && StringUtils.isEmpty((CharSequence)capability.getRequestMethod()) && StringUtils.isEmpty((CharSequence)capability.getRequestExtension())).findFirst();
                rootCapability.ifPresent(capability -> {
                    providedCapabilities.remove(capability);
                    ProvidedResourceTypeCapability replacement = ProvidedResourceTypeCapability.builder().fromCapability((ProvidedResourceTypeCapability)capability).withExtendsResourceType(extendedResourceType).build();
                    providedCapabilities.add(replacement);
                });
                if (!rootCapability.isPresent()) {
                    providedCapabilities.add(ProvidedResourceTypeCapability.builder().withResourceTypes(this.processSearchPathResourceTypes(resourceType)).withVersion(resourceType.getVersion()).withExtendsResourceType(extendedResourceType).build());
                }
                RequiredResourceTypeCapability.Builder requiredBuilder = RequiredResourceTypeCapability.builder().withResourceType(extendedResourceType);
                this.extractVersionRange(extendsFile, requiredBuilder, extendedResourceTypeVersion);
                requiredCapabilities.add(requiredBuilder.build());
            }
        }
        catch (IOException e) {
            this.log.error(String.format("Unable to read file %s.", extendsFile.toString()), e);
        }
    }

    void processRequiresFile(@NotNull Path requiresFile, @NotNull Set<RequiredResourceTypeCapability> requiredCapabilities) {
        try {
            List<String> requiredResourceTypes = Files.readAllLines(requiresFile, StandardCharsets.UTF_8);
            for (String requiredResourceType : requiredResourceTypes) {
                if (!StringUtils.isNotEmpty((CharSequence)requiredResourceType)) continue;
                String[] requireParts = requiredResourceType.split(";");
                String resourceType = FilenameUtils.normalize((String)requireParts[0], (boolean)true);
                String version = requireParts.length > 1 ? requireParts[1] : null;
                RequiredResourceTypeCapability.Builder requiredBuilder = RequiredResourceTypeCapability.builder().withResourceType(resourceType);
                this.extractVersionRange(requiresFile, requiredBuilder, version);
                requiredCapabilities.add(requiredBuilder.build());
            }
        }
        catch (IOException e) {
            this.log.error(String.format("Unable to read file %s.", requiresFile.toString()), e);
        }
    }

    public void processScriptFile(@NotNull Path resourceTypeDirectory, @NotNull Path scriptPath, @NotNull ResourceType resourceType, @NotNull Set<ProvidedResourceTypeCapability> providedCapabilities) {
        String filePath = scriptPath.toString();
        String extension = FilenameUtils.getExtension((String)filePath);
        if (StringUtils.isNotEmpty((CharSequence)extension) && this.scriptEngineMappings.containsKey(extension)) {
            Path scriptFile = scriptPath.getFileName();
            if (scriptFile != null) {
                String scriptFileName;
                Script script;
                Path relativeResourceTypeFolder = resourceTypeDirectory.relativize(scriptPath);
                int pathSegments = relativeResourceTypeFolder.getNameCount();
                LinkedHashSet<String> selectors = new LinkedHashSet<String>();
                if (pathSegments > 1) {
                    for (int i = 0; i < pathSegments - 1; ++i) {
                        selectors.add(relativeResourceTypeFolder.getName(i).toString());
                    }
                }
                if ((script = Script.parseScript(scriptFileName = scriptFile.toString())) != null) {
                    String scriptEngine = this.scriptEngineMappings.get(script.getScriptExtension());
                    if (scriptEngine != null) {
                        String scriptName = script.getName();
                        Set<String> searchPathProcessesResourceTypes = this.processSearchPathResourceTypes(resourceType);
                        if (scriptName != null && !resourceType.getResourceLabel().equals(scriptName)) {
                            selectors.add(script.getName());
                        }
                        Optional<Object> extendsCapability = Optional.empty();
                        if (selectors.isEmpty() && StringUtils.isEmpty((CharSequence)script.getRequestExtension()) && StringUtils.isEmpty((CharSequence)script.getRequestMethod())) {
                            extendsCapability = providedCapabilities.stream().filter(capability -> StringUtils.isNotEmpty((CharSequence)capability.getExtendsResourceType()) && capability.getResourceTypes().equals(searchPathProcessesResourceTypes) && capability.getSelectors().isEmpty() && StringUtils.isEmpty((CharSequence)capability.getRequestExtension()) && StringUtils.isEmpty((CharSequence)capability.getRequestMethod())).findAny();
                        }
                        ProvidedResourceTypeCapability.Builder builder = ProvidedResourceTypeCapability.builder().withResourceTypes(searchPathProcessesResourceTypes).withVersion(resourceType.getVersion()).withSelectors(selectors).withRequestExtension(script.getRequestExtension()).withRequestMethod(script.getRequestMethod()).withScriptEngine(scriptEngine).withScriptExtension(script.getScriptExtension());
                        extendsCapability.ifPresent(capability -> {
                            builder.withExtendsResourceType(capability.getExtendsResourceType());
                            providedCapabilities.remove(capability);
                        });
                        providedCapabilities.add(builder.build());
                    } else {
                        this.log.warn(String.format("Cannot find a script engine mapping for script %s.", scriptPath));
                    }
                } else {
                    this.log.warn(String.format("File %s does not denote a script.", scriptPath));
                }
            } else {
                this.log.warn(String.format("Skipping path %s since it has 0 elements.", scriptPath));
            }
        }
    }

    private Set<String> processSearchPathResourceTypes(@NotNull ResourceType resourceType) {
        HashSet<String> resourceTypes = new HashSet<String>();
        for (String searchPath : this.searchPaths) {
            String absoluteType;
            if (!searchPath.endsWith("/")) {
                searchPath = searchPath + "/";
            }
            if (!(absoluteType = "/" + resourceType.getType()).startsWith(searchPath)) continue;
            resourceTypes.add(absoluteType);
            resourceTypes.add(absoluteType.substring(searchPath.length()));
        }
        if (resourceTypes.isEmpty()) {
            resourceTypes.add(resourceType.getType());
        }
        return resourceTypes;
    }

    private void extractVersionRange(@NotNull Path requiresFile, @NotNull RequiredResourceTypeCapability.Builder requiredBuilder, String version) {
        try {
            if (version != null) {
                requiredBuilder.withVersionRange(VersionRange.valueOf((String)version.substring(version.indexOf(61) + 1)));
            }
        }
        catch (IllegalArgumentException ignored) {
            this.log.warn(String.format("Invalid version range format %s in file %s.", version, requiresFile));
        }
    }
}

