/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.capability;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.capability.ProvidedScriptCapability;
import org.apache.sling.scriptingbundle.plugin.capability.RequiredResourceTypeCapability;
import org.apache.sling.scriptingbundle.plugin.processor.FileProcessor;
import org.apache.sling.scriptingbundle.plugin.processor.Logger;
import org.apache.sling.scriptingbundle.plugin.processor.PathOnlyScriptAnalyser;
import org.apache.sling.scriptingbundle.plugin.processor.ResourceTypeFolderAnalyser;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.VersionRange;

public class Capabilities {
    private final Set<ProvidedResourceTypeCapability> providedResourceTypeCapabilities;
    private final Set<ProvidedScriptCapability> providedScriptCapabilities;
    private final Set<RequiredResourceTypeCapability> requiredResourceTypeCapabilities;
    private final Set<RequiredResourceTypeCapability> unresolvedRequiredResourceTypeCapabilities;
    public static final Capabilities EMPTY = new Capabilities(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());

    public Capabilities(@NotNull Set<ProvidedResourceTypeCapability> providedResourceTypeCapabilities, @NotNull Set<ProvidedScriptCapability> providedScriptCapabilities, @NotNull Set<RequiredResourceTypeCapability> requiredResourceTypeCapabilities) {
        this.providedResourceTypeCapabilities = providedResourceTypeCapabilities;
        this.providedScriptCapabilities = providedScriptCapabilities;
        this.requiredResourceTypeCapabilities = requiredResourceTypeCapabilities;
        this.unresolvedRequiredResourceTypeCapabilities = new HashSet<RequiredResourceTypeCapability>(requiredResourceTypeCapabilities);
        providedResourceTypeCapabilities.forEach(providedResourceTypeCapability -> this.unresolvedRequiredResourceTypeCapabilities.removeIf(requiredResourceTypeCapability -> requiredResourceTypeCapability.isSatisfied((ProvidedResourceTypeCapability)providedResourceTypeCapability)));
    }

    @NotNull
    public Set<ProvidedResourceTypeCapability> getProvidedResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.providedResourceTypeCapabilities);
    }

    @NotNull
    public Set<ProvidedScriptCapability> getProvidedScriptCapabilities() {
        return Collections.unmodifiableSet(this.providedScriptCapabilities);
    }

    @NotNull
    public Set<RequiredResourceTypeCapability> getRequiredResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.requiredResourceTypeCapabilities);
    }

    @NotNull
    public Set<RequiredResourceTypeCapability> getUnresolvedRequiredResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.unresolvedRequiredResourceTypeCapabilities);
    }

    @NotNull
    public String getProvidedCapabilitiesString() {
        StringBuilder builder = new StringBuilder();
        int pcNum = this.getProvidedResourceTypeCapabilities().size();
        int psNum = this.getProvidedScriptCapabilities().size();
        int pcIndex = 0;
        int psIndex = 0;
        for (ProvidedResourceTypeCapability capability : this.getProvidedResourceTypeCapabilities()) {
            builder.append("sling.servlet").append(";");
            this.processListAttribute("sling.servlet.resourceTypes:List<String>", builder, capability.getResourceTypes());
            Optional.ofNullable(capability.getScriptEngine()).ifPresent(scriptEngine -> builder.append(";").append("scriptEngine").append("=").append("\"").append((String)scriptEngine).append("\""));
            Optional.ofNullable(capability.getScriptExtension()).ifPresent(scriptExtension -> builder.append(";").append("scriptExtension").append("=").append("\"").append((String)scriptExtension).append("\""));
            Optional.ofNullable(capability.getVersion()).ifPresent(version -> builder.append(";").append("version:Version").append("=").append("\"").append(version).append("\""));
            Optional.ofNullable(capability.getExtendsResourceType()).ifPresent(extendedResourceType -> builder.append(";").append("extends").append("=").append("\"").append((String)extendedResourceType).append("\""));
            Optional.ofNullable(capability.getRequestMethod()).ifPresent(method -> builder.append(";").append("sling.servlet.methods").append("=").append("\"").append((String)method).append("\""));
            Optional.ofNullable(capability.getRequestExtension()).ifPresent(requestExtension -> builder.append(";").append("sling.servlet.extensions").append("=").append("\"").append((String)requestExtension).append("\""));
            if (!capability.getSelectors().isEmpty()) {
                builder.append(";");
                this.processListAttribute("sling.servlet.selectors:List<String>", builder, capability.getSelectors());
            }
            if (pcIndex < pcNum - 1) {
                builder.append(",");
            }
            ++pcIndex;
        }
        if (builder.length() > 0 && psNum > 0) {
            builder.append(",");
        }
        for (ProvidedScriptCapability scriptCapability : this.getProvidedScriptCapabilities()) {
            builder.append("sling.servlet").append(";").append("sling.servlet.paths").append("=\"").append(scriptCapability.getPath()).append("\";").append("scriptEngine").append("=").append(scriptCapability.getScriptEngine()).append(";").append("scriptExtension").append("=").append(scriptCapability.getScriptExtension());
            if (psIndex < psNum - 1) {
                builder.append(",");
            }
            ++psIndex;
        }
        return builder.toString();
    }

    @NotNull
    public String getRequiredCapabilitiesString() {
        StringBuilder builder = new StringBuilder();
        int pcNum = this.getRequiredResourceTypeCapabilities().size();
        int pcIndex = 0;
        for (RequiredResourceTypeCapability capability : this.getRequiredResourceTypeCapabilities()) {
            builder.append("sling.servlet").append(";filter:=\"").append("(&(!(sling.servlet.selectors=*))");
            VersionRange versionRange = capability.getVersionRange();
            if (versionRange != null) {
                builder.append("(&").append(versionRange.toFilterString("version")).append("(").append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType()).append(")))\"");
            } else {
                builder.append("(").append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType()).append("))\"");
            }
            if (pcIndex < pcNum - 1) {
                builder.append(",");
            }
            ++pcIndex;
        }
        return builder.toString();
    }

    @NotNull
    public static Capabilities fromFileSystemTree(@NotNull Path root, @NotNull Stream<Path> files, @NotNull Logger logger, @NotNull Set<String> searchPaths, @NotNull Map<String, String> scriptEngineMappings) {
        LinkedHashSet<ProvidedResourceTypeCapability> providedResourceTypeCapabilities = new LinkedHashSet<ProvidedResourceTypeCapability>();
        LinkedHashSet<ProvidedScriptCapability> providedScriptCapabilities = new LinkedHashSet<ProvidedScriptCapability>();
        LinkedHashSet<RequiredResourceTypeCapability> requiredResourceTypeCapabilities = new LinkedHashSet<RequiredResourceTypeCapability>();
        FileProcessor fileProcessor = new FileProcessor(logger, searchPaths, scriptEngineMappings);
        ResourceTypeFolderAnalyser resourceTypeFolderAnalyser = new ResourceTypeFolderAnalyser(logger, root, fileProcessor);
        PathOnlyScriptAnalyser pathOnlyScriptAnalyser = new PathOnlyScriptAnalyser(logger, root, scriptEngineMappings, fileProcessor);
        files.forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Capabilities resourceTypeCapabilities = resourceTypeFolderAnalyser.getCapabilities((Path)path);
                providedResourceTypeCapabilities.addAll(resourceTypeCapabilities.getProvidedResourceTypeCapabilities());
                requiredResourceTypeCapabilities.addAll(resourceTypeCapabilities.getRequiredResourceTypeCapabilities());
            } else {
                Capabilities pathCapabilities = pathOnlyScriptAnalyser.getProvidedScriptCapability((Path)path);
                providedScriptCapabilities.addAll(pathCapabilities.getProvidedScriptCapabilities());
                requiredResourceTypeCapabilities.addAll(pathCapabilities.getRequiredResourceTypeCapabilities());
            }
        });
        return new Capabilities(providedResourceTypeCapabilities, providedScriptCapabilities, requiredResourceTypeCapabilities);
    }

    private void processListAttribute(@NotNull String capabilityAttribute, @NotNull StringBuilder builder, @NotNull Set<String> values) {
        builder.append(capabilityAttribute).append("=").append("\"");
        int valuesSize = values.size();
        int valueIndex = 0;
        for (String item : values) {
            builder.append(item);
            if (valueIndex < valuesSize - 1) {
                builder.append(",");
            }
            ++valueIndex;
        }
        builder.append("\"");
    }
}

