/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProvidedResourceTypeCapability {
    private final Set<String> resourceTypes;
    private final String scriptEngine;
    private final String scriptExtension;
    private final String extendsResourceType;
    private final String version;
    private final String requestExtension;
    private final String requestMethod;
    private final Set<String> selectors;

    private ProvidedResourceTypeCapability(@NotNull Set<String> resourceTypes, @Nullable String scriptEngine, @Nullable String scriptExtension, @Nullable String extendsResourceType, @Nullable String version, @Nullable String requestExtension, @Nullable String requestMethod, @NotNull Set<String> selectors) {
        this.resourceTypes = resourceTypes;
        this.scriptEngine = scriptEngine;
        this.scriptExtension = scriptExtension;
        this.extendsResourceType = extendsResourceType;
        this.version = version;
        this.requestExtension = requestExtension;
        this.requestMethod = requestMethod;
        this.selectors = selectors;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Set<String> getResourceTypes() {
        return Collections.unmodifiableSet(this.resourceTypes);
    }

    @Nullable
    public String getScriptEngine() {
        return this.scriptEngine;
    }

    @Nullable
    public String getScriptExtension() {
        return this.scriptExtension;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getRequestExtension() {
        return this.requestExtension;
    }

    @Nullable
    public String getExtendsResourceType() {
        return this.extendsResourceType;
    }

    @Nullable
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @NotNull
    public Set<String> getSelectors() {
        return Collections.unmodifiableSet(this.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.resourceTypes, this.scriptEngine, this.scriptExtension, this.version, this.requestExtension, this.extendsResourceType, this.requestMethod, this.selectors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProvidedResourceTypeCapability) {
            ProvidedResourceTypeCapability other = (ProvidedResourceTypeCapability)obj;
            return Objects.equals(this.resourceTypes, other.resourceTypes) && Objects.equals(this.scriptEngine, other.scriptEngine) && Objects.equals(this.scriptExtension, other.scriptExtension) && Objects.equals(this.version, other.version) && Objects.equals(this.requestExtension, other.requestExtension) && Objects.equals(this.extendsResourceType, other.extendsResourceType) && Objects.equals(this.requestMethod, other.requestMethod) && Objects.equals(this.selectors, other.selectors);
        }
        return false;
    }

    public String toString() {
        return String.format("%s{resourceTypes=%s, scriptEngine=%s, scriptEngineExtension=%s, version=%s, selectors=%s, requestExtension=%s, requestMethod=%s, extendsResourceType=%s}", this.getClass().getSimpleName(), this.resourceTypes, this.scriptEngine, this.scriptExtension, this.version, this.selectors, this.requestExtension, this.requestMethod, this.extendsResourceType);
    }

    public static class Builder {
        private Set<String> resourceTypes = new HashSet<String>();
        private String scriptEngine;
        private String scriptExtension;
        private String extendsResourceType;
        private String version;
        private String requestExtension;
        private String requestMethod;
        private Set<String> selectors = Collections.emptySet();

        public Builder withResourceTypes(@NotNull Set<String> resourceTypes) {
            if (resourceTypes.isEmpty()) {
                throw new IllegalArgumentException("The script's resourceTypes cannot be null or empty.");
            }
            this.resourceTypes = resourceTypes;
            return this;
        }

        public Builder withResourceType(@NotNull String resourceType) {
            if (StringUtils.isEmpty((CharSequence)resourceType)) {
                throw new IllegalArgumentException("The script's resourceType cannot be null or empty.");
            }
            this.resourceTypes.add(resourceType);
            return this;
        }

        public Builder withScriptEngine(String scriptEngine) {
            this.scriptEngine = scriptEngine;
            return this;
        }

        public Builder withScriptExtension(String scriptExtension) {
            this.scriptExtension = scriptExtension;
            return this;
        }

        public Builder withExtendsResourceType(String extendsResourceType) {
            this.extendsResourceType = extendsResourceType;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withRequestExtension(String requestExtension) {
            this.requestExtension = requestExtension;
            return this;
        }

        public Builder withRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder withSelectors(@NotNull Set<String> selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder fromCapability(@NotNull ProvidedResourceTypeCapability capability) {
            if (capability.getResourceTypes().isEmpty()) {
                throw new IllegalArgumentException("The script's resourceTypes cannot be null or empty.");
            }
            this.resourceTypes = capability.getResourceTypes();
            this.scriptEngine = capability.getScriptEngine();
            this.scriptExtension = capability.getScriptExtension();
            this.extendsResourceType = capability.getExtendsResourceType();
            this.version = capability.getVersion();
            this.requestExtension = capability.getRequestExtension();
            this.requestMethod = capability.getRequestMethod();
            this.selectors = capability.getSelectors();
            return this;
        }

        public ProvidedResourceTypeCapability build() {
            return new ProvidedResourceTypeCapability(this.resourceTypes, this.scriptEngine, this.scriptExtension, this.extendsResourceType, this.version, this.requestExtension, this.requestMethod, this.selectors);
        }
    }
}

