/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.sling.scriptingbundle.maven.plugin.FileProcessor;
import org.apache.sling.scriptingbundle.maven.plugin.PathOnlyScriptAnalyser;
import org.apache.sling.scriptingbundle.maven.plugin.ResourceTypeFolderAnalyser;
import org.apache.sling.scriptingbundle.maven.plugin.capability.Capabilities;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedScriptCapability;
import org.apache.sling.scriptingbundle.maven.plugin.capability.RequiredResourceTypeCapability;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Mojo(name="metadata", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class MetadataMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="scriptingbundle.sourceDirectories")
    private Set<String> sourceDirectories;
    @Parameter(property="scriptingbundle.includes", defaultValue="**")
    private String[] includes;
    @Parameter(property="scriptingbundle.excludes")
    private String[] excludes;
    @Parameter
    private Map<String, String> scriptEngineMappings;
    @Parameter(property="scriptingbundle.searchPaths")
    private Set<String> searchPaths;
    static final Set<String> METHODS = new HashSet<String>(Arrays.asList("TRACE", "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "PATCH"));
    static final String EXTENDS_FILE = "extends";
    static final String REQUIRES_FILE = "requires";
    static final String CAPABILITY_NS = "sling.servlet";
    static final String CAPABILITY_RESOURCE_TYPE_AT = "sling.servlet.resourceTypes:List<String>";
    static final String CAPABILITY_SELECTORS_AT = "sling.servlet.selectors:List<String>";
    static final String CAPABILITY_EXTENSIONS_AT = "sling.servlet.extensions";
    static final String CAPABILITY_METHODS_AT = "sling.servlet.methods";
    static final String CAPABILITY_PATH_AT = "sling.servlet.paths";
    static final String CAPABILITY_VERSION_AT = "version:Version";
    static final String CAPABILITY_EXTENDS_AT = "extends";
    static final String CAPABILITY_SCRIPT_ENGINE_AT = "scriptEngine";
    static final String CAPABILITY_SCRIPT_EXTENSION_AT = "scriptExtension";
    static final Map<String, String> DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING;
    static final Set<String> DEFAULT_SEARCH_PATHS;
    static final Set<String> DEFAULT_SOURCE_DIRECTORIES;
    static final String[] DEFAULT_EXCLUDES;
    private Capabilities capabilities;

    public void execute() {
        File workDirectory;
        this.capabilities = new Capabilities(new HashSet<ProvidedResourceTypeCapability>(), new HashSet<ProvidedScriptCapability>(), new HashSet<RequiredResourceTypeCapability>());
        if (this.sourceDirectories.isEmpty()) {
            this.sourceDirectories = new HashSet<String>(DEFAULT_SOURCE_DIRECTORIES);
        }
        if ((workDirectory = new File(new File(this.project.getBuild().getDirectory()), "scriptingbundle-maven-plugin")).exists() || workDirectory.mkdirs()) {
            this.sourceDirectories.stream().map(sourceDirectory -> {
                File sdFile = new File((String)sourceDirectory);
                if (!sdFile.exists()) {
                    sdFile = new File(this.project.getBasedir(), (String)sourceDirectory);
                }
                return sdFile;
            }).filter(sourceDirectory -> sourceDirectory.exists() && sourceDirectory.isDirectory()).forEach(sourceDirectory -> {
                DirectoryScanner scanner = this.getDirectoryScanner((File)sourceDirectory);
                try {
                    for (String file : scanner.getIncludedFiles()) {
                        String fileName = FilenameUtils.getName((String)file);
                        if ("extends".equals(fileName) || REQUIRES_FILE.equals(fileName)) {
                            Files.createDirectories(Paths.get(workDirectory.getAbsolutePath(), file).getParent(), new FileAttribute[0]);
                            Files.copy(Paths.get(sourceDirectory.getAbsolutePath(), file), Paths.get(workDirectory.getAbsolutePath(), file), StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                        Files.createDirectories(Paths.get(workDirectory.getAbsolutePath(), file).getParent(), new FileAttribute[0]);
                        new FileOutputStream(new File(workDirectory, file)).close();
                    }
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Unable to analyse project files.", (Throwable)e);
                }
            });
        }
        HashMap<String, String> mappings = new HashMap<String, String>(DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING);
        if (this.scriptEngineMappings != null) {
            mappings.putAll(this.scriptEngineMappings);
        }
        this.scriptEngineMappings = mappings;
        if (this.searchPaths == null || this.searchPaths.isEmpty()) {
            this.searchPaths = DEFAULT_SEARCH_PATHS;
        }
        DirectoryScanner scanner = this.getDirectoryScanner(workDirectory);
        this.capabilities = this.generateCapabilities(workDirectory.getAbsolutePath(), scanner);
        String providedCapabilitiesDefinition = this.getProvidedCapabilitiesString(this.capabilities);
        String requiredCapabilitiesDefinition = this.getRequiredCapabilitiesString(this.capabilities);
        String unresolvedRequiredCapabilitiesDefinition = this.getUnresolvedRequiredCapabilitiesString(this.capabilities);
        this.project.getProperties().put(((Object)((Object)this)).getClass().getPackage().getName() + "." + "Provide-Capability", providedCapabilitiesDefinition);
        this.project.getProperties().put(((Object)((Object)this)).getClass().getPackage().getName() + "." + "Require-Capability", requiredCapabilitiesDefinition);
        this.project.getProperties().put(((Object)((Object)this)).getClass().getPackage().getName() + ".Unresolved-" + "Require-Capability", unresolvedRequiredCapabilitiesDefinition);
    }

    @NotNull
    private DirectoryScanner getDirectoryScanner(@NotNull File directory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (this.includes == null || this.includes.length == 0) {
            scanner.setIncludes(new String[]{"**"});
        } else {
            scanner.setIncludes(this.includes);
        }
        if (this.excludes == null || this.excludes.length == 0) {
            scanner.setExcludes(DEFAULT_EXCLUDES);
        } else {
            scanner.setExcludes(this.excludes);
        }
        scanner.scan();
        return scanner;
    }

    @NotNull
    private Capabilities generateCapabilities(@NotNull String root, @NotNull DirectoryScanner scanner) {
        LinkedHashSet<ProvidedResourceTypeCapability> providedResourceTypeCapabilities = new LinkedHashSet<ProvidedResourceTypeCapability>();
        LinkedHashSet<ProvidedScriptCapability> providedScriptCapabilities = new LinkedHashSet<ProvidedScriptCapability>();
        LinkedHashSet<RequiredResourceTypeCapability> requiredResourceTypeCapabilities = new LinkedHashSet<RequiredResourceTypeCapability>();
        FileProcessor fileProcessor = new FileProcessor(this.getLog(), this.searchPaths, this.scriptEngineMappings);
        ResourceTypeFolderAnalyser resourceTypeFolderAnalyser = new ResourceTypeFolderAnalyser(this.getLog(), Paths.get(root, new String[0]), fileProcessor);
        PathOnlyScriptAnalyser pathOnlyScriptAnalyser = new PathOnlyScriptAnalyser(this.getLog(), Paths.get(root, new String[0]), this.scriptEngineMappings, fileProcessor);
        HashSet<String> includedDirectories = new HashSet<String>();
        for (String file2 : scanner.getIncludedFiles()) {
            includedDirectories.add(FilenameUtils.getFullPath((String)file2));
        }
        includedDirectories.stream().map(dir -> Paths.get(root, dir)).forEach(folder -> {
            Capabilities resourceTypeCapabilities = resourceTypeFolderAnalyser.getCapabilities((Path)folder);
            providedResourceTypeCapabilities.addAll(resourceTypeCapabilities.getProvidedResourceTypeCapabilities());
            requiredResourceTypeCapabilities.addAll(resourceTypeCapabilities.getRequiredResourceTypeCapabilities());
        });
        Arrays.stream(scanner.getIncludedFiles()).map(file -> Paths.get(root, file)).forEach(file -> {
            Capabilities pathCapabilities = pathOnlyScriptAnalyser.getProvidedScriptCapability((Path)file);
            providedScriptCapabilities.addAll(pathCapabilities.getProvidedScriptCapabilities());
            requiredResourceTypeCapabilities.addAll(pathCapabilities.getRequiredResourceTypeCapabilities());
        });
        return new Capabilities(providedResourceTypeCapabilities, providedScriptCapabilities, requiredResourceTypeCapabilities);
    }

    @NotNull
    private String getProvidedCapabilitiesString(Capabilities capabilities) {
        StringBuilder builder = new StringBuilder();
        int pcNum = capabilities.getProvidedResourceTypeCapabilities().size();
        int psNum = capabilities.getProvidedScriptCapabilities().size();
        int pcIndex = 0;
        int psIndex = 0;
        for (ProvidedResourceTypeCapability capability : capabilities.getProvidedResourceTypeCapabilities()) {
            builder.append(CAPABILITY_NS).append(";");
            this.processListAttribute(CAPABILITY_RESOURCE_TYPE_AT, builder, capability.getResourceTypes());
            Optional.ofNullable(capability.getScriptEngine()).ifPresent(scriptEngine -> builder.append(";").append(CAPABILITY_SCRIPT_ENGINE_AT).append("=").append("\"").append((String)scriptEngine).append("\""));
            Optional.ofNullable(capability.getScriptExtension()).ifPresent(scriptExtension -> builder.append(";").append(CAPABILITY_SCRIPT_EXTENSION_AT).append("=").append("\"").append((String)scriptExtension).append("\""));
            Optional.ofNullable(capability.getVersion()).ifPresent(version -> builder.append(";").append(CAPABILITY_VERSION_AT).append("=").append("\"").append((String)version).append("\""));
            Optional.ofNullable(capability.getExtendsResourceType()).ifPresent(extendedResourceType -> builder.append(";").append("extends").append("=").append("\"").append((String)extendedResourceType).append("\""));
            Optional.ofNullable(capability.getRequestMethod()).ifPresent(method -> builder.append(";").append(CAPABILITY_METHODS_AT).append("=").append("\"").append((String)method).append("\""));
            Optional.ofNullable(capability.getRequestExtension()).ifPresent(requestExtension -> builder.append(";").append(CAPABILITY_EXTENSIONS_AT).append("=").append("\"").append((String)requestExtension).append("\""));
            if (!capability.getSelectors().isEmpty()) {
                builder.append(";");
                this.processListAttribute(CAPABILITY_SELECTORS_AT, builder, capability.getSelectors());
            }
            if (pcIndex < pcNum - 1) {
                builder.append(",");
            }
            ++pcIndex;
        }
        if (builder.length() > 0 && psNum > 0) {
            builder.append(",");
        }
        for (ProvidedScriptCapability scriptCapability : capabilities.getProvidedScriptCapabilities()) {
            builder.append(CAPABILITY_NS).append(";").append(CAPABILITY_PATH_AT).append("=\"").append(scriptCapability.getPath()).append("\";").append(CAPABILITY_SCRIPT_ENGINE_AT).append("=").append(scriptCapability.getScriptEngine()).append(";").append(CAPABILITY_SCRIPT_EXTENSION_AT).append("=").append(scriptCapability.getScriptExtension());
            if (psIndex < psNum - 1) {
                builder.append(",");
            }
            ++psIndex;
        }
        return builder.toString();
    }

    private void processListAttribute(@NotNull String capabilityAttribute, @NotNull StringBuilder builder, @NotNull Set<String> values) {
        builder.append(capabilityAttribute).append("=").append("\"");
        int valuesSize = values.size();
        int valueIndex = 0;
        for (String item : values) {
            builder.append(item);
            if (valueIndex < valuesSize - 1) {
                builder.append(",");
            }
            ++valueIndex;
        }
        builder.append("\"");
    }

    @NotNull
    private String getRequiredCapabilitiesString(Capabilities capabilities) {
        StringBuilder builder = new StringBuilder();
        int pcNum = capabilities.getRequiredResourceTypeCapabilities().size();
        int pcIndex = 0;
        for (RequiredResourceTypeCapability capability : capabilities.getRequiredResourceTypeCapabilities()) {
            builder.append(CAPABILITY_NS).append(";filter:=\"").append("(&(!(sling.servlet.selectors=*))");
            VersionRange versionRange = capability.getVersionRange();
            if (versionRange != null) {
                builder.append("(&").append(versionRange.toFilterString("version")).append("(").append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType()).append(")))\"");
            } else {
                builder.append("(").append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType()).append("))\"");
            }
            if (pcIndex < pcNum - 1) {
                builder.append(",");
            }
            ++pcIndex;
        }
        return builder.toString();
    }

    @NotNull
    private String getUnresolvedRequiredCapabilitiesString(Capabilities capabilities) {
        StringBuilder builder = new StringBuilder();
        int pcNum = capabilities.getUnresolvedRequiredResourceTypeCapabilities().size();
        int pcIndex = 0;
        for (RequiredResourceTypeCapability capability : capabilities.getUnresolvedRequiredResourceTypeCapabilities()) {
            builder.append(CAPABILITY_NS).append(";");
            builder.append("sling.servlet.resourceTypes").append("=").append(capability.getResourceType());
            VersionRange versionRange = capability.getVersionRange();
            if (versionRange != null) {
                Version left = versionRange.getLeft();
                if (versionRange.getLeftType() == '(') {
                    left = new Version(left.getMajor(), left.getMinor(), left.getMicro() + 1);
                }
                builder.append(";").append(CAPABILITY_VERSION_AT).append("=").append(left);
            }
            if (pcIndex < pcNum - 1) {
                builder.append(",");
            }
            ++pcIndex;
        }
        return builder.toString();
    }

    Capabilities getCapabilities() {
        return this.capabilities;
    }

    Map<String, String> getScriptEngineMappings() {
        return this.scriptEngineMappings;
    }

    static {
        DEFAULT_EXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/.svn", "**/.svn/**", "**/.bzr", "**/.bzr/**", "**/.DS_Store", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**"};
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING = new HashMap<String, String>();
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("ftl", "freemarker");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("gst", "gstring");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("html", "htl");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("java", "java");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("esp", "rhino");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("ecma", "rhino");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("jsp", "jsp");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("jspf", "jsp");
        DEFAULT_EXTENSION_TO_SCRIPT_ENGINE_MAPPING.put("jspx", "jsp");
        DEFAULT_SEARCH_PATHS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("/libs", "/apps")));
        DEFAULT_SOURCE_DIRECTORIES = new HashSet<String>();
        DEFAULT_SOURCE_DIRECTORIES.add(Paths.get("src", "main", "scripts").toString());
        DEFAULT_SOURCE_DIRECTORIES.add(Paths.get("src", "main", "resources", "javax.script").toString());
    }
}

