/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin.capability;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedResourceTypeCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class RequiredResourceTypeCapability {
    private final String resourceType;
    private final VersionRange versionRange;

    private RequiredResourceTypeCapability(@NotNull String resourceType, @Nullable VersionRange versionRange) {
        this.resourceType = resourceType;
        this.versionRange = versionRange;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public String getResourceType() {
        return this.resourceType;
    }

    @Nullable
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public boolean isSatisfied(@NotNull ProvidedResourceTypeCapability providedResourceTypeCapability) {
        Set<String> providedSelectors = providedResourceTypeCapability.getSelectors();
        if (providedSelectors.isEmpty()) {
            for (String providedResourceType : providedResourceTypeCapability.getResourceTypes()) {
                if (!this.resourceType.equals(providedResourceType)) continue;
                if (this.versionRange == null) {
                    return true;
                }
                String providedVersion = providedResourceTypeCapability.getVersion();
                if (!StringUtils.isNotEmpty((CharSequence)providedVersion)) continue;
                return this.versionRange.includes(Version.parseVersion((String)providedVersion));
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%s{resourceType=%s, versionRange=%s}", this.getClass().getSimpleName(), this.resourceType, this.versionRange);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.versionRange);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RequiredResourceTypeCapability) {
            RequiredResourceTypeCapability other = (RequiredResourceTypeCapability)obj;
            return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.versionRange, other.versionRange);
        }
        return false;
    }

    public static class Builder {
        private String resourceType;
        private VersionRange versionRange;

        public RequiredResourceTypeCapability build() {
            return new RequiredResourceTypeCapability(this.resourceType, this.versionRange);
        }

        public Builder withResourceType(String resourceType) {
            if (StringUtils.isEmpty((CharSequence)resourceType)) {
                throw new NullPointerException("The required resourceType cannot be null or empty.");
            }
            this.resourceType = resourceType;
            return this;
        }

        public Builder withVersionRange(VersionRange versionRange) {
            this.versionRange = versionRange;
            return this;
        }
    }
}

