/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedScriptCapability;
import org.apache.sling.scriptingbundle.maven.plugin.capability.RequiredResourceTypeCapability;
import org.jetbrains.annotations.NotNull;

public class Capabilities {
    private final Set<ProvidedResourceTypeCapability> providedResourceTypeCapabilities;
    private final Set<ProvidedScriptCapability> providedScriptCapabilities;
    private final Set<RequiredResourceTypeCapability> requiredResourceTypeCapabilities;
    private final Set<RequiredResourceTypeCapability> unresolvedRequiredResourceTypeCapabilities;
    public static final Capabilities EMPTY = new Capabilities(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());

    public Capabilities(@NotNull Set<ProvidedResourceTypeCapability> providedResourceTypeCapabilities, @NotNull Set<ProvidedScriptCapability> providedScriptCapabilities, @NotNull Set<RequiredResourceTypeCapability> requiredResourceTypeCapabilities) {
        this.providedResourceTypeCapabilities = providedResourceTypeCapabilities;
        this.providedScriptCapabilities = providedScriptCapabilities;
        this.requiredResourceTypeCapabilities = requiredResourceTypeCapabilities;
        this.unresolvedRequiredResourceTypeCapabilities = new HashSet<RequiredResourceTypeCapability>(requiredResourceTypeCapabilities);
        providedResourceTypeCapabilities.forEach(providedResourceTypeCapability -> this.unresolvedRequiredResourceTypeCapabilities.removeIf(requiredResourceTypeCapability -> requiredResourceTypeCapability.isSatisfied((ProvidedResourceTypeCapability)providedResourceTypeCapability)));
    }

    @NotNull
    public Set<ProvidedResourceTypeCapability> getProvidedResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.providedResourceTypeCapabilities);
    }

    @NotNull
    public Set<ProvidedScriptCapability> getProvidedScriptCapabilities() {
        return Collections.unmodifiableSet(this.providedScriptCapabilities);
    }

    @NotNull
    public Set<RequiredResourceTypeCapability> getRequiredResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.requiredResourceTypeCapabilities);
    }

    @NotNull
    public Set<RequiredResourceTypeCapability> getUnresolvedRequiredResourceTypeCapabilities() {
        return Collections.unmodifiableSet(this.unresolvedRequiredResourceTypeCapabilities);
    }
}

