/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.scriptingbundle.maven.plugin.FileProcessor;
import org.apache.sling.scriptingbundle.maven.plugin.ResourceTypeFolderPredicate;
import org.apache.sling.scriptingbundle.maven.plugin.capability.Capabilities;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedResourceTypeCapability;
import org.apache.sling.scriptingbundle.maven.plugin.capability.RequiredResourceTypeCapability;
import org.apache.sling.servlets.resolver.bundle.tracker.ResourceType;
import org.jetbrains.annotations.NotNull;

class ResourceTypeFolderAnalyser {
    private final Log log;
    private final Path scriptsDirectory;
    private final ResourceTypeFolderPredicate resourceTypeFolderPredicate;
    private FileProcessor fileProcessor;

    ResourceTypeFolderAnalyser(@NotNull Log log, @NotNull Path scriptsDirectory, @NotNull FileProcessor fileProcessor) {
        this.log = log;
        this.scriptsDirectory = scriptsDirectory;
        this.resourceTypeFolderPredicate = new ResourceTypeFolderPredicate(log);
        this.fileProcessor = fileProcessor;
    }

    Capabilities getCapabilities(@NotNull Path resourceTypeDirectory) {
        LinkedHashSet<ProvidedResourceTypeCapability> providedCapabilities = new LinkedHashSet<ProvidedResourceTypeCapability>();
        LinkedHashSet<RequiredResourceTypeCapability> requiredCapabilities = new LinkedHashSet<RequiredResourceTypeCapability>();
        if (resourceTypeDirectory.startsWith(this.scriptsDirectory) && this.resourceTypeFolderPredicate.test(resourceTypeDirectory)) {
            try (DirectoryStream<Path> resourceTypeDirectoryStream = Files.newDirectoryStream(this.scriptsDirectory.resolve(resourceTypeDirectory));){
                Path relativeResourceTypeDirectory = this.scriptsDirectory.relativize(resourceTypeDirectory);
                ResourceType resourceType = ResourceType.parseResourceType((String)relativeResourceTypeDirectory.toString());
                resourceTypeDirectoryStream.forEach(entry -> {
                    if (Files.isRegularFile(entry, new LinkOption[0])) {
                        Path file2 = entry.getFileName();
                        if (file2 != null) {
                            if ("extends".equals(file2.toString())) {
                                this.fileProcessor.processExtendsFile(resourceType, (Path)entry, (Set<ProvidedResourceTypeCapability>)providedCapabilities, (Set<RequiredResourceTypeCapability>)requiredCapabilities);
                            } else if ("requires".equals(file2.toString())) {
                                this.fileProcessor.processRequiresFile((Path)entry, (Set<RequiredResourceTypeCapability>)requiredCapabilities);
                            } else {
                                this.fileProcessor.processScriptFile(resourceTypeDirectory, (Path)entry, resourceType, (Set<ProvidedResourceTypeCapability>)providedCapabilities);
                            }
                        }
                    } else if (Files.isDirectory(entry, new LinkOption[0]) && !this.resourceTypeFolderPredicate.test((Path)entry)) {
                        try (Stream<Path> selectorFilesStream = Files.walk(entry, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> {
                            Path fileParent = file.getParent();
                            while (!resourceTypeDirectory.equals(fileParent)) {
                                if (this.resourceTypeFolderPredicate.test(fileParent)) {
                                    return false;
                                }
                                fileParent = fileParent.getParent();
                            }
                            return true;
                        });){
                            selectorFilesStream.forEach(file -> this.fileProcessor.processScriptFile(resourceTypeDirectory, (Path)file, resourceType, providedCapabilities));
                        }
                        catch (IOException e) {
                            this.log.error((CharSequence)String.format("Unable to scan folder %s.", entry.toString()), (Throwable)e);
                        }
                    }
                });
            }
            catch (IOException | IllegalArgumentException e) {
                this.log.warn((CharSequence)String.format("Cannot analyse folder %s.", this.scriptsDirectory.resolve(resourceTypeDirectory).toString()), (Throwable)e);
            }
        }
        return new Capabilities(providedCapabilities, Collections.emptySet(), requiredCapabilities);
    }
}

