/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.scriptingbundle.maven.plugin.FileProcessor;
import org.apache.sling.scriptingbundle.maven.plugin.ResourceTypeFolderPredicate;
import org.apache.sling.scriptingbundle.maven.plugin.capability.Capabilities;
import org.apache.sling.scriptingbundle.maven.plugin.capability.ProvidedScriptCapability;
import org.apache.sling.scriptingbundle.maven.plugin.capability.RequiredResourceTypeCapability;
import org.jetbrains.annotations.NotNull;

public class PathOnlyScriptAnalyser {
    private final Path scriptsDirectory;
    private final Predicate<Path> isNotAResourceTypeFolder;
    private final Map<String, String> scriptEngineMappings;
    private final FileProcessor fileProcessor;

    public PathOnlyScriptAnalyser(@NotNull Log log, @NotNull Path scriptsDirectory, @NotNull Map<String, String> scriptEngineMappings, @NotNull FileProcessor fileProcessor) {
        this.scriptsDirectory = scriptsDirectory;
        this.isNotAResourceTypeFolder = new ResourceTypeFolderPredicate(log).negate();
        this.scriptEngineMappings = scriptEngineMappings;
        this.fileProcessor = fileProcessor;
    }

    @NotNull
    public Capabilities getProvidedScriptCapability(@NotNull Path file) {
        String filePath;
        String extension;
        if (Files.isRegularFile(file, new LinkOption[0]) && file.startsWith(this.scriptsDirectory) && StringUtils.isNotEmpty((CharSequence)(extension = FilenameUtils.getExtension((String)(filePath = file.toString())))) && this.scriptEngineMappings.containsKey(extension)) {
            String name;
            int dotLastIndex;
            Path fileName;
            Path parent;
            boolean useFile = true;
            for (Path loopParent = parent = file.getParent(); useFile && loopParent != null && !loopParent.equals(this.scriptsDirectory); loopParent = loopParent.getParent()) {
                useFile = this.isNotAResourceTypeFolder.test(loopParent);
            }
            if (parent != null && useFile && (fileName = file.getFileName()) != null && (dotLastIndex = (name = fileName.toString()).lastIndexOf(46)) > -1 && dotLastIndex != name.length() - 1) {
                String scriptPath = "/" + this.scriptsDirectory.relativize(file).toString();
                ProvidedScriptCapability providedScriptCapability = ProvidedScriptCapability.builder(this.scriptEngineMappings).withPath(scriptPath).build();
                Path requires = parent.resolve("requires");
                HashSet<RequiredResourceTypeCapability> requiredCapabilities = new HashSet<RequiredResourceTypeCapability>();
                if (Files.exists(requires, new LinkOption[0])) {
                    this.fileProcessor.processRequiresFile(requires, requiredCapabilities);
                }
                return new Capabilities(Collections.emptySet(), new HashSet<ProvidedScriptCapability>(Arrays.asList(providedScriptCapability)), requiredCapabilities);
            }
        }
        return Capabilities.EMPTY;
    }
}

