/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.maven.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Mojo(name="metadata", defaultPhase=LifecyclePhase.PACKAGE)
public class ScriptingMavenPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/javax.script")
    private String scriptsDirectory;
    private static final Set<String> METHODS = new HashSet<String>(Arrays.asList("TRACE", "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "PATCH"));
    private static final Set<String> FILE_SEPARATORS = new HashSet<String>(Arrays.asList("\\", "/"));

    public void execute() throws MojoExecutionException {
        File sdFile = new File(this.scriptsDirectory);
        if (!sdFile.exists() && !(sdFile = new File(this.project.getBasedir(), this.scriptsDirectory)).exists()) {
            throw new MojoExecutionException("Cannot find file " + this.scriptsDirectory + ".");
        }
        AtomicReference<File> scriptsDirectoryReference = new AtomicReference<File>();
        scriptsDirectoryReference.set(sdFile);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sdFile);
        scanner.setIncludes(new String[]{"**"});
        scanner.setExcludes(new String[]{"**/*.class"});
        scanner.addDefaultExcludes();
        scanner.scan();
        List scriptPaths = Stream.of(scanner.getIncludedFiles()).map(path -> new File((File)scriptsDirectoryReference.get(), (String)path)).map(file -> file.getPath().substring((((File)scriptsDirectoryReference.get()).getPath() + File.pathSeparatorChar).length())).collect(Collectors.toList());
        ArrayList<String> requires = new ArrayList<String>();
        ArrayList<String> capabilities = new ArrayList<String>();
        for (String scriptPath : scriptPaths) {
            Script script = ScriptingMavenPlugin.getScripts(scriptPath);
            String capability = "sling.resourceType;sling.resourceType=\"" + script.rt.replace("\"", "\\\"") + "\"";
            if (!(script.rt.equals(script.name) || script.rt.endsWith("." + script.name) || script.name.isEmpty())) {
                BufferedReader input;
                if (!script.name.equalsIgnoreCase("requires")) {
                    if (!script.name.equalsIgnoreCase("extends")) {
                        capability = capability + ";sling.resourceType.selectors:List<String>=\"" + script.name.replace("\"", "\\\"") + "\"";
                    } else {
                        try {
                            input = new BufferedReader(new FileReader(new File((File)scriptsDirectoryReference.get(), scriptPath)));
                            try {
                                String extend = input.readLine();
                                capability = capability + ";extends=\"" + extend.split(";")[0].replace("\"", "\\\"") + "\"";
                                requires.add(extend + ";extends=true");
                            }
                            finally {
                                input.close();
                            }
                        }
                        catch (Exception ex) {
                            this.getLog().error((Throwable)ex);
                        }
                    }
                } else {
                    try {
                        input = new BufferedReader(new FileReader(new File((File)scriptsDirectoryReference.get(), scriptPath)));
                        try {
                            String line = input.readLine();
                            while (line != null) {
                                requires.add(line);
                                line = input.readLine();
                            }
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (Exception ex) {
                        this.getLog().error((Throwable)ex);
                    }
                }
            }
            if (script.extension != null) {
                capability = capability + ";sling.resourceType.extensions:List<String>=\"" + script.extension.replace("\"", "\\\"") + "\"";
            }
            if (script.method != null) {
                capability = capability + ";sling.servlet.methods:List<String>=\"" + script.method.replace("\"", "\\\"") + "\"";
            }
            if (script.version != null) {
                capability = capability + ";version:Version=\"" + script.version + "\"";
            }
            capabilities.add(capability);
        }
        ArrayList<String> requirements = new ArrayList<String>();
        for (String require : requires) {
            String[] parts = require.split(";");
            String rt = parts[0];
            String filter = "(sling.resourceType=" + rt.replace("\"", "\\\"") + ")";
            if (parts.length > 1) {
                VersionRange range = new VersionRange(parts[1].substring(parts[1].indexOf("=") + 1).replace("\"", "").trim());
                filter = "(&" + filter + range.toFilterString("version") + ")";
            }
            if (parts.length > 2) {
                filter = "(&" + filter + "(!(sling.resourceType.selectors=*)))";
            }
            requirements.add("sling.resourceType;filter:=\"" + filter + "\"");
        }
        this.project.getProperties().setProperty(ScriptingMavenPlugin.class.getPackage().getName() + "." + "Provide-Capability", String.join((CharSequence)",", capabilities));
        this.project.getProperties().setProperty(ScriptingMavenPlugin.class.getPackage().getName() + "." + "Require-Capability", String.join((CharSequence)",", requirements));
    }

    static Script getScripts(String script) {
        String fileSeparator = null;
        for (String sep : FILE_SEPARATORS) {
            if (!script.contains(sep)) continue;
            fileSeparator = sep;
            break;
        }
        Script result = new Script();
        String[] parts = script.split(Pattern.quote(fileSeparator));
        result.rt = parts[0];
        result.version = parts.length > 2 ? new Version(parts[1]).toString() : null;
        result.name = parts.length > 2 ? parts[2] : parts[1];
        int idx = result.name.lastIndexOf(46);
        if (idx != -1) {
            result.scriptExtension = result.name.substring(idx + 1);
            result.name = result.name.substring(0, idx);
            if (result.scriptExtension.isEmpty()) {
                result.scriptExtension = null;
            }
        }
        if ((idx = result.name.lastIndexOf(46)) != -1) {
            result.extension = result.name.substring(idx + 1);
            result.name = result.name.substring(0, idx);
            if (result.extension.isEmpty() || result.extension.equalsIgnoreCase("html")) {
                result.extension = null;
            }
        } else {
            result.extension = null;
        }
        if ((idx = result.name.indexOf(46)) != -1) {
            String methodString = result.name.substring(0, idx).toUpperCase();
            if (METHODS.contains(methodString)) {
                result.method = methodString;
                result.name = result.name.substring(idx + 1);
            }
        } else if (METHODS.contains(result.name.toUpperCase())) {
            result.method = result.name.toUpperCase();
            result.name = "";
        }
        return result;
    }

    static class Script {
        String rt;
        String version;
        String name;
        String extension;
        String scriptExtension;
        String method;

        Script() {
        }
    }
}

