/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.AttributeGuardIntermediates;
import org.owasp.html.AttributeGuardMaker;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementPolicy;
import org.owasp.html.FilterUrlByProtocolAttributePolicy;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlElementTables;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTagSkipType;
import org.owasp.html.Joinable;
import org.owasp.html.PolicyFactory;
import org.owasp.html.SrcsetAttributePolicy;
import org.owasp.html.StandardUrlAttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.StylingPolicy;
import org.owasp.html.TCB;
import slingxss.com.google.common.base.Function;
import slingxss.com.google.common.base.Joiner;
import slingxss.com.google.common.base.Preconditions;
import slingxss.com.google.common.base.Predicate;
import slingxss.com.google.common.collect.ImmutableList;
import slingxss.com.google.common.collect.ImmutableMap;
import slingxss.com.google.common.collect.ImmutableSet;
import slingxss.com.google.common.collect.Maps;
import slingxss.com.google.common.collect.Sets;

@TCB
@NotThreadSafe
public class HtmlPolicyBuilder {
    public static final ImmutableSet<String> DEFAULT_SKIP_IF_EMPTY = ImmutableSet.of("a", "font", "img", "input", "span");
    static final ImmutableMap<String, HtmlTagSkipType> DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR;
    public static final ImmutableSet<String> DEFAULT_RELS_ON_TARGETTED_LINKS;
    static final String DEFAULT_RELS_ON_TARGETTED_LINKS_STR;
    private final Map<String, ElementPolicy> elPolicies = Maps.newLinkedHashMap();
    private final Map<String, Map<String, AttributePolicy>> attrPolicies = Maps.newLinkedHashMap();
    private final Map<String, AttributePolicy> globalAttrPolicies = Maps.newLinkedHashMap();
    private final Set<String> allowedProtocols = Sets.newLinkedHashSet();
    private final Map<String, HtmlTagSkipType> skipIssueTagMap = Maps.newLinkedHashMap(DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR);
    private final Map<String, Boolean> textContainers = Maps.newLinkedHashMap();
    private HtmlStreamEventProcessor postprocessor = HtmlStreamEventProcessor.Processors.IDENTITY;
    private HtmlStreamEventProcessor preprocessor = HtmlStreamEventProcessor.Processors.IDENTITY;
    private CssSchema stylingPolicySchema = null;
    private AttributePolicy styleUrlPolicy = AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY;
    private Set<String> extraRelsForLinks;
    private Set<String> skipRelsForLinks;
    private static HtmlElementTables METADATA;
    private static final Map<String, AttributeGuardMaker> ATTRIBUTE_GUARDS;
    private transient CompiledState compiledState;

    public HtmlPolicyBuilder allowElements(String ... elementNames) {
        return this.allowElements(ElementPolicy.IDENTITY_ELEMENT_POLICY, elementNames);
    }

    public HtmlPolicyBuilder disallowElements(String ... elementNames) {
        return this.allowElements(ElementPolicy.REJECT_ALL_ELEMENT_POLICY, elementNames);
    }

    public HtmlPolicyBuilder allowElements(ElementPolicy policy, String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            ElementPolicy newPolicy = ElementPolicy.Util.join(this.elPolicies.get(elementName), policy);
            this.elPolicies.put(elementName, newPolicy);
            if (this.textContainers.containsKey(elementName) || !METADATA.canContainPlainText(METADATA.indexForName(elementName))) continue;
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder allowCommonInlineFormattingElements() {
        return this.allowElements("b", "i", "font", "s", "u", "o", "sup", "sub", "ins", "del", "strong", "strike", "tt", "code", "big", "small", "br", "span", "em");
    }

    public HtmlPolicyBuilder allowCommonBlockElements() {
        return this.allowElements("p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote");
    }

    public HtmlPolicyBuilder allowTextIn(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowTextIn(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.textContainers.put(elementName, false);
        }
        return this;
    }

    public HtmlPolicyBuilder allowWithoutAttributes(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.skipIssueTagMap.put(elementName, HtmlTagSkipType.DO_NOT_SKIP);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowWithoutAttributes(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.skipIssueTagMap.put(elementName, HtmlTagSkipType.SKIP);
        }
        return this;
    }

    public AttributeBuilder allowAttributes(String ... attributeNames) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String attributeName : attributeNames) {
            b.add(HtmlLexer.canonicalAttributeName(attributeName));
        }
        return new AttributeBuilder((List<? extends String>)((Object)b.build()));
    }

    public AttributeBuilder disallowAttributes(String ... attributeNames) {
        return this.allowAttributes(attributeNames).matching(AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY);
    }

    private HtmlPolicyBuilder allowAttributesGlobally(AttributePolicy policy, List<String> attributeNames) {
        this.invalidateCompiledState();
        for (String attributeName : attributeNames) {
            AttributePolicy oldPolicy = this.globalAttrPolicies.get(attributeName);
            this.globalAttrPolicies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
        }
        return this;
    }

    private HtmlPolicyBuilder allowAttributesOnElements(AttributePolicy policy, List<String> attributeNames, List<String> elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            Map<String, AttributePolicy> policies = this.attrPolicies.get(elementName);
            if (policies == null) {
                policies = Maps.newLinkedHashMap();
                this.attrPolicies.put(elementName, policies);
            }
            for (String attributeName : attributeNames) {
                AttributePolicy oldPolicy = policies.get(attributeName);
                policies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
            }
        }
        return this;
    }

    public HtmlPolicyBuilder requireRelNofollowOnLinks() {
        return this.requireRelsOnLinks("nofollow");
    }

    public HtmlPolicyBuilder requireRelsOnLinks(String ... linkValues) {
        this.invalidateCompiledState();
        if (this.extraRelsForLinks == null) {
            this.extraRelsForLinks = Sets.newLinkedHashSet();
        }
        for (String linkValue : linkValues) {
            Preconditions.checkArgument(!Strings.containsHtmlSpace(linkValue = HtmlLexer.canonicalKeywordAttributeValue(linkValue)), "spaces in input.  use f(\"foo\", \"bar\") not f(\"foo bar\")");
            this.extraRelsForLinks.add(linkValue);
        }
        if (this.skipRelsForLinks != null) {
            this.skipRelsForLinks.removeAll(this.extraRelsForLinks);
        }
        return this;
    }

    public HtmlPolicyBuilder skipRelsOnLinks(String ... linkValues) {
        this.invalidateCompiledState();
        if (this.skipRelsForLinks == null) {
            this.skipRelsForLinks = Sets.newLinkedHashSet();
        }
        for (String linkValue : linkValues) {
            Preconditions.checkArgument(!Strings.containsHtmlSpace(linkValue = HtmlLexer.canonicalKeywordAttributeValue(linkValue)), "spaces in input.  use f(\"foo\", \"bar\") not f(\"foo bar\")");
            this.skipRelsForLinks.add(linkValue);
        }
        if (this.extraRelsForLinks != null) {
            this.extraRelsForLinks.removeAll(this.skipRelsForLinks);
        }
        return this;
    }

    public HtmlPolicyBuilder allowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.add(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.remove(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder allowStandardUrlProtocols() {
        return this.allowUrlProtocols("http", "https", "mailto");
    }

    public HtmlPolicyBuilder allowStyling() {
        this.allowStyling(CssSchema.DEFAULT);
        return this;
    }

    public HtmlPolicyBuilder allowStyling(CssSchema whitelist) {
        this.invalidateCompiledState();
        this.stylingPolicySchema = this.stylingPolicySchema == null ? whitelist : CssSchema.union(this.stylingPolicySchema, whitelist);
        this.allowAttributesGlobally(AttributePolicy.IDENTITY_ATTRIBUTE_POLICY, ImmutableList.of("style"));
        return this;
    }

    public HtmlPolicyBuilder allowUrlsInStyles(AttributePolicy newStyleUrlPolicy) {
        this.invalidateCompiledState();
        this.styleUrlPolicy = newStyleUrlPolicy;
        return this;
    }

    public HtmlPolicyBuilder withPreprocessor(HtmlStreamEventProcessor pp) {
        this.preprocessor = HtmlStreamEventProcessor.Processors.compose(this.preprocessor, pp);
        return this;
    }

    public HtmlPolicyBuilder withPostprocessor(HtmlStreamEventProcessor pp) {
        this.postprocessor = HtmlStreamEventProcessor.Processors.compose(this.postprocessor, pp);
        return this;
    }

    public HtmlSanitizer.Policy build(HtmlStreamEventReceiver out) {
        return this.toFactory().apply(out);
    }

    public <CTX> HtmlSanitizer.Policy build(HtmlStreamEventReceiver out, @Nullable HtmlChangeListener<? super CTX> listener, @Nullable CTX context) {
        return this.toFactory().apply(out, listener, context);
    }

    public PolicyFactory toFactory() {
        ImmutableSet.Builder textContainerSet = ImmutableSet.builder();
        for (Map.Entry<String, Boolean> textContainer : this.textContainers.entrySet()) {
            if (!Boolean.TRUE.equals(textContainer.getValue())) continue;
            textContainerSet.add(textContainer.getKey());
        }
        CompiledState compiled = this.compilePolicies();
        return new PolicyFactory(compiled.compiledPolicies, (ImmutableSet<String>)textContainerSet.build(), ImmutableMap.copyOf(compiled.globalAttrPolicies), this.preprocessor, this.postprocessor);
    }

    private void invalidateCompiledState() {
        this.compiledState = null;
    }

    private CompiledState compilePolicies() {
        if (this.compiledState != null) {
            return this.compiledState;
        }
        LinkedHashMap<String, ElementPolicy> elPolicies = Maps.newLinkedHashMap(this.elPolicies);
        LinkedHashMap<String, Map<String, AttributePolicy>> attrPolicies = Maps.newLinkedHashMap(this.attrPolicies);
        for (Map.Entry entry : attrPolicies.entrySet()) {
            entry.setValue(Maps.newLinkedHashMap((Map)entry.getValue()));
        }
        LinkedHashMap<String, AttributePolicy> globalAttrPolicies = Maps.newLinkedHashMap(this.globalAttrPolicies);
        ImmutableSet<String> immutableSet = ImmutableSet.copyOf(this.allowedProtocols);
        ElementPolicy linkPolicy = (ElementPolicy)elPolicies.get("a");
        if (linkPolicy != null) {
            RelsOnLinksPolicy relsOnLinksPolicy = RelsOnLinksPolicy.create(this.extraRelsForLinks != null ? this.extraRelsForLinks : ImmutableSet.of(), this.skipRelsForLinks != null ? this.skipRelsForLinks : ImmutableSet.of());
            elPolicies.put("a", ElementPolicy.Util.join(linkPolicy, relsOnLinksPolicy));
        }
        AttributePolicy urlAttributePolicy = immutableSet.size() == 3 && immutableSet.contains("mailto") && immutableSet.contains("http") && immutableSet.contains("https") ? StandardUrlAttributePolicy.INSTANCE : new FilterUrlByProtocolAttributePolicy(immutableSet);
        LinkedHashSet<String> toGuard = Sets.newLinkedHashSet(ATTRIBUTE_GUARDS.keySet());
        AttributeGuardIntermediates intermediates = new AttributeGuardIntermediates(urlAttributePolicy, this.styleUrlPolicy, this.stylingPolicySchema);
        for (Map.Entry<String, AttributeGuardMaker> entry : ATTRIBUTE_GUARDS.entrySet()) {
            String attributeName = entry.getKey();
            if (!globalAttrPolicies.containsKey(attributeName)) continue;
            toGuard.remove(attributeName);
            AttributePolicy guard = entry.getValue().makeGuard(intermediates);
            globalAttrPolicies.put(attributeName, AttributePolicy.Util.join(guard, (AttributePolicy)globalAttrPolicies.get(attributeName)));
        }
        for (Map.Entry<String, AttributeGuardMaker> entry : attrPolicies.entrySet()) {
            Map policies = (Map)((Object)entry.getValue());
            for (String attributeName : toGuard) {
                if (!policies.containsKey(attributeName)) continue;
                AttributePolicy guard = ATTRIBUTE_GUARDS.get(attributeName).makeGuard(intermediates);
                policies.put(attributeName, AttributePolicy.Util.join(guard, (AttributePolicy)policies.get(attributeName)));
            }
        }
        ImmutableMap.Builder<String, ElementAndAttributePolicies> policiesBuilder = ImmutableMap.builder();
        for (Map.Entry e : elPolicies.entrySet()) {
            AttributePolicy policy;
            String attributeName;
            String elementName = (String)e.getKey();
            ElementPolicy elementPolicy = (ElementPolicy)e.getValue();
            if (ElementPolicy.REJECT_ALL_ELEMENT_POLICY.equals(elementPolicy)) continue;
            ImmutableMap elAttrPolicies = (ImmutableMap)attrPolicies.get(elementName);
            if (elAttrPolicies == null) {
                elAttrPolicies = ImmutableMap.of();
            }
            ImmutableMap.Builder<String, AttributePolicy> attrs = ImmutableMap.builder();
            for (Map.Entry ape : elAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                if (globalAttrPolicies.containsKey(attributeName) || AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy = (AttributePolicy)ape.getValue())) continue;
                attrs.put(attributeName, policy);
            }
            for (Map.Entry ape : globalAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                policy = AttributePolicy.Util.join((AttributePolicy)elAttrPolicies.get(attributeName), (AttributePolicy)ape.getValue());
                if (AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy)) continue;
                attrs.put(attributeName, policy);
            }
            policiesBuilder.put(elementName, new ElementAndAttributePolicies(elementName, elementPolicy, attrs.build(), this.getHtmlTagSkipType(elementName)));
        }
        this.compiledState = new CompiledState(globalAttrPolicies, policiesBuilder.build());
        return this.compiledState;
    }

    private HtmlTagSkipType getHtmlTagSkipType(String elementName) {
        HtmlTagSkipType htmlTagSkipType = this.skipIssueTagMap.get(elementName);
        if (htmlTagSkipType == null) {
            if (DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR.containsKey(elementName)) {
                return HtmlTagSkipType.SKIP_BY_DEFAULT;
            }
            return HtmlTagSkipType.DO_NOT_SKIP_BY_DEFAULT;
        }
        return htmlTagSkipType;
    }

    static {
        ImmutableMap.Builder<String, Object> b = ImmutableMap.builder();
        for (String elementName : DEFAULT_SKIP_IF_EMPTY) {
            b.put(elementName, (Object)HtmlTagSkipType.SKIP_BY_DEFAULT);
        }
        DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR = b.build();
        DEFAULT_RELS_ON_TARGETTED_LINKS = ImmutableSet.of("noopener", "noreferrer");
        DEFAULT_RELS_ON_TARGETTED_LINKS_STR = Joiner.on(' ').join(DEFAULT_RELS_ON_TARGETTED_LINKS);
        METADATA = HtmlElementTables.get();
        b = ImmutableMap.builder();
        AttributeGuardMaker identityGuard = new AttributeGuardMaker(){

            @Override
            AttributePolicy makeGuard(AttributeGuardIntermediates intermediates) {
                return intermediates.urlAttributePolicy;
            }
        };
        for (String urlAttributeName : new String[]{"action", "archive", "background", "cite", "classid", "codebase", "data", "dsync", "formaction", "href", "icon", "longdesc", "manifest", "poster", "profile", "src", "usemap"}) {
            b.put(urlAttributeName, identityGuard);
        }
        b.put("style", new AttributeGuardMaker(){

            @Override
            AttributePolicy makeGuard(AttributeGuardIntermediates intermediates) {
                if (intermediates.cssSchema == null) {
                    return null;
                }
                final AttributePolicy styleUrlPolicyFinal = AttributePolicy.Util.join(intermediates.styleUrlPolicy, intermediates.urlAttributePolicy);
                return new StylingPolicy(intermediates.cssSchema, new Function<String, String>(){

                    @Override
                    public String apply(String url) {
                        return styleUrlPolicyFinal.apply("img", "src", url != null ? url : "about:invalid");
                    }
                });
            }
        });
        b.put("srcset", new AttributeGuardMaker(){

            @Override
            AttributePolicy makeGuard(AttributeGuardIntermediates intermediates) {
                return new SrcsetAttributePolicy(intermediates.urlAttributePolicy);
            }
        });
        ATTRIBUTE_GUARDS = b.build();
    }

    static final class JoinRelsOnLinksPolicies
    implements Joinable.JoinStrategy<ElementPolicy.JoinableElementPolicy> {
        static final JoinRelsOnLinksPolicies INSTANCE = new JoinRelsOnLinksPolicies();

        JoinRelsOnLinksPolicies() {
        }

        @Override
        public ElementPolicy.JoinableElementPolicy join(Iterable<? extends ElementPolicy.JoinableElementPolicy> toJoin) {
            LinkedHashSet<String> extra = Sets.newLinkedHashSet();
            LinkedHashSet<String> skip = Sets.newLinkedHashSet();
            for (ElementPolicy.JoinableElementPolicy joinableElementPolicy : toJoin) {
                RelsOnLinksPolicy p = (RelsOnLinksPolicy)joinableElementPolicy;
                extra.addAll(p.extra);
                skip.addAll(p.skip);
            }
            extra.removeAll(skip);
            return RelsOnLinksPolicy.create(extra, skip);
        }
    }

    private static final class RelsOnLinksPolicy
    implements ElementPolicy.JoinableElementPolicy {
        final ImmutableSet<String> extra;
        final ImmutableSet<String> skip;
        final ImmutableSet<String> whenTargetPresent;
        static final RelsOnLinksPolicy EMPTY = new RelsOnLinksPolicy(ImmutableSet.of(), ImmutableSet.of());

        static RelsOnLinksPolicy create(Set<? extends String> extra, Set<? extends String> skip) {
            if (extra.isEmpty() && skip.isEmpty()) {
                return EMPTY;
            }
            return new RelsOnLinksPolicy(extra, skip);
        }

        RelsOnLinksPolicy(Set<? extends String> extra, Set<? extends String> skip) {
            this.extra = ImmutableSet.copyOf(extra);
            this.skip = ImmutableSet.copyOf(skip);
            LinkedHashSet<String> targetOnly = Sets.newLinkedHashSet();
            targetOnly.addAll(DEFAULT_RELS_ON_TARGETTED_LINKS);
            targetOnly.removeAll(extra);
            targetOnly.removeAll(skip);
            this.whenTargetPresent = ImmutableSet.copyOf(targetOnly);
        }

        private static int indexOfAttributeValue(String canonAttrName, List<String> attrs) {
            int n = attrs.size();
            for (int i = 0; i < n; i += 2) {
                if (!canonAttrName.equals(attrs.get(i))) continue;
                return i + 1;
            }
            return -1;
        }

        @Override
        public String apply(String elementName, List<String> attrs) {
            if (RelsOnLinksPolicy.indexOfAttributeValue("href", attrs) >= 0) {
                boolean hasTarget;
                boolean bl = hasTarget = RelsOnLinksPolicy.indexOfAttributeValue("target", attrs) >= 0;
                if (hasTarget || !this.extra.isEmpty()) {
                    String relValue;
                    int relIndex = RelsOnLinksPolicy.indexOfAttributeValue("rel", attrs);
                    if (relIndex < 0 && hasTarget && this.extra.isEmpty() && this.skip.isEmpty()) {
                        relValue = DEFAULT_RELS_ON_TARGETTED_LINKS_STR;
                    } else {
                        int sblen;
                        StringBuilder sb = new StringBuilder();
                        if (relIndex >= 0) {
                            String rels = attrs.get(relIndex);
                            int left = 0;
                            int n = rels.length();
                            for (int i = 0; i <= n; ++i) {
                                if (i != n && !Strings.isHtmlSpace(rels.charAt(i))) continue;
                                if (left < i && (this.skip.isEmpty() || !this.skip.contains(Strings.toLowerCase(rels.substring(left, i))))) {
                                    sb.append(rels, left, i).append(' ');
                                }
                                left = i + 1;
                            }
                        }
                        for (String s : this.extra) {
                            sb.append(s).append(' ');
                        }
                        if (hasTarget) {
                            for (String s : this.whenTargetPresent) {
                                sb.append(s).append(' ');
                            }
                        }
                        relValue = (sblen = sb.length()) == 0 ? "" : sb.substring(0, sb.length() - 1);
                    }
                    if (relValue.isEmpty()) {
                        if (relIndex >= 0) {
                            attrs.subList(relIndex - 1, relIndex + 1).clear();
                        }
                    } else if (relIndex < 0) {
                        attrs.add("rel");
                        attrs.add(relValue);
                    } else {
                        attrs.set(relIndex, relValue);
                    }
                }
            }
            return elementName;
        }

        @Override
        public Joinable.JoinStrategy<ElementPolicy.JoinableElementPolicy> getJoinStrategy() {
            return JoinRelsOnLinksPolicies.INSTANCE;
        }
    }

    public final class AttributeBuilder {
        private final List<String> attributeNames;
        private AttributePolicy policy = AttributePolicy.IDENTITY_ATTRIBUTE_POLICY;

        AttributeBuilder(List<? extends String> attributeNames) {
            this.attributeNames = ImmutableList.copyOf(attributeNames);
        }

        public AttributeBuilder matching(AttributePolicy attrPolicy) {
            this.policy = AttributePolicy.Util.join(this.policy, attrPolicy);
            return this;
        }

        public AttributeBuilder matching(final Pattern pattern) {
            return this.matching(new AttributePolicy(){

                @Override
                @Nullable
                public String apply(String elementName, String attributeName, String value) {
                    return pattern.matcher(value).matches() ? value : null;
                }
            });
        }

        public AttributeBuilder matching(final Predicate<? super String> filter) {
            return this.matching(new AttributePolicy(){

                @Override
                @Nullable
                public String apply(String elementName, String attributeName, String value) {
                    return filter.apply(value) ? value : null;
                }
            });
        }

        public AttributeBuilder matching(boolean ignoreCase, String ... allowedValues) {
            return this.matching(ignoreCase, ImmutableSet.copyOf(allowedValues));
        }

        public AttributeBuilder matching(final boolean ignoreCase, Set<? extends String> allowedValues) {
            final ImmutableSet<? extends String> allowed = ImmutableSet.copyOf(allowedValues);
            return this.matching(new AttributePolicy(){

                @Override
                @Nullable
                public String apply(String elementName, String attributeName, String uncanonValue) {
                    String value = ignoreCase ? Strings.toLowerCase(uncanonValue) : uncanonValue;
                    return allowed.contains(value) ? value : null;
                }
            });
        }

        public HtmlPolicyBuilder globally() {
            if (this.attributeNames.get(0).equals("style")) {
                return HtmlPolicyBuilder.this.allowStyling();
            }
            return HtmlPolicyBuilder.this.allowAttributesGlobally(this.policy, this.attributeNames);
        }

        public HtmlPolicyBuilder onElements(String ... elementNames) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (String elementName : elementNames) {
                b.add(HtmlLexer.canonicalElementName(elementName));
            }
            return HtmlPolicyBuilder.this.allowAttributesOnElements(this.policy, this.attributeNames, (List)((Object)b.build()));
        }
    }

    private static final class CompiledState {
        final Map<String, AttributePolicy> globalAttrPolicies;
        final ImmutableMap<String, ElementAndAttributePolicies> compiledPolicies;

        CompiledState(Map<String, AttributePolicy> globalAttrPolicies, ImmutableMap<String, ElementAndAttributePolicies> compiledPolicies) {
            this.globalAttrPolicies = globalAttrPolicies;
            this.compiledPolicies = compiledPolicies;
        }
    }
}

