/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.owasp.esapi.reference.crypto.ReferenceEncryptedProperties;

public class EncryptedPropertiesUtils {
    public static void main(String[] args) throws Exception {
        String inFile = null;
        String outFile = null;
        boolean inFileEncrypted = true;
        boolean verbose = false;
        for (int i = 0; i < args.length; i += 2) {
            String paramType = args[i];
            if ("--in".equals(paramType) && args.length >= i + 1) {
                inFile = args[i + 1];
                continue;
            }
            if ("--out".equals(paramType) && args.length >= i + 1) {
                outFile = args[i + 1];
                continue;
            }
            if ("--in-encrypted".equals(paramType) && args.length >= i + 1) {
                inFileEncrypted = Boolean.valueOf(args[i + 1]);
                continue;
            }
            if (!"--verbose".equals(paramType) || args.length < i + 1) continue;
            verbose = Boolean.valueOf(args[i + 1]);
        }
        if (outFile == null) {
            outFile = inFile;
        }
        if (outFile == null) {
            System.out.println("You must specify an input file or output file");
            System.exit(1);
        }
        Properties props = EncryptedPropertiesUtils.loadProperties(inFile, inFileEncrypted);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String key = null;
        do {
            System.out.print("Enter key: ");
            key = br.readLine();
            if (props.containsKey(key)) {
                System.out.print("Key already exists. Replace? ");
                String confirm = br.readLine();
                if (!"y".equals(confirm) && !"yes".equals(confirm)) continue;
            }
            System.out.print("Enter value: ");
            String value = br.readLine();
            EncryptedPropertiesUtils.addProperty(props, key, value);
        } while (key != null && key.length() > 0);
        EncryptedPropertiesUtils.storeProperties(outFile, props, "Encrypted Properties File generated by org.owasp.esapi.reference.crypto.EncryptedPropertiesUtils");
        System.out.println("Encrypted Properties file output to " + outFile);
        if (verbose) {
            for (Object oKey : props.keySet()) {
                String sKey = (String)oKey;
                String value = props.getProperty(sKey);
                System.out.println("   " + sKey + "=" + value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String inFile, Boolean inFileEncrypted) throws IOException {
        ReferenceEncryptedProperties props;
        if (inFileEncrypted == null) {
            inFileEncrypted = true;
        }
        if (inFile != null) {
            File f = new File(inFile);
            if (!f.exists()) {
                System.out.println("Input properties file not found. Creating new.");
                props = new ReferenceEncryptedProperties();
            } else {
                String encrypted = inFileEncrypted != false ? "Encrypted" : "Plaintext";
                System.out.println(encrypted + " properties found in " + f.getAbsolutePath());
                Properties inProperties = inFileEncrypted != false ? new ReferenceEncryptedProperties() : new Properties();
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    inProperties.load(in);
                }
                finally {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e) {}
                }
                props = new ReferenceEncryptedProperties(inProperties);
            }
        } else {
            System.out.println("Input properties file not found. Creating new.");
            props = new ReferenceEncryptedProperties();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(String outFile, Properties props, String message) throws Exception {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(outFile));
            props.store(out, message);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static Object addProperty(Properties props, String key, String value) {
        if (props != null && key != null && key.length() > 0 && value != null && value.length() > 0) {
            return props.setProperty(key, value);
        }
        return null;
    }
}

