/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.util.List;
import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToHtmlContentContext
implements XSSFilterRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean check(PolicyHandler policyHandler, String str) {
        try {
            return policyHandler.getAntiSamy().scan(str).getNumberOfErrors() == 0;
        }
        catch (ScanException se) {
            this.log.warn("Unable to scan input.", (Throwable)se);
            this.log.debug("Provided input: {}", (Object)str);
        }
        catch (PolicyException pe) {
            this.log.warn("Unable to check input.", (Throwable)pe);
            this.log.debug("Provided input: {}", (Object)str);
        }
        return false;
    }

    @Override
    public String filter(PolicyHandler policyHandler, String str) {
        try {
            this.log.debug("Protecting (HTML -> HTML) :\n{}", (Object)str);
            CleanResults results = policyHandler.getAntiSamy().scan(str);
            String cleaned = results.getCleanHTML();
            List<String> errors = results.getErrorMessages();
            for (String error : errors) {
                this.log.info("AntiSamy warning: {}", (Object)error);
            }
            this.log.debug("Protected (HTML -> HTML):\n{}", (Object)cleaned);
            return cleaned;
        }
        catch (ScanException se) {
            this.log.warn("Unable to scan input.", (Throwable)se);
            this.log.debug("Provided input: {}", (Object)str);
        }
        catch (PolicyException pe) {
            this.log.warn("Unable to check input.", (Throwable)pe);
            this.log.debug("Provided input: {}", (Object)str);
        }
        return "";
    }

    @Override
    public boolean supportsPolicy() {
        return true;
    }
}

