/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.sling.tracer.internal.CallerFilter;

class PrefixExcludeFilter
implements CallerFilter {
    private final List<String> prefixesToExclude;

    public PrefixExcludeFilter(List<String> prefixes) {
        this.prefixesToExclude = ImmutableList.copyOf(prefixes);
    }

    public static PrefixExcludeFilter from(String filter) {
        List prefixes = Splitter.on((char)'|').omitEmptyStrings().trimResults().splitToList((CharSequence)filter);
        return new PrefixExcludeFilter(prefixes);
    }

    @Override
    public boolean include(StackTraceElement ste) {
        String className = ste.getClassName();
        for (String prefix : this.prefixesToExclude) {
            if (!className.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public List<String> getPrefixesToExclude() {
        return this.prefixesToExclude;
    }
}

