/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import javax.annotation.CheckForNull;

class CallerFinder {
    private final String[] apiPkgs;

    public CallerFinder(String[] apiPkgs) {
        this.apiPkgs = apiPkgs;
    }

    @CheckForNull
    public StackTraceElement determineCaller(StackTraceElement[] stack) {
        if (stack == null) {
            return null;
        }
        for (int i = stack.length - 1; i >= 0; --i) {
            StackTraceElement current = stack[i];
            if (i <= 0) continue;
            StackTraceElement next = stack[i - 1];
            for (String pkg : this.apiPkgs) {
                if (!next.getClassName().startsWith(pkg)) continue;
                return current;
            }
        }
        return null;
    }
}

