/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tooling.support.install.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.tooling.support.install.impl.InstallationResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Property(name="alias", value={"/system/sling/tooling/install"})
public class InstallServlet
extends HttpServlet {
    private static final long serialVersionUID = -8820366266126231409L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DIR = "dir";
    private static final int UPLOAD_IN_MEMORY_SIZE_THRESHOLD = 0x20000000;
    private BundleContext bundleContext;
    @Reference
    private PackageAdmin packageAdmin;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String dirPath = req.getParameter(DIR);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (dirPath == null && !isMultipart) {
            this.logger.error("No dir parameter specified : {} and no multipart content found", (Object)req.getParameterMap());
            resp.setStatus(500);
            InstallationResult result = new InstallationResult(false, "No dir parameter specified: " + req.getParameterMap() + " and no multipart content found");
            result.render(resp.getWriter());
            return;
        }
        if (isMultipart) {
            this.installBasedOnUploadedJar(req, resp);
        } else {
            this.installBasedOnDirectory(resp, new File(dirPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installBasedOnUploadedJar(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        InstallationResult result = null;
        try {
            String symbolicName;
            Manifest manifest;
            InputStream rawInput;
            JarInputStream jar;
            FileItem item;
            block11: {
                block10: {
                    DiskFileItemFactory factory = new DiskFileItemFactory();
                    factory.setSizeThreshold(0x20000000);
                    ServletFileUpload upload = new ServletFileUpload();
                    upload.setFileItemFactory((FileItemFactory)factory);
                    List items = upload.parseRequest(req);
                    if (items.size() != 1) {
                        this.logAndWriteError("Found " + items.size() + " items to process, but only updating 1 bundle is supported", resp);
                        return;
                    }
                    item = (FileItem)items.get(0);
                    jar = null;
                    rawInput = null;
                    jar = new JarInputStream(item.getInputStream());
                    manifest = jar.getManifest();
                    if (manifest != null) break block10;
                    this.logAndWriteError("Uploaded jar file does not contain a manifest", resp);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(jar);
                            IOUtils.closeQuietly(rawInput);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)jar);
                    IOUtils.closeQuietly(rawInput);
                    return;
                }
                symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (symbolicName != null) break block11;
                this.logAndWriteError("Manifest does not have a Bundle-SymbolicName", resp);
                IOUtils.closeQuietly((InputStream)jar);
                IOUtils.closeQuietly(rawInput);
                return;
            }
            String version = manifest.getMainAttributes().getValue("Bundle-Version");
            rawInput = item.getInputStream();
            Bundle found = this.getBundle(symbolicName);
            try {
                this.installOrUpdateBundle(found, rawInput, "inputstream:" + symbolicName + "-" + version + ".jar");
                result = new InstallationResult(true, null);
                resp.setStatus(200);
                result.render(resp.getWriter());
            }
            catch (BundleException e) {
                this.logAndWriteError("Unable to install/update bundle " + symbolicName, (Exception)((Object)e), resp);
                IOUtils.closeQuietly((InputStream)jar);
                IOUtils.closeQuietly((InputStream)rawInput);
                return;
            }
            IOUtils.closeQuietly((InputStream)jar);
            IOUtils.closeQuietly((InputStream)rawInput);
            return;
        }
        catch (FileUploadException e) {
            this.logAndWriteError("Failed parsing uploaded bundle", (Exception)((Object)e), resp);
            return;
        }
    }

    private void logAndWriteError(String message, HttpServletResponse resp) throws IOException {
        this.logger.info(message);
        resp.setStatus(500);
        new InstallationResult(false, message).render(resp.getWriter());
    }

    private void logAndWriteError(String message, Exception e, HttpServletResponse resp) throws IOException {
        this.logger.info(message, (Throwable)e);
        resp.setStatus(500);
        new InstallationResult(false, message + " : " + e.getMessage()).render(resp.getWriter());
    }

    /*
     * Exception decompiling
     */
    private void installBasedOnDirectory(HttpServletResponse resp, File dir) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void installOrUpdateBundle(Bundle bundle, InputStream in, String location) throws BundleException {
        if (bundle != null) {
            bundle.update(in);
        } else {
            Bundle b = this.bundleContext.installBundle(location, in);
            b.start();
        }
        this.packageAdmin.refreshPackages(new Bundle[]{bundle});
    }

    private Bundle getBundle(String symbolicName) {
        Bundle found = null;
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!symbolicName.equals(b.getSymbolicName())) continue;
            found = b;
            break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createJar(File sourceDir, File jarFile, Manifest mf) throws IOException {
        JarOutputStream zos = new JarOutputStream(new FileOutputStream(jarFile));
        try {
            zos.setLevel(0);
            ZipEntry anEntry = new ZipEntry("META-INF/MANIFEST.MF");
            zos.putNextEntry(anEntry);
            mf.write(zos);
            zos.closeEntry();
            InstallServlet.zipDir(sourceDir, zos, "");
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File sourceDir, ZipOutputStream zos, String path) throws IOException {
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        for (File f : sourceDir.listFiles()) {
            if (f.isDirectory()) {
                String prefix = path + f.getName() + "/";
                zos.putNextEntry(new ZipEntry(prefix));
                InstallServlet.zipDir(f, zos, prefix);
                continue;
            }
            String entry = path + f.getName();
            if ("META-INF/MANIFEST.MF".equals(entry)) continue;
            FileInputStream fis = new FileInputStream(f);
            try {
                ZipEntry anEntry = new ZipEntry(entry);
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
            }
            finally {
                fis.close();
            }
        }
    }

    protected void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected void unbindPackageAdmin(PackageAdmin packageAdmin) {
        if (this.packageAdmin == packageAdmin) {
            this.packageAdmin = null;
        }
    }
}

