/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.providers;

import com.google.common.net.MediaType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.thumbnails.extension.ThumbnailProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={ThumbnailProvider.class}, immediate=true)
public class PdfThumbnailProvider
implements ThumbnailProvider {
    @Override
    public boolean applies(Resource resource, String metaType) {
        return MediaType.PDF.is(MediaType.parse((String)metaType));
    }

    @Override
    public InputStream getThumbnail(Resource resource) throws IOException {
        try (PDDocument document = PDDocument.load((InputStream)((InputStream)resource.adaptTo(InputStream.class)));){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "jpeg", os);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
    }
}

