/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.thumbnails.Transformation;
import org.apache.sling.thumbnails.internal.TransformationServiceUser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TransformationCache.class, EventHandler.class}, property={"event.topics=org/apache/sling/api/resource/Resource/CHANGED", "event.filter=(&(resourceType=sling/thumbnails/transformation))"})
public class TransformationCache
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(TransformationCache.class);
    private final TransformationServiceUser transformationServiceUser;
    private final LoadingCache<String, Optional<String>> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

        public Optional<String> load(String name) throws LoginException {
            try (ResourceResolver resolver = TransformationCache.this.transformationServiceUser.getTransformationServiceUser();){
                Optional<String> optional = this.findTransformation(resolver, name);
                return optional;
            }
        }

        private Optional<String> findTransformation(ResourceResolver serviceResolver, String name) {
            name = name.substring(1).replace("'", "''");
            log.debug("Finding transformations with {}", (Object)name);
            Iterator transformations = serviceResolver.findResources("SELECT * FROM [nt:unstructured] WHERE (ISDESCENDANTNODE([/conf]) OR ISDESCENDANTNODE([/libs/conf]) OR ISDESCENDANTNODE([/apps/conf])) AND [sling:resourceType]='sling/thumbnails/transformation' AND [name]='" + name + "'", "JCR-SQL2");
            if (transformations.hasNext()) {
                Resource transformation = (Resource)transformations.next();
                log.debug("Found transformation resource: {}", (Object)transformation);
                return Optional.of(transformation.getPath());
            }
            return Optional.empty();
        }
    });

    @Activate
    public TransformationCache(@Reference TransformationServiceUser transformationServiceUser) {
        this.transformationServiceUser = transformationServiceUser;
    }

    public Optional<Transformation> getTransformation(ResourceResolver resolver, String name) throws ExecutionException {
        return ((Optional)this.cache.get((Object)name)).map(arg_0 -> ((ResourceResolver)resolver).getResource(arg_0)).map(r -> (Transformation)r.adaptTo(Transformation.class));
    }

    public void handleEvent(Event event) {
        this.cache.invalidateAll();
    }
}

