/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit5;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.junit5.SlingContext;
import org.apache.sling.testing.mock.sling.junit5.SlingContextStore;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public final class SlingContextExtension
implements ParameterResolver,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
AfterTestExecutionCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        Field slingContextField = this.getFieldFromTestInstance(testInstance, SlingContext.class);
        if (slingContextField != null) {
            SlingContext context = (SlingContext)((Object)slingContextField.get(testInstance));
            if (context != null) {
                if (!context.isSetUp()) {
                    context.setUpContext();
                }
                SlingContextStore.storeSlingContext(extensionContext, testInstance, context);
            } else {
                context = SlingContextStore.getOrCreateSlingContext(extensionContext, testInstance);
                slingContextField.set(testInstance, (Object)context);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return SlingContext.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return SlingContextStore.getOrCreateSlingContext(extensionContext, extensionContext.getRequiredTestInstance());
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.applySlingContext(extensionContext, slingContext -> slingContext.getContextPlugins().executeAfterSetUpCallback((OsgiContextImpl)slingContext));
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.applySlingContext(extensionContext, slingContext -> slingContext.getContextPlugins().executeBeforeTearDownCallback((OsgiContextImpl)slingContext));
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.applySlingContext(extensionContext, slingContext -> {
            slingContext.getContextPlugins().executeAfterTearDownCallback((OsgiContextImpl)slingContext);
            slingContext.tearDownContext();
            SlingContextStore.removeSlingContext(extensionContext, extensionContext.getRequiredTestInstance());
        });
    }

    private void applySlingContext(ExtensionContext extensionContext, Consumer<SlingContext> consumer) {
        SlingContext slingContext = SlingContextStore.getSlingContext(extensionContext, extensionContext.getRequiredTestInstance());
        if (slingContext != null) {
            consumer.accept(slingContext);
        }
    }

    private Field getFieldFromTestInstance(Object testInstance, Class<?> type) {
        Field contextField = Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> type.isAssignableFrom(field.getType())).findFirst().orElse(null);
        if (contextField != null) {
            contextField.setAccessible(true);
        }
        return contextField;
    }
}

