/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.testing.mock.sling.MockResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(service={ResourceBundleProvider.class})
public final class MockResourceBundleProvider
implements ResourceBundleProvider {
    private final ConcurrentHashMap<Key, MockResourceBundle> resourceBundleCache = new ConcurrentHashMap();
    private Locale defaultLocale = Locale.US;

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        Locale bundleLocale = locale != null ? locale : this.defaultLocale;
        Key key = new Key(baseName, bundleLocale);
        return this.resourceBundleCache.computeIfAbsent(key, k -> new MockResourceBundle(k.baseName, k.locale));
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    private static final class Key {
        final String baseName;
        final Locale locale;
        private final int hashCode;

        Key(String baseName, Locale locale) {
            int hc = 0;
            if (baseName != null) {
                hc += 17 * baseName.hashCode();
            }
            if (locale != null) {
                hc += 13 * locale.hashCode();
            }
            this.baseName = baseName;
            this.locale = locale;
            this.hashCode = hc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Key.equals(this.baseName, other.baseName) && Key.equals(this.locale, other.locale);
            }
            return false;
        }

        private static boolean equals(Object o1, Object o2) {
            return !(o1 == null ? o2 != null : !o1.equals(o2));
        }

        public String toString() {
            return "Key(" + this.baseName + ", " + this.locale + ")";
        }
    }
}

