/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProvider;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.apache.sling.testing.mock.osgi.MockEventAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockDynamicClassLoaderManager;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceResolverFactoryInitializer {
    private static final Logger log = LoggerFactory.getLogger(ResourceResolverFactoryInitializer.class);

    private ResourceResolverFactoryInitializer() {
    }

    @NotNull
    public static ResourceResolverFactory setUp(@Nullable SlingRepository slingRepository, @NotNull BundleContext bundleContext, @NotNull NodeTypeMode nodeTypeMode) {
        if (slingRepository != null) {
            ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, SlingRepository.class, slingRepository);
            ResourceResolverFactoryInitializer.registerJcrNodeTypes(slingRepository, nodeTypeMode);
            ResourceResolverFactoryInitializer.ensureJcrResourceProviderDependencies(bundleContext);
            ResourceResolverFactoryInitializer.initializeJcrResourceProvider(bundleContext);
        }
        ResourceResolverFactoryInitializer.ensureResourceResolverFactoryActivatorDependencies(bundleContext);
        ResourceResolverFactoryInitializer.initializeResourceResolverFactoryActivator(bundleContext);
        ServiceReference factoryRef = bundleContext.getServiceReference(ResourceResolverFactory.class);
        if (factoryRef == null) {
            throw new IllegalStateException("Unable to get ResourceResolverFactory.");
        }
        return (ResourceResolverFactory)bundleContext.getService(factoryRef);
    }

    private static void ensureJcrResourceProviderDependencies(@NotNull BundleContext bundleContext) {
        if (bundleContext.getServiceReference(DynamicClassLoaderManager.class) == null) {
            bundleContext.registerService(DynamicClassLoaderManager.class, (Object)new MockDynamicClassLoaderManager(), null);
        }
        try {
            Class<?> pathMapperClass = Class.forName("org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper");
            Object pathMapper = pathMapperClass.newInstance();
            try {
                Field pathMapperLoggerField = pathMapperClass.getDeclaredField("log");
                pathMapperLoggerField.setAccessible(true);
                pathMapperLoggerField.set(pathMapper, Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (proxy, method, methodArgs) -> null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, pathMapperClass, pathMapper);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void initializeJcrResourceProvider(@NotNull BundleContext bundleContext) {
        Hashtable config = new Hashtable();
        JcrResourceProvider provider = new JcrResourceProvider();
        MockOsgi.registerInjectActivateService((Object)provider, (BundleContext)bundleContext, (Object[])new Object[]{config});
    }

    private static void ensureResourceResolverFactoryActivatorDependencies(@NotNull BundleContext bundleContext) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        ((Dictionary)config).put("user.mapping", bundleContext.getBundle().getSymbolicName() + "=[admin]");
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, ServiceUserMapper.class, ServiceUserMapperImpl.class, config);
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, ResourceAccessSecurityTracker.class, ResourceAccessSecurityTracker.class);
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, EventAdmin.class, MockEventAdmin.class);
        ResourceResolverFactoryInitializer.registerServiceIfNotPresentByName(bundleContext, "org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider", "org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProviderImpl");
    }

    private static void initializeResourceResolverFactoryActivator(@NotNull BundleContext bundleContext) {
        Hashtable<String, String> config = new Hashtable<String, String>();
        ((Dictionary)config).put("resource.resolver.required.providers", "");
        ((Dictionary)config).put("resource.resolver.required.providernames", "");
        ResourceResolverFactoryActivator activator = new ResourceResolverFactoryActivator();
        MockOsgi.injectServices((Object)activator, (BundleContext)bundleContext);
        MockOsgi.activate((Object)activator, (BundleContext)bundleContext, config);
        bundleContext.registerService(ResourceResolverFactoryActivator.class.getName(), (Object)activator, config);
    }

    private static void registerServiceIfNotPresentByName(@NotNull BundleContext bundleContext, @NotNull String interfaceClassName, @NotNull String implClassName) {
        try {
            Class<?> interfaceClass = Class.forName(interfaceClassName);
            Class<?> implClass = Class.forName(implClassName);
            ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, interfaceClass, implClass.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            log.debug("registerServiceIfNotPresentByName: Skip registering {} ({}), bundleContext={}", new Object[]{implClassName, interfaceClassName, bundleContext});
        }
    }

    private static <T> void registerServiceIfNotPresent(@NotNull BundleContext bundleContext, @NotNull Class<T> serviceClass, @NotNull T instance) {
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, serviceClass, instance, new Hashtable<String, Object>());
    }

    private static <T> void registerServiceIfNotPresent(@NotNull BundleContext bundleContext, @NotNull Class<T> serviceClass, @NotNull T instance, Dictionary<String, Object> config) {
        if (bundleContext.getServiceReference(serviceClass.getName()) == null) {
            MockOsgi.registerInjectActivateService(instance, (BundleContext)bundleContext, (Object[])new Object[]{config});
        } else if (log.isDebugEnabled()) {
            log.debug("registerServiceIfNotPresent: Skip registering {} ({}) because already present, bundleContext={}", new Object[]{instance.getClass(), serviceClass, bundleContext});
        }
    }

    private static <T> void registerServiceIfNotPresent(@NotNull BundleContext bundleContext, @NotNull Class<T> serviceClass, @NotNull Class<?> implClass) {
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, serviceClass, implClass, new Hashtable<String, Object>());
    }

    private static <T> void registerServiceIfNotPresent(@NotNull BundleContext bundleContext, @NotNull Class<T> serviceClass, @NotNull Class<?> implClass, Dictionary<String, Object> config) {
        if (bundleContext.getServiceReference(serviceClass.getName()) == null) {
            Object instance = MockOsgi.activateInjectServices(implClass, (BundleContext)bundleContext, (Object[])new Object[]{config});
            bundleContext.registerService(serviceClass, instance, config);
        }
    }

    private static void registerJcrNodeTypes(SlingRepository slingRepository, NodeTypeMode nodeTypeMode) {
        Session session = null;
        try {
            session = slingRepository.loginAdministrative(null);
            NodeTypeDefinitionScanner.get().register(session, nodeTypeMode);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Error registering JCR nodetypes: " + ex.getMessage(), ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

