/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import java.util.Set;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.apache.sling.testing.mock.sling.context.models.OsgiServiceModel;
import org.apache.sling.testing.mock.sling.context.models.RequestAttributeModel;
import org.apache.sling.testing.mock.sling.context.models.ServiceInterface;
import org.apache.sling.testing.mock.sling.context.modelsautoreg.ClasspathRegisteredModel;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.apache.sling.testing.mock.sling.services.MockMimeTypeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public abstract class AbstractSlingContextImplTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());

    @Before
    public void setUp() throws Exception {
        Assert.assertEquals((long)1L, (long)((ResourceResolverFactory[])this.context.getServices(ResourceResolverFactory.class, null)).length);
        this.context.addModelsForPackage("org.apache.sling.testing.mock.sling.context.models");
        ContentLoader contentLoader = this.context.load();
        contentLoader.json("/json-import-samples/content.json", "/content/sample/en");
    }

    protected abstract ResourceResolverType getResourceResolverType();

    @Test
    public void testContextObjects() {
        Assert.assertNotNull((Object)this.context.componentContext());
        Assert.assertNotNull((Object)this.context.bundleContext());
        Assert.assertNotNull((Object)this.context.resourceResolver());
        Assert.assertNotNull((Object)this.context.request());
        Assert.assertNotNull((Object)this.context.requestPathInfo());
        Assert.assertNotNull((Object)this.context.response());
        Assert.assertNotNull((Object)this.context.slingScriptHelper());
    }

    @Test
    public void testSlingBindings() {
        SlingBindings bindings = (SlingBindings)this.context.request().getAttribute(SlingBindings.class.getName());
        Assert.assertNotNull((Object)bindings);
        Assert.assertSame((Object)this.context.request(), (Object)bindings.get((Object)"request"));
        Assert.assertSame((Object)this.context.response(), (Object)bindings.get((Object)"response"));
        Assert.assertSame((Object)this.context.slingScriptHelper(), (Object)bindings.get((Object)"sling"));
    }

    @Test
    public void testSetCurrentResource() {
        this.context.currentResource("/content/sample/en/jcr:content/par/colctrl");
        Assert.assertEquals((Object)"/content/sample/en/jcr:content/par/colctrl", (Object)this.context.currentResource().getPath());
        this.context.currentResource(this.context.resourceResolver().getResource("/content/sample/en/jcr:content/par"));
        Assert.assertEquals((Object)"/content/sample/en/jcr:content/par", (Object)this.context.currentResource().getPath());
        this.context.currentResource(null);
        Assert.assertNull((Object)this.context.request().getResource());
        this.context.currentResource(null);
        Assert.assertNull((Object)this.context.request().getResource());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCurrentResourceNonExisting() {
        this.context.currentResource("/non/existing");
    }

    @Test
    public void testSlingModelsRequestAttribute() {
        this.context.request().setAttribute("prop1", (Object)"myValue");
        RequestAttributeModel model = (RequestAttributeModel)this.context.request().adaptTo(RequestAttributeModel.class);
        Assert.assertEquals((Object)"myValue", (Object)model.getProp1());
    }

    @Test
    public void testSlingModelsOsgiService() {
        this.context.registerService(new MockMimeTypeService());
        OsgiServiceModel model = (OsgiServiceModel)this.context.resourceResolver().adaptTo(OsgiServiceModel.class);
        Assert.assertNotNull((Object)model.getMimeTypeService());
        Assert.assertEquals((Object)"text/html", (Object)model.getMimeTypeService().getMimeType("html"));
    }

    @Test
    public void testSlingModelsInvalidAdapt() {
        OsgiServiceModel model = (OsgiServiceModel)this.context.request().adaptTo(OsgiServiceModel.class);
        Assert.assertNull((Object)model);
    }

    @Test
    public void testSlnigModelClasspathRegistered() {
        this.context.request().setAttribute("prop1", (Object)"myValue");
        ClasspathRegisteredModel model = (ClasspathRegisteredModel)this.context.request().adaptTo(ClasspathRegisteredModel.class);
        Assert.assertEquals((Object)"myValue", (Object)model.getProp1());
    }

    @Test
    public void testAdaptToInterface() {
        this.context.request().setAttribute("prop1", (Object)"myValue");
        ServiceInterface model = (ServiceInterface)this.context.request().adaptTo(ServiceInterface.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"myValue", (Object)model.getPropValue());
    }

    @Test
    public void testRunModes() {
        SlingSettingsService slingSettings = (SlingSettingsService)this.context.getService(SlingSettingsService.class);
        Assert.assertEquals((Object)SlingContextImpl.DEFAULT_RUN_MODES, (Object)slingSettings.getRunModes());
        this.context.runMode(new String[]{"mode1", "mode2"});
        Set newRunModes = slingSettings.getRunModes();
        Assert.assertEquals((long)2L, (long)newRunModes.size());
        Assert.assertTrue((boolean)newRunModes.contains("mode1"));
        Assert.assertTrue((boolean)newRunModes.contains("mode2"));
    }

    @Test(expected=IllegalStateException.class)
    public void testReRegisteringResourceResolverFaactory() {
        MockSling.newResourceResolver((BundleContext)this.context.bundleContext());
    }
}

