/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.apache.sling.testing.mock.sling.RRMockResourceResolverWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class RRMockResourceResolverFactoryWrapper
implements ResourceResolverFactory,
ServiceTrackerCustomizer<ResourceProvider, ResourceProvider> {
    private final ResourceResolverFactory delegate;
    private final BundleContext bundleContext;
    private final ServiceTracker<ResourceProvider, ResourceProvider> serviceTracker;
    private final ConcurrentMap<String, ResourceProvider> resourceProviders = new ConcurrentHashMap<String, ResourceProvider>();

    RRMockResourceResolverFactoryWrapper(ResourceResolverFactory delegate, BundleContext bundleContext) {
        this.delegate = delegate;
        this.bundleContext = bundleContext;
        this.serviceTracker = new ServiceTracker(bundleContext, ResourceProvider.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    @NotNull
    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.wrap(this.delegate.getResourceResolver(authenticationInfo));
    }

    @Deprecated
    @NotNull
    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.wrap(this.delegate.getAdministrativeResourceResolver(authenticationInfo));
    }

    @NotNull
    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.wrap(this.delegate.getServiceResourceResolver(authenticationInfo));
    }

    @Nullable
    public ResourceResolver getThreadResourceResolver() {
        return this.wrap(this.delegate.getThreadResourceResolver());
    }

    private ResourceResolver wrap(ResourceResolver resourceResolver) {
        return new RRMockResourceResolverWrapper(resourceResolver, this.resourceProviders);
    }

    public ResourceProvider addingService(ServiceReference<ResourceProvider> reference) {
        String rootPath = this.getRootPath(reference);
        ResourceProvider service = (ResourceProvider)this.bundleContext.getService(reference);
        if (rootPath != null) {
            this.resourceProviders.put(rootPath, service);
        }
        return service;
    }

    public void modifiedService(ServiceReference<ResourceProvider> reference, ResourceProvider service) {
    }

    public void removedService(ServiceReference<ResourceProvider> reference, ResourceProvider service) {
        String rootPath = this.getRootPath(reference);
        if (rootPath != null) {
            this.resourceProviders.remove(rootPath);
        }
    }

    private String getRootPath(ServiceReference<ResourceProvider> reference) {
        Object value = reference.getProperty("provider.root");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

